/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vault.model.SecretRule;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType")
@JsonFilter(value="explicitlySetFilter")
public final class SecretExpiryRule
extends SecretRule {
    @JsonProperty(value="secretVersionExpiryInterval")
    private final String secretVersionExpiryInterval;
    @JsonProperty(value="timeOfAbsoluteExpiry")
    private final Date timeOfAbsoluteExpiry;
    @JsonProperty(value="isSecretContentRetrievalBlockedOnExpiry")
    private final Boolean isSecretContentRetrievalBlockedOnExpiry;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SecretExpiryRule(String secretVersionExpiryInterval, Date timeOfAbsoluteExpiry, Boolean isSecretContentRetrievalBlockedOnExpiry) {
        this.secretVersionExpiryInterval = secretVersionExpiryInterval;
        this.timeOfAbsoluteExpiry = timeOfAbsoluteExpiry;
        this.isSecretContentRetrievalBlockedOnExpiry = isSecretContentRetrievalBlockedOnExpiry;
    }

    public String getSecretVersionExpiryInterval() {
        return this.secretVersionExpiryInterval;
    }

    public Date getTimeOfAbsoluteExpiry() {
        return this.timeOfAbsoluteExpiry;
    }

    public Boolean getIsSecretContentRetrievalBlockedOnExpiry() {
        return this.isSecretContentRetrievalBlockedOnExpiry;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecretExpiryRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", secretVersionExpiryInterval=").append(String.valueOf(this.secretVersionExpiryInterval));
        sb.append(", timeOfAbsoluteExpiry=").append(String.valueOf(this.timeOfAbsoluteExpiry));
        sb.append(", isSecretContentRetrievalBlockedOnExpiry=").append(String.valueOf(this.isSecretContentRetrievalBlockedOnExpiry));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretExpiryRule)) {
            return false;
        }
        SecretExpiryRule other = (SecretExpiryRule)((Object)o);
        return Objects.equals(this.secretVersionExpiryInterval, other.secretVersionExpiryInterval) && Objects.equals(this.timeOfAbsoluteExpiry, other.timeOfAbsoluteExpiry) && Objects.equals(this.isSecretContentRetrievalBlockedOnExpiry, other.isSecretContentRetrievalBlockedOnExpiry) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.secretVersionExpiryInterval == null ? 43 : this.secretVersionExpiryInterval.hashCode());
        result = result * 59 + (this.timeOfAbsoluteExpiry == null ? 43 : this.timeOfAbsoluteExpiry.hashCode());
        result = result * 59 + (this.isSecretContentRetrievalBlockedOnExpiry == null ? 43 : this.isSecretContentRetrievalBlockedOnExpiry.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="secretVersionExpiryInterval")
        private String secretVersionExpiryInterval;
        @JsonProperty(value="timeOfAbsoluteExpiry")
        private Date timeOfAbsoluteExpiry;
        @JsonProperty(value="isSecretContentRetrievalBlockedOnExpiry")
        private Boolean isSecretContentRetrievalBlockedOnExpiry;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder secretVersionExpiryInterval(String secretVersionExpiryInterval) {
            this.secretVersionExpiryInterval = secretVersionExpiryInterval;
            this.__explicitlySet__.add("secretVersionExpiryInterval");
            return this;
        }

        public Builder timeOfAbsoluteExpiry(Date timeOfAbsoluteExpiry) {
            this.timeOfAbsoluteExpiry = timeOfAbsoluteExpiry;
            this.__explicitlySet__.add("timeOfAbsoluteExpiry");
            return this;
        }

        public Builder isSecretContentRetrievalBlockedOnExpiry(Boolean isSecretContentRetrievalBlockedOnExpiry) {
            this.isSecretContentRetrievalBlockedOnExpiry = isSecretContentRetrievalBlockedOnExpiry;
            this.__explicitlySet__.add("isSecretContentRetrievalBlockedOnExpiry");
            return this;
        }

        public SecretExpiryRule build() {
            SecretExpiryRule model = new SecretExpiryRule(this.secretVersionExpiryInterval, this.timeOfAbsoluteExpiry, this.isSecretContentRetrievalBlockedOnExpiry);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecretExpiryRule model) {
            if (model.wasPropertyExplicitlySet("secretVersionExpiryInterval")) {
                this.secretVersionExpiryInterval(model.getSecretVersionExpiryInterval());
            }
            if (model.wasPropertyExplicitlySet("timeOfAbsoluteExpiry")) {
                this.timeOfAbsoluteExpiry(model.getTimeOfAbsoluteExpiry());
            }
            if (model.wasPropertyExplicitlySet("isSecretContentRetrievalBlockedOnExpiry")) {
                this.isSecretContentRetrievalBlockedOnExpiry(model.getIsSecretContentRetrievalBlockedOnExpiry());
            }
            return this;
        }
    }
}

