/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileUtil;

public abstract class TmpLocalFile {
    private static final Logger LOGGER = Logger.getLogger(TmpLocalFile.class.getName());

    TmpLocalFile() {
    }

    public static TmpLocalFile inMemory(int size) {
        return new MemoryTmpLocalFile(size);
    }

    public static TmpLocalFile onDisk() {
        return TmpLocalFile.onDisk(null);
    }

    public static TmpLocalFile onDisk(String extension) {
        try {
            return new DiskTmpLocalFile(extension);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot create local tmp file", ex);
            return null;
        }
    }

    public abstract boolean isInMemory();

    public abstract String getAbsolutePath();

    public abstract OutputStream getOutputStream();

    public abstract InputStream getInputStream();

    public abstract void cleanup();

    public abstract String toString();

    private static final class MemoryTmpLocalFile
    extends TmpLocalFile {
        private final ByteArrayOutputStream outputStream;

        public MemoryTmpLocalFile(int size) {
            this.outputStream = new ByteArrayOutputStream(size);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public boolean isInMemory() {
            return true;
        }

        @Override
        public String getAbsolutePath() {
            return null;
        }

        @Override
        public OutputStream getOutputStream() {
            this.outputStream.reset();
            return this.outputStream;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public String toString() {
            return "<MemoryTmpLocalFile>";
        }
    }

    private static final class DiskTmpLocalFile
    extends TmpLocalFile {
        private static final Logger LOGGER = Logger.getLogger(DiskTmpLocalFile.class.getName());
        private final File file;

        public DiskTmpLocalFile(String extension) throws IOException {
            this.file = FileUtil.normalizeFile((File)Files.createTempFile("nb-php-remote-tmp-file-", extension != null ? "." + extension : null, new FileAttribute[0]).toFile());
            this.file.deleteOnExit();
        }

        @Override
        public void cleanup() {
            if (!this.file.delete()) {
                LOGGER.info("Cannot delete temporary file");
            }
        }

        @Override
        public boolean isInMemory() {
            return false;
        }

        @Override
        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public OutputStream getOutputStream() {
            try {
                return new BufferedOutputStream(new FileOutputStream(this.file));
            }
            catch (FileNotFoundException ex) {
                LOGGER.log(Level.INFO, "Cannot create output stream for local tmp file", ex);
                return null;
            }
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException ex) {
                LOGGER.log(Level.INFO, "Cannot create input stream for local tmp file", ex);
                return null;
            }
        }

        @Override
        public String toString() {
            return "<DiskTmpLocalFile<" + this.file.getAbsolutePath() + ">>";
        }
    }
}

