/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.MaintenanceWindow;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateCloudAutonomousVmClusterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="cloudExadataInfrastructureId")
    private final String cloudExadataInfrastructureId;
    @JsonProperty(value="totalContainerDatabases")
    private final Integer totalContainerDatabases;
    @JsonProperty(value="cpuCoreCountPerNode")
    private final Integer cpuCoreCountPerNode;
    @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
    private final Integer memoryPerOracleComputeUnitInGBs;
    @JsonProperty(value="autonomousDataStorageSizeInTBs")
    private final Double autonomousDataStorageSizeInTBs;
    @JsonProperty(value="clusterTimeZone")
    private final String clusterTimeZone;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;
    @JsonProperty(value="isMtlsEnabledVmCluster")
    private final Boolean isMtlsEnabledVmCluster;
    @JsonProperty(value="dbServers")
    private final List<String> dbServers;
    @JsonProperty(value="maintenanceWindowDetails")
    private final MaintenanceWindow maintenanceWindowDetails;
    @JsonProperty(value="scanListenerPortTls")
    private final Integer scanListenerPortTls;
    @JsonProperty(value="scanListenerPortNonTls")
    private final Integer scanListenerPortNonTls;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "description", "subnetId", "displayName", "cloudExadataInfrastructureId", "totalContainerDatabases", "cpuCoreCountPerNode", "memoryPerOracleComputeUnitInGBs", "autonomousDataStorageSizeInTBs", "clusterTimeZone", "computeModel", "isMtlsEnabledVmCluster", "dbServers", "maintenanceWindowDetails", "scanListenerPortTls", "scanListenerPortNonTls", "licenseModel", "nsgIds", "freeformTags", "definedTags"})
    public CreateCloudAutonomousVmClusterDetails(String compartmentId, String description, String subnetId, String displayName, String cloudExadataInfrastructureId, Integer totalContainerDatabases, Integer cpuCoreCountPerNode, Integer memoryPerOracleComputeUnitInGBs, Double autonomousDataStorageSizeInTBs, String clusterTimeZone, ComputeModel computeModel, Boolean isMtlsEnabledVmCluster, List<String> dbServers, MaintenanceWindow maintenanceWindowDetails, Integer scanListenerPortTls, Integer scanListenerPortNonTls, LicenseModel licenseModel, List<String> nsgIds, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.description = description;
        this.subnetId = subnetId;
        this.displayName = displayName;
        this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        this.totalContainerDatabases = totalContainerDatabases;
        this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        this.clusterTimeZone = clusterTimeZone;
        this.computeModel = computeModel;
        this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
        this.dbServers = dbServers;
        this.maintenanceWindowDetails = maintenanceWindowDetails;
        this.scanListenerPortTls = scanListenerPortTls;
        this.scanListenerPortNonTls = scanListenerPortNonTls;
        this.licenseModel = licenseModel;
        this.nsgIds = nsgIds;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public Integer getTotalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    public Integer getCpuCoreCountPerNode() {
        return this.cpuCoreCountPerNode;
    }

    public Integer getMemoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public Double getAutonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public String getClusterTimeZone() {
        return this.clusterTimeZone;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public Boolean getIsMtlsEnabledVmCluster() {
        return this.isMtlsEnabledVmCluster;
    }

    public List<String> getDbServers() {
        return this.dbServers;
    }

    public MaintenanceWindow getMaintenanceWindowDetails() {
        return this.maintenanceWindowDetails;
    }

    public Integer getScanListenerPortTls() {
        return this.scanListenerPortTls;
    }

    public Integer getScanListenerPortNonTls() {
        return this.scanListenerPortNonTls;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateCloudAutonomousVmClusterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", cloudExadataInfrastructureId=").append(String.valueOf(this.cloudExadataInfrastructureId));
        sb.append(", totalContainerDatabases=").append(String.valueOf(this.totalContainerDatabases));
        sb.append(", cpuCoreCountPerNode=").append(String.valueOf(this.cpuCoreCountPerNode));
        sb.append(", memoryPerOracleComputeUnitInGBs=").append(String.valueOf(this.memoryPerOracleComputeUnitInGBs));
        sb.append(", autonomousDataStorageSizeInTBs=").append(String.valueOf(this.autonomousDataStorageSizeInTBs));
        sb.append(", clusterTimeZone=").append(String.valueOf(this.clusterTimeZone));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(", isMtlsEnabledVmCluster=").append(String.valueOf(this.isMtlsEnabledVmCluster));
        sb.append(", dbServers=").append(String.valueOf(this.dbServers));
        sb.append(", maintenanceWindowDetails=").append(String.valueOf((Object)this.maintenanceWindowDetails));
        sb.append(", scanListenerPortTls=").append(String.valueOf(this.scanListenerPortTls));
        sb.append(", scanListenerPortNonTls=").append(String.valueOf(this.scanListenerPortNonTls));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCloudAutonomousVmClusterDetails)) {
            return false;
        }
        CreateCloudAutonomousVmClusterDetails other = (CreateCloudAutonomousVmClusterDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.cloudExadataInfrastructureId, other.cloudExadataInfrastructureId) && Objects.equals(this.totalContainerDatabases, other.totalContainerDatabases) && Objects.equals(this.cpuCoreCountPerNode, other.cpuCoreCountPerNode) && Objects.equals(this.memoryPerOracleComputeUnitInGBs, other.memoryPerOracleComputeUnitInGBs) && Objects.equals(this.autonomousDataStorageSizeInTBs, other.autonomousDataStorageSizeInTBs) && Objects.equals(this.clusterTimeZone, other.clusterTimeZone) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && Objects.equals(this.isMtlsEnabledVmCluster, other.isMtlsEnabledVmCluster) && Objects.equals(this.dbServers, other.dbServers) && Objects.equals((Object)this.maintenanceWindowDetails, (Object)other.maintenanceWindowDetails) && Objects.equals(this.scanListenerPortTls, other.scanListenerPortTls) && Objects.equals(this.scanListenerPortNonTls, other.scanListenerPortNonTls) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.cloudExadataInfrastructureId == null ? 43 : this.cloudExadataInfrastructureId.hashCode());
        result = result * 59 + (this.totalContainerDatabases == null ? 43 : this.totalContainerDatabases.hashCode());
        result = result * 59 + (this.cpuCoreCountPerNode == null ? 43 : this.cpuCoreCountPerNode.hashCode());
        result = result * 59 + (this.memoryPerOracleComputeUnitInGBs == null ? 43 : this.memoryPerOracleComputeUnitInGBs.hashCode());
        result = result * 59 + (this.autonomousDataStorageSizeInTBs == null ? 43 : this.autonomousDataStorageSizeInTBs.hashCode());
        result = result * 59 + (this.clusterTimeZone == null ? 43 : this.clusterTimeZone.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + (this.isMtlsEnabledVmCluster == null ? 43 : this.isMtlsEnabledVmCluster.hashCode());
        result = result * 59 + (this.dbServers == null ? 43 : this.dbServers.hashCode());
        result = result * 59 + (this.maintenanceWindowDetails == null ? 43 : this.maintenanceWindowDetails.hashCode());
        result = result * 59 + (this.scanListenerPortTls == null ? 43 : this.scanListenerPortTls.hashCode());
        result = result * 59 + (this.scanListenerPortNonTls == null ? 43 : this.scanListenerPortNonTls.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU");

        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ComputeModel: " + key);
        }

        static {
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="cloudExadataInfrastructureId")
        private String cloudExadataInfrastructureId;
        @JsonProperty(value="totalContainerDatabases")
        private Integer totalContainerDatabases;
        @JsonProperty(value="cpuCoreCountPerNode")
        private Integer cpuCoreCountPerNode;
        @JsonProperty(value="memoryPerOracleComputeUnitInGBs")
        private Integer memoryPerOracleComputeUnitInGBs;
        @JsonProperty(value="autonomousDataStorageSizeInTBs")
        private Double autonomousDataStorageSizeInTBs;
        @JsonProperty(value="clusterTimeZone")
        private String clusterTimeZone;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonProperty(value="isMtlsEnabledVmCluster")
        private Boolean isMtlsEnabledVmCluster;
        @JsonProperty(value="dbServers")
        private List<String> dbServers;
        @JsonProperty(value="maintenanceWindowDetails")
        private MaintenanceWindow maintenanceWindowDetails;
        @JsonProperty(value="scanListenerPortTls")
        private Integer scanListenerPortTls;
        @JsonProperty(value="scanListenerPortNonTls")
        private Integer scanListenerPortNonTls;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            this.__explicitlySet__.add("cloudExadataInfrastructureId");
            return this;
        }

        public Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            this.__explicitlySet__.add("totalContainerDatabases");
            return this;
        }

        public Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            this.__explicitlySet__.add("cpuCoreCountPerNode");
            return this;
        }

        public Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            this.__explicitlySet__.add("memoryPerOracleComputeUnitInGBs");
            return this;
        }

        public Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            this.__explicitlySet__.add("autonomousDataStorageSizeInTBs");
            return this;
        }

        public Builder clusterTimeZone(String clusterTimeZone) {
            this.clusterTimeZone = clusterTimeZone;
            this.__explicitlySet__.add("clusterTimeZone");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            this.__explicitlySet__.add("isMtlsEnabledVmCluster");
            return this;
        }

        public Builder dbServers(List<String> dbServers) {
            this.dbServers = dbServers;
            this.__explicitlySet__.add("dbServers");
            return this;
        }

        public Builder maintenanceWindowDetails(MaintenanceWindow maintenanceWindowDetails) {
            this.maintenanceWindowDetails = maintenanceWindowDetails;
            this.__explicitlySet__.add("maintenanceWindowDetails");
            return this;
        }

        public Builder scanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            this.__explicitlySet__.add("scanListenerPortTls");
            return this;
        }

        public Builder scanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            this.__explicitlySet__.add("scanListenerPortNonTls");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateCloudAutonomousVmClusterDetails build() {
            CreateCloudAutonomousVmClusterDetails model = new CreateCloudAutonomousVmClusterDetails(this.compartmentId, this.description, this.subnetId, this.displayName, this.cloudExadataInfrastructureId, this.totalContainerDatabases, this.cpuCoreCountPerNode, this.memoryPerOracleComputeUnitInGBs, this.autonomousDataStorageSizeInTBs, this.clusterTimeZone, this.computeModel, this.isMtlsEnabledVmCluster, this.dbServers, this.maintenanceWindowDetails, this.scanListenerPortTls, this.scanListenerPortNonTls, this.licenseModel, this.nsgIds, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateCloudAutonomousVmClusterDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("cloudExadataInfrastructureId")) {
                this.cloudExadataInfrastructureId(model.getCloudExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("totalContainerDatabases")) {
                this.totalContainerDatabases(model.getTotalContainerDatabases());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCountPerNode")) {
                this.cpuCoreCountPerNode(model.getCpuCoreCountPerNode());
            }
            if (model.wasPropertyExplicitlySet("memoryPerOracleComputeUnitInGBs")) {
                this.memoryPerOracleComputeUnitInGBs(model.getMemoryPerOracleComputeUnitInGBs());
            }
            if (model.wasPropertyExplicitlySet("autonomousDataStorageSizeInTBs")) {
                this.autonomousDataStorageSizeInTBs(model.getAutonomousDataStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("clusterTimeZone")) {
                this.clusterTimeZone(model.getClusterTimeZone());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            if (model.wasPropertyExplicitlySet("isMtlsEnabledVmCluster")) {
                this.isMtlsEnabledVmCluster(model.getIsMtlsEnabledVmCluster());
            }
            if (model.wasPropertyExplicitlySet("dbServers")) {
                this.dbServers(model.getDbServers());
            }
            if (model.wasPropertyExplicitlySet("maintenanceWindowDetails")) {
                this.maintenanceWindowDetails(model.getMaintenanceWindowDetails());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTls")) {
                this.scanListenerPortTls(model.getScanListenerPortTls());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortNonTls")) {
                this.scanListenerPortNonTls(model.getScanListenerPortNonTls());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

