/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.responses;

import com.oracle.bmc.keymanagement.model.DecryptedData;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DecryptResponse
extends BmcResponse {
    private String opcRequestId;
    private DecryptedData decryptedData;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DecryptedData getDecryptedData() {
        return this.decryptedData;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "decryptedData"})
    private DecryptResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, DecryptedData decryptedData) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.decryptedData = decryptedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",decryptedData=").append(String.valueOf((Object)this.decryptedData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecryptResponse)) {
            return false;
        }
        DecryptResponse other = (DecryptResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.decryptedData, (Object)other.decryptedData);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.decryptedData == null ? 43 : this.decryptedData.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<DecryptResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private DecryptedData decryptedData;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder decryptedData(DecryptedData decryptedData) {
            this.decryptedData = decryptedData;
            return this;
        }

        public Builder copy(DecryptResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.decryptedData(o.getDecryptedData());
            return this;
        }

        public DecryptResponse build() {
            return new DecryptResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.decryptedData);
        }
    }
}

