/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.mocha.preferences;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class MochaSeleniumPreferences {
    private static final String ENABLED = "enabled";
    private static final String MOCHA_DIR = "mocha.dir";
    private static final String TIMEOUT = "timeout";
    private static final int TIMEOUT_DEFAULT = 10000;

    private MochaSeleniumPreferences() {
    }

    public static boolean isEnabled(Project project) {
        return MochaSeleniumPreferences.getPreferences(project).getBoolean(ENABLED, false);
    }

    public static void setEnabled(Project project, boolean enabled) {
        MochaSeleniumPreferences.getPreferences(project).putBoolean(ENABLED, enabled);
    }

    @CheckForNull
    public static String getMochaDir(Project project) {
        return MochaSeleniumPreferences.resolvePath(project, MochaSeleniumPreferences.getPreferences(project).get(MOCHA_DIR, null));
    }

    public static void setMochaDir(Project project, String installDir) {
        MochaSeleniumPreferences.getPreferences(project).put(MOCHA_DIR, installDir);
    }

    public static int getTimeout(Project project) {
        return MochaSeleniumPreferences.getPreferences(project).getInt(TIMEOUT, 10000);
    }

    public static void setTimeout(Project project, int timeout) {
        MochaSeleniumPreferences.getPreferences(project).putInt(TIMEOUT, timeout);
    }

    private static String resolvePath(Project project, String filePath) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }

    private static Preferences getPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, MochaSeleniumPreferences.class, (boolean)false);
    }
}

