/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

final class CreatedModifiedFilesProvider {
    private static final String VOLUME_CLASS = "classpath";
    private static final String VOLUME_SRC = "src";
    private static final String VOLUME_JAVADOC = "javadoc";
    private static final String LIBRARY_LAYER_ENTRY = "org-netbeans-api-project-libraries/Libraries";

    private CreatedModifiedFilesProvider() {
    }

    static CreatedModifiedFiles createInstance(NewLibraryDescriptor.DataModel data) {
        CreatedModifiedFiles retval = new CreatedModifiedFiles(data.getProject());
        CreatedModifiedFilesProvider.addOperations(retval, data);
        return retval;
    }

    private static void addOperations(CreatedModifiedFiles fileSupport, NewLibraryDescriptor.DataModel data) {
        FileObject template = CreatedModifiedFiles.getTemplate("libdescriptemplate.xml");
        Map<String, String> tokens = CreatedModifiedFilesProvider.getTokens(fileSupport, data.getProject(), data);
        String layerEntry = CreatedModifiedFilesProvider.getLibraryDescriptorEntryPath(data.getLibraryName());
        fileSupport.add(fileSupport.createLayerEntry(layerEntry, template, tokens, null, null));
        fileSupport.add(fileSupport.bundleKeyFromPackagePath(tokens.get("BUNDLE"), data.getLibraryName(), data.getLibraryDisplayName()));
    }

    private static String getPackagePlusBundle(Project project) {
        File mff;
        FileObject mf;
        NbModuleProvider mod = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        if (mod != null && (mf = mod.getManifestFile()) != null && (mff = FileUtil.toFile((FileObject)mf)) != null) {
            String bundle = ManifestManager.getInstance((File)mff, (boolean)false).getLocalizingBundle();
            if (bundle != null) {
                if ((bundle = bundle.replace('/', '.')).endsWith(".properties")) {
                    return bundle.substring(0, bundle.length() - 11);
                }
            } else {
                String newBundleFilePath = ManifestManager.getInstance((File)mff, (boolean)false).getCodeNameBase() + "/Bundle.properties";
                newBundleFilePath = newBundleFilePath.replace('/', '.');
                return newBundleFilePath.substring(0, newBundleFilePath.length() - 11);
            }
        }
        return null;
    }

    static String getLibraryDescriptorEntryPath(String libraryName) {
        return "org-netbeans-api-project-libraries/Libraries/" + libraryName + ".xml";
    }

    private static String transformURL(String cnb, String pathPrefix, String archiveName) {
        return "jar:nbinst://" + cnb + "/" + pathPrefix + archiveName + "!/";
    }

    private static Map<String, String> getTokens(CreatedModifiedFiles fileSupport, Project project, NewLibraryDescriptor.DataModel data) {
        HashMap<String, String> retval = new HashMap<String, String>();
        Library library = data.getLibrary();
        retval.put("NAME", data.getLibraryName());
        String packagePlusBundle = CreatedModifiedFilesProvider.getPackagePlusBundle(project);
        if (packagePlusBundle != null) {
            retval.put("BUNDLE", packagePlusBundle.replace('/', '.'));
        }
        retval.put("CLASSPATH", CreatedModifiedFilesProvider.getTokenSubstitution(library.getContent(VOLUME_CLASS), fileSupport, data, "libs/"));
        retval.put("SRC", CreatedModifiedFilesProvider.getTokenSubstitution(library.getContent(VOLUME_SRC), fileSupport, data, "sources/"));
        retval.put("JAVADOC", CreatedModifiedFilesProvider.getTokenSubstitution(library.getContent(VOLUME_JAVADOC), fileSupport, data, "docs/"));
        return retval;
    }

    private static String getTokenSubstitution(List<URL> urls, CreatedModifiedFiles fileSupport, NewLibraryDescriptor.DataModel data, String pathPrefix) {
        final NbModuleProvider nbmp = data.getModuleInfo();
        fileSupport.add(new CreatedModifiedFiles.AbstractOperation(data.getProject()){

            @Override
            public void run() throws IOException {
                nbmp.getReleaseDirectory();
            }
        });
        StringBuilder sb = new StringBuilder();
        for (URL originalURL : urls) {
            String archiveName = CreatedModifiedFilesProvider.addArchiveToCopy(fileSupport, data, originalURL, nbmp.getReleaseDirectoryPath() + '/' + pathPrefix);
            if (archiveName == null) continue;
            String codeNameBase = nbmp.getCodeNameBase();
            String urlToString = CreatedModifiedFilesProvider.transformURL(codeNameBase, pathPrefix, archiveName);
            sb.append("\n        <resource>");
            sb.append(urlToString);
            sb.append("</resource>");
        }
        return sb.toString();
    }

    private static String addArchiveToCopy(CreatedModifiedFiles fileSupport, NewLibraryDescriptor.DataModel data, URL originalURL, String pathPrefix) {
        FileObject folderToZip;
        String retval = null;
        URL archivURL = FileUtil.getArchiveFile((URL)originalURL);
        if (archivURL != null && FileUtil.isArchiveFile((URL)archivURL)) {
            FileObject archiv = URLMapper.findFileObject((URL)archivURL);
            if (archiv == null) {
                return null;
            }
            retval = archiv.getNameExt();
            fileSupport.add(fileSupport.createFile(pathPrefix + retval, archiv));
        } else if ("file".equals(originalURL.getProtocol()) && (folderToZip = URLMapper.findFileObject((URL)originalURL)) != null) {
            retval = data.getLibraryName() + "-" + folderToZip.getName() + ".zip";
            pathPrefix = pathPrefix + retval;
            fileSupport.add(new ZipAndCopyOperation(data.getProject(), folderToZip, pathPrefix));
        }
        return retval;
    }

    private static class ZipAndCopyOperation
    extends CreatedModifiedFiles.AbstractOperation {
        private FileObject folderToZip;
        private String relativePath;

        ZipAndCopyOperation(Project prj, FileObject folderToZip, String relativePath) {
            super(prj);
            this.folderToZip = folderToZip;
            this.relativePath = relativePath;
            this.addCreatedOrModifiedPath(relativePath, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws IOException {
            ArrayList files = Collections.list(this.folderToZip.getChildren(true));
            if (files.isEmpty()) {
                return;
            }
            FileObject prjDir = this.getProject().getProjectDirectory();
            assert (prjDir != null);
            FileObject zippedTarget = prjDir.getFileObject(this.relativePath);
            if (zippedTarget == null) {
                zippedTarget = FileUtil.createData((FileObject)prjDir, (String)this.relativePath);
            }
            assert (zippedTarget != null);
            try (OutputStream os = zippedTarget.getOutputStream();){
                ZipAndCopyOperation.createZipFile(os, this.folderToZip, files);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createZipFile(OutputStream target, FileObject root, Collection<? extends FileObject> files) throws IOException {
            try (ZipOutputStream str = null;){
                str = new ZipOutputStream(target);
                for (FileObject fileObject : files) {
                    String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fileObject);
                    if (fileObject.isFolder()) {
                        if (fileObject.getChildren().length > 0) continue;
                        if (!relativePath.endsWith("/")) {
                            relativePath = relativePath + "/";
                        }
                    }
                    ZipEntry entry = new ZipEntry(relativePath);
                    str.putNextEntry(entry);
                    if (fileObject.isData()) {
                        try (InputStream in = null;){
                            in = fileObject.getInputStream();
                            FileUtil.copy((InputStream)in, (OutputStream)str);
                        }
                    }
                    str.closeEntry();
                }
            }
        }
    }
}

