/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Vulnerability
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="cvssV2Score")
    private final Float cvssV2Score;
    @JsonProperty(value="cvssV3Score")
    private final Float cvssV3Score;
    @JsonProperty(value="isIgnored")
    private final Boolean isIgnored;

    @Deprecated
    @ConstructorProperties(value={"id", "cvssV2Score", "cvssV3Score", "isIgnored"})
    public Vulnerability(String id, Float cvssV2Score, Float cvssV3Score, Boolean isIgnored) {
        this.id = id;
        this.cvssV2Score = cvssV2Score;
        this.cvssV3Score = cvssV3Score;
        this.isIgnored = isIgnored;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public Float getCvssV2Score() {
        return this.cvssV2Score;
    }

    public Float getCvssV3Score() {
        return this.cvssV3Score;
    }

    public Boolean getIsIgnored() {
        return this.isIgnored;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Vulnerability(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", cvssV2Score=").append(String.valueOf(this.cvssV2Score));
        sb.append(", cvssV3Score=").append(String.valueOf(this.cvssV3Score));
        sb.append(", isIgnored=").append(String.valueOf(this.isIgnored));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.cvssV2Score, other.cvssV2Score) && Objects.equals(this.cvssV3Score, other.cvssV3Score) && Objects.equals(this.isIgnored, other.isIgnored) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.cvssV2Score == null ? 43 : this.cvssV2Score.hashCode());
        result = result * 59 + (this.cvssV3Score == null ? 43 : this.cvssV3Score.hashCode());
        result = result * 59 + (this.isIgnored == null ? 43 : this.isIgnored.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="cvssV2Score")
        private Float cvssV2Score;
        @JsonProperty(value="cvssV3Score")
        private Float cvssV3Score;
        @JsonProperty(value="isIgnored")
        private Boolean isIgnored;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder cvssV2Score(Float cvssV2Score) {
            this.cvssV2Score = cvssV2Score;
            this.__explicitlySet__.add("cvssV2Score");
            return this;
        }

        public Builder cvssV3Score(Float cvssV3Score) {
            this.cvssV3Score = cvssV3Score;
            this.__explicitlySet__.add("cvssV3Score");
            return this;
        }

        public Builder isIgnored(Boolean isIgnored) {
            this.isIgnored = isIgnored;
            this.__explicitlySet__.add("isIgnored");
            return this;
        }

        public Vulnerability build() {
            Vulnerability model = new Vulnerability(this.id, this.cvssV2Score, this.cvssV3Score, this.isIgnored);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Vulnerability model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("cvssV2Score")) {
                this.cvssV2Score(model.getCvssV2Score());
            }
            if (model.wasPropertyExplicitlySet("cvssV3Score")) {
                this.cvssV3Score(model.getCvssV3Score());
            }
            if (model.wasPropertyExplicitlySet("isIgnored")) {
                this.isIgnored(model.getIsIgnored());
            }
            return this;
        }
    }
}

