/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.editor.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class JSFConfigHyperlinkProvider
implements HyperlinkProvider {
    private static boolean debug = false;
    private static Map<String, JsfConfigHyperlinkType> hyperlinkMap = new ConcurrentHashMap<String, JsfConfigHyperlinkType>();
    private int valueOffset;
    private String[] ev;

    public JSFConfigHyperlinkProvider() {
        hyperlinkMap.put("managed-bean-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("component-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("renderer-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("property-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("validator-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("attribute-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("message-bundle", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("action-listener", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("application-factory", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("converter-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("converter-for-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("faces-context-factory", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("key-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("lifecycle-factory", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("navigation-handler", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("phase-listener", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("property-resolver", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("referenced-bean-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("render-kit-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("render-kit-factory", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("value-class", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("variable-resolver", JsfConfigHyperlinkType.JAVA_CLASS);
        hyperlinkMap.put("from-view-id", JsfConfigHyperlinkType.RESOURCE_PATH);
        hyperlinkMap.put("to-view-id", JsfConfigHyperlinkType.RESOURCE_PATH);
        this.ev = null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (debug) {
            JSFConfigHyperlinkProvider.debug(":: getHyperlinkSpan");
        }
        if (this.ev != null) {
            return new int[]{this.valueOffset, this.valueOffset + this.ev[1].length()};
        }
        return null;
    }

    public boolean isHyperlinkPoint(Document doc, int offset) {
        DataObject dObject;
        if (debug) {
            JSFConfigHyperlinkProvider.debug(":: isHyperlinkSpan - offset: " + offset);
        }
        if (!((dObject = NbEditorUtilities.getDataObject((Document)doc)) instanceof JSFConfigDataObject)) {
            return false;
        }
        this.ev = this.getElementValue(doc, offset);
        return this.ev != null && hyperlinkMap.get(this.ev[0]) != null;
    }

    public void performClickAction(Document doc, int offset) {
        if (debug) {
            JSFConfigHyperlinkProvider.debug(":: performClickAction");
        }
        if (hyperlinkMap.get(this.ev[0]) != null) {
            JsfConfigHyperlinkType type = hyperlinkMap.get(this.ev[0]);
            switch (type) {
                case JAVA_CLASS: {
                    this.findJavaClass(this.ev[1], doc);
                    break;
                }
                case RESOURCE_PATH: {
                    this.findResourcePath(this.ev[1], (BaseDocument)doc);
                }
            }
        }
    }

    static void debug(String message) {
        System.out.println("JSFConfigHyperlinkProvider: " + message);
    }

    private String[] getElementValue(Document doc, int offset) {
        String tag = null;
        String value = null;
        try {
            BaseDocument bdoc = (BaseDocument)doc;
            JTextComponent target = Utilities.getFocusedComponent();
            if (target == null || target.getDocument() != bdoc) {
                return null;
            }
            ExtSyntaxSupport sup = (ExtSyntaxSupport)bdoc.getSyntaxSupport();
            TokenItem token = sup.getTokenChain(offset, offset + 1);
            if (token == null || token.getTokenID().getNumericID() != 1) {
                return null;
            }
            value = token.getImage();
            if (value != null) {
                String original = value;
                value = value.trim();
                this.valueOffset = token.getOffset() + original.indexOf(value);
            }
            while (token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().equals(">"))) {
                token = token.getPrevious();
            }
            if (token == null) {
                return null;
            }
            tag = token.getImage().substring(1);
            if (debug) {
                JSFConfigHyperlinkProvider.debug("element: " + tag);
            }
            if (debug) {
                JSFConfigHyperlinkProvider.debug("value: " + value);
            }
            return new String[]{tag, value};
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private boolean isWhiteChar(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void findJavaClass(String fqn, Document doc) {
        WebModule wm;
        FileObject fo = NbEditorUtilities.getFileObject((Document)doc);
        if (fo != null && (wm = WebModule.getWebModule((FileObject)fo)) != null) {
            ClasspathInfo cpi = ClasspathInfo.create((FileObject)wm.getDocumentBase());
            ClassSeekerTask classSeekerTask = new ClassSeekerTask(cpi, fqn);
            this.runClassSeekerUserTask(classSeekerTask);
            if (!classSeekerTask.wasElementFound() && SourceUtils.isScanInProgress()) {
                ScanDialog.runWhenScanFinished((Runnable)classSeekerTask, (String)Bundle.title_go_to_class_action());
            }
        }
    }

    private void runClassSeekerUserTask(ClassSeekerTask classSeekerTask) {
        JavaSource js = JavaSource.create((ClasspathInfo)classSeekerTask.cpi, (FileObject[])new FileObject[0]);
        if (js != null) {
            try {
                js.runUserActionTask((Task)classSeekerTask, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void findResourcePath(String path, BaseDocument doc) {
        FileObject docBase;
        FileObject fo;
        WebModule wm;
        int qmIndex = path.indexOf(63);
        if (qmIndex == 0) {
            return;
        }
        if (qmIndex != -1) {
            path = path.substring(0, qmIndex);
        }
        if ((wm = WebModule.getWebModule((FileObject)NbEditorUtilities.getFileObject((Document)doc))) != null && (fo = (docBase = wm.getDocumentBase()).getFileObject(path)) != null) {
            this.openInEditor(fo);
        }
    }

    private void openInEditor(FileObject fObj) {
        if (fObj != null) {
            Node.Cookie cookie;
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fObj);
            }
            catch (DataObjectNotFoundException e) {
                Exceptions.printStackTrace((Throwable)e);
                return;
            }
            if (dobj != null && (cookie = dobj.getCookie(OpenCookie.class)) != null) {
                ((OpenCookie)cookie).open();
            }
        }
    }

    private class ClassSeekerTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private final AtomicBoolean elementFound = new AtomicBoolean(false);
        private final ClasspathInfo cpi;
        private final String fqn;

        public ClassSeekerTask(ClasspathInfo cpi, String fqn) {
            this.cpi = cpi;
            this.fqn = fqn;
        }

        public boolean wasElementFound() {
            return this.elementFound.get();
        }

        @Override
        public void run() {
            JSFConfigHyperlinkProvider.this.runClassSeekerUserTask(this);
        }

        public void cancel() {
        }

        public void run(CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            Elements elements = cc.getElements();
            TypeElement element = elements.getTypeElement(this.fqn.trim());
            if (element != null) {
                this.elementFound.set(true);
                ElementHandle el = ElementHandle.create((Element)element);
                FileObject fo = SourceUtils.getFile((ElementHandle)el, (ClasspathInfo)this.cpi);
                if (fo == null) {
                    StatusDisplayer.getDefault().setStatusText(Bundle.lbl_managed_bean_not_found(this.fqn));
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                DataObject od = DataObject.find((FileObject)fo);
                if (!"org.netbeans.modules.java.JavaDataObject".equals(od.getClass().getName())) {
                    OpenCookie oc = (OpenCookie)od.getCookie(OpenCookie.class);
                    oc.open();
                }
                if (!ElementOpen.open((FileObject)fo, (ElementHandle)el)) {
                    StatusDisplayer.getDefault().setStatusText(Bundle.lbl_goto_source_not_found(this.fqn));
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (!SourceUtils.isScanInProgress()) {
                StatusDisplayer.getDefault().setStatusText(Bundle.lbl_managed_bean_not_found(this.fqn));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private static enum JsfConfigHyperlinkType {
        JAVA_CLASS,
        RESOURCE_PATH;

    }
}

