/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownTokenClasses;
import opennlp.tools.util.featuregen.FeatureGeneratorAdapter;

public class BrownBigramFeatureGenerator
extends FeatureGeneratorAdapter {
    private BrownCluster brownLexicon;

    public BrownBigramFeatureGenerator(BrownCluster dict) {
        this.brownLexicon = dict;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        int i;
        List<String> wordClasses = BrownTokenClasses.getWordClasses(tokens[index], this.brownLexicon);
        if (index > 0) {
            List<String> prevWordClasses = BrownTokenClasses.getWordClasses(tokens[index - 1], this.brownLexicon);
            for (i = 0; i < wordClasses.size() && i < prevWordClasses.size(); ++i) {
                features.add("pbrowncluster,browncluster=" + prevWordClasses.get(i) + "," + wordClasses.get(i));
            }
        }
        if (index + 1 < tokens.length) {
            List<String> nextWordClasses = BrownTokenClasses.getWordClasses(tokens[index + 1], this.brownLexicon);
            for (i = 0; i < wordClasses.size() && i < nextWordClasses.size(); ++i) {
                features.add("browncluster,nbrowncluster=" + wordClasses.get(i) + "," + nextWordClasses.get(i));
            }
        }
    }
}

