/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import gen.taas.TaasDomain;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import org.omegat.core.Core;
import org.omegat.gui.glossary.taas.SelectDomainUI;
import org.omegat.gui.glossary.taas.TaaSClient;
import org.omegat.gui.glossary.taas.TaaSPlugin;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;

public final class SelectDomainController {
    static SelectDomainUI dialog;

    private SelectDomainController() {
    }

    public static void show() {
        dialog = new SelectDomainUI((Frame)Core.getMainWindow().getApplicationFrame(), true);
        SelectDomainController.dialog.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        SelectDomainController.dialog.labelStatus.setText(OStrings.getString("TAAS_STATUS_DOMAIN_LIST"));
        new SwingWorker<List<TaasDomain>, Void>(){

            @Override
            protected List<TaasDomain> doInBackground() throws Exception {
                List<TaasDomain> result = TaaSPlugin.getClient().getDomainsList();
                Collections.sort(result, new Comparator<TaasDomain>(){

                    @Override
                    public int compare(TaasDomain d1, TaasDomain d2) {
                        return d1.getName().compareToIgnoreCase(d2.getName());
                    }
                });
                return result;
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    String previouslySelected = Preferences.getPreference("taas_domain");
                    if (StringUtil.isEmpty(previouslySelected)) {
                        previouslySelected = null;
                        SelectDomainController.dialog.rbAll.setSelected(true);
                    }
                    for (TaasDomain d : list) {
                        JRadioButton btn = new JRadioButton(d.getName());
                        btn.setName(d.getId());
                        SelectDomainController.dialog.buttonGroup.add(btn);
                        SelectDomainController.dialog.list.add(btn);
                        if (previouslySelected == null || !previouslySelected.equals(btn.getName())) continue;
                        btn.setSelected(true);
                    }
                    SelectDomainController.dialog.list.revalidate();
                    SelectDomainController.dialog.labelStatus.setText(" ");
                }
                catch (ExecutionException e) {
                    Throwable ex = e.getCause();
                    if (ex instanceof TaaSClient.FormatError) {
                        Log.logErrorRB(ex, "TAAS_FORMAT_ERROR", ex.getMessage());
                        SelectDomainController.dialog.labelStatus.setText(OStrings.getString("TAAS_FORMAT_ERROR"));
                    } else if (ex instanceof TaaSClient.Unauthorized) {
                        Log.logErrorRB(ex, "TAAS_UNAUTHORIZED_ERROR", new Object[0]);
                        SelectDomainController.dialog.labelStatus.setText(OStrings.getString("TAAS_UNAUTHORIZED_ERROR"));
                    } else {
                        Log.logErrorRB(ex, "TAAS_GENERAL_ERROR", ex.getMessage());
                        SelectDomainController.dialog.labelStatus.setText(MessageFormat.format(OStrings.getString("TAAS_GENERAL_ERROR"), ex.getMessage()));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.execute();
        SelectDomainController.dialog.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectDomainController.dialog.rbAll.isSelected()) {
                    Preferences.setPreference("taas_domain", "");
                } else {
                    Enumeration<AbstractButton> en = SelectDomainController.dialog.buttonGroup.getElements();
                    while (en.hasMoreElements()) {
                        AbstractButton btn = en.nextElement();
                        if (!btn.isSelected()) continue;
                        Preferences.setPreference("taas_domain", btn.getName());
                        break;
                    }
                }
                Preferences.save();
                dialog.dispose();
            }
        });
        StaticUIUtils.setEscapeClosable(dialog);
        SelectDomainController.dialog.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        dialog.setLocationRelativeTo(Core.getMainWindow().getApplicationFrame());
        dialog.setVisible(true);
    }
}

