/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.omegat.gui.properties.FlashingTextArea;
import org.omegat.gui.properties.ForcedWrappingEditorKit;
import org.omegat.gui.properties.ISegmentPropertiesView;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;

public class SegmentPropertiesListCell
extends JPanel {
    String key = null;
    JTextArea label;
    private JPanel labelPanel;
    JButton settingsButton;
    FlashingTextArea value;

    public SegmentPropertiesListCell() {
        this.initComponents();
        Color highlightColor = StaticUIUtils.getHighlightColor(Styles.EditorColor.COLOR_BACKGROUND.getColor());
        this.setBackground(Styles.EditorColor.COLOR_BACKGROUND.getColor());
        this.labelPanel.setBackground(highlightColor);
        this.labelPanel.setBorder(ISegmentPropertiesView.MARGIN_BORDER);
        this.label.setFont(UIManager.getFont("Label.font"));
        this.label.setForeground(Styles.EditorColor.COLOR_FOREGROUND.getColor());
        this.label.setBackground(highlightColor);
        this.value.setEditorKit(new ForcedWrappingEditorKit());
        this.value.setForeground(Styles.EditorColor.COLOR_FOREGROUND.getColor());
        this.value.setBackground(Styles.EditorColor.COLOR_BACKGROUND.getColor());
        this.value.setBorder(ISegmentPropertiesView.MARGIN_BORDER);
        JTextPaneLinkifier.linkify(this.value);
        this.settingsButton.setBackground(highlightColor);
        this.settingsButton.setIcon(ISegmentPropertiesView.SETTINGS_ICON_INVISIBLE);
        this.settingsButton.setRolloverIcon(ISegmentPropertiesView.SETTINGS_ICON);
        this.settingsButton.setPressedIcon(ISegmentPropertiesView.SETTINGS_ICON_PRESSED);
        this.settingsButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        MouseAdapter revealSettingsIcon = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SegmentPropertiesListCell.this.settingsButton.setIcon(ISegmentPropertiesView.SETTINGS_ICON_INACTIVE);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SegmentPropertiesListCell.this.settingsButton.setIcon(ISegmentPropertiesView.SETTINGS_ICON_INVISIBLE);
            }
        };
        this.label.addMouseListener(revealSettingsIcon);
        this.value.addMouseListener(revealSettingsIcon);
        StaticUIUtils.setCaretUpdateEnabled(this.label, false);
        StaticUIUtils.setCaretUpdateEnabled(this.value, false);
    }

    private void initComponents() {
        this.labelPanel = new JPanel();
        this.label = new JTextArea();
        this.settingsButton = new JButton();
        this.value = new FlashingTextArea();
        this.setLayout(new BorderLayout());
        this.labelPanel.setLayout(new BorderLayout());
        this.label.setEditable(false);
        this.label.setLineWrap(true);
        this.labelPanel.add((Component)this.label, "Center");
        this.settingsButton.setBorderPainted(false);
        this.settingsButton.setContentAreaFilled(false);
        this.settingsButton.setFocusable(false);
        this.settingsButton.setRolloverEnabled(true);
        this.labelPanel.add((Component)this.settingsButton, "East");
        this.add((Component)this.labelPanel, "North");
        this.value.setEditable(false);
        this.add((Component)this.value, "Center");
    }
}

