/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.madlonkay.supertmxmerge.DiffController;
import org.madlonkay.supertmxmerge.FileLoaderWorker;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.util.FileUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;

public class DiffIOController {
    private static final Logger LOGGER = Logger.getLogger(DiffIOController.class.getName());
    public static final String PROP_FILE1 = "file1";
    public static final String PROP_FILE2 = "file2";
    public static final String PROP_INPUTISVALID = "inputIsValid";
    public static final String PROP_OUTPUTFILE = "outputFile";
    private File file1;
    private File file2;
    private File outputFile;
    private boolean isDone;
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public File getFile1() {
        return this.file1;
    }

    public void setFile1(File file1) {
        File oldFile1 = this.file1;
        this.file1 = file1;
        this.propertySupport.firePropertyChange(PROP_FILE1, oldFile1, file1);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public File getFile2() {
        return this.file2;
    }

    public void setFile2(File file2) {
        File oldFile2 = this.file2;
        this.file2 = file2;
        this.propertySupport.firePropertyChange(PROP_FILE2, oldFile2, file2);
        this.propertySupport.firePropertyChange(PROP_INPUTISVALID, null, null);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        File oldOutputFile = this.outputFile;
        this.outputFile = outputFile;
        this.propertySupport.firePropertyChange(PROP_OUTPUTFILE, oldOutputFile, outputFile);
    }

    public boolean getInputIsValid() {
        return FileUtil.validateFile(this.getFile1()) && FileUtil.validateFile(this.getFile2()) && !this.getFile1().equals(this.getFile2());
    }

    public void go() {
        this.isDone = false;
        GuiUtil.safelyRunBlockingRoutine(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                new DiffWorker(DiffIOController.this.getFile1(), DiffIOController.this.getFile2()).run();
                try {
                    DiffIOController diffIOController = DiffIOController.this;
                    synchronized (diffIOController) {
                        while (!DiffIOController.this.isDone) {
                            DiffIOController.this.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private class DiffWorker
    extends FileLoaderWorker {
        public DiffWorker(File ... files) {
            super(files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processLoadedTmxs(List<ITmx> tmxs) {
            try {
                DiffController differ = new DiffController();
                if (DiffIOController.this.outputFile != null) {
                    JAXBTmx outTmx = JAXBTmx.createFromDiff((JAXBTmx)tmxs.get(0), (JAXBTmx)tmxs.get(1));
                    outTmx.writeTo(DiffIOController.this.outputFile);
                } else {
                    differ.diff(tmxs.get(0), tmxs.get(1));
                }
            }
            catch (WriteFailedException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            finally {
                DiffIOController.this.isDone = true;
                DiffIOController diffIOController = DiffIOController.this;
                synchronized (diffIOController) {
                    DiffIOController.this.notify();
                }
            }
        }
    }
}

