/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;
import org.omegat.externalfinder.item.ExternalFinderItemCommand;
import org.omegat.externalfinder.item.ExternalFinderItemURL;
import org.omegat.externalfinder.item.ExternalFinderValidationException;
import org.omegat.util.OStrings;

public final class ExternalFinderItem {
    public static final String PLACEHOLDER_TARGET = "{target}";
    private final String name;
    private final List<ExternalFinderItemURL> urls;
    private final List<ExternalFinderItemCommand> commands;
    private final KeyStroke keystroke;
    private final boolean nopopup;
    private final SCOPE scope;

    private ExternalFinderItem(Builder builder) {
        this.name = builder.name;
        this.urls = builder.urls.isEmpty() ? Collections.emptyList() : new ArrayList(builder.urls);
        this.commands = builder.commands.isEmpty() ? Collections.emptyList() : new ArrayList(builder.commands);
        this.keystroke = builder.keystroke;
        this.nopopup = builder.nopopup;
        this.scope = builder.scope;
    }

    public String getName() {
        return this.name;
    }

    public List<ExternalFinderItemURL> getURLs() {
        return Collections.unmodifiableList(this.urls);
    }

    public List<ExternalFinderItemCommand> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public KeyStroke getKeystroke() {
        return this.keystroke;
    }

    public boolean isNopopup() {
        return this.nopopup;
    }

    public SCOPE getScope() {
        return this.scope;
    }

    public boolean isAsciiOnly() {
        return this.isTargetOnly(TARGET.ASCII_ONLY);
    }

    public boolean isNonAsciiOnly() {
        return this.isTargetOnly(TARGET.NON_ASCII_ONLY);
    }

    private boolean isTargetOnly(TARGET target) {
        for (ExternalFinderItemURL url : this.urls) {
            if (url.getTarget() == target) continue;
            return false;
        }
        for (ExternalFinderItemCommand command : this.commands) {
            if (command.getTarget() == target) continue;
            return false;
        }
        return true;
    }

    public static boolean isASCII(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public Object getContentSummary() {
        StringBuilder sb = new StringBuilder();
        if (!this.getURLs().isEmpty()) {
            String urls = OStrings.getString("EXTERNALFINDER_CONTENT_TEMPLATE", OStrings.getString("EXTERNALFINDER_CONTENT_URLS"), this.getURLs().size());
            sb.append(urls);
        }
        if (!this.getCommands().isEmpty()) {
            if (sb.length() > 0) {
                sb.append(OStrings.getString("EXTERNALFINDER_CONTENT_DELIMITER"));
            }
            String commands = OStrings.getString("EXTERNALFINDER_CONTENT_TEMPLATE", OStrings.getString("EXTERNALFINDER_CONTENT_COMMANDS"), this.getCommands().size());
            sb.append(commands);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.urls == null ? 0 : this.urls.hashCode());
        result = 31 * result + (this.commands == null ? 0 : this.commands.hashCode());
        result = 31 * result + (this.keystroke == null ? 0 : this.keystroke.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nopopup ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalFinderItem other = (ExternalFinderItem)obj;
        if (this.urls == null ? other.urls != null : !this.urls.equals(other.urls)) {
            return false;
        }
        if (this.commands == null ? other.commands != null : !this.commands.equals(other.commands)) {
            return false;
        }
        if (this.keystroke == null ? other.keystroke != null : !this.keystroke.equals(other.keystroke)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.nopopup == other.nopopup;
    }

    public static class Builder {
        private String name;
        private List<ExternalFinderItemURL> urls = new ArrayList<ExternalFinderItemURL>();
        private List<ExternalFinderItemCommand> commands = new ArrayList<ExternalFinderItemCommand>();
        private KeyStroke keystroke;
        private boolean nopopup = false;
        public SCOPE scope;

        public static Builder from(ExternalFinderItem item) {
            return new Builder().setName(item.getName()).setURLs(item.getURLs()).setCommands(item.getCommands()).setKeyStroke(item.getKeystroke()).setNopopup(item.isNopopup()).setScope(item.getScope());
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder addURL(ExternalFinderItemURL url) {
            this.urls.add(url);
            return this;
        }

        public Builder setURLs(List<ExternalFinderItemURL> urls) {
            this.urls.clear();
            this.urls.addAll(urls);
            return this;
        }

        public List<ExternalFinderItemURL> getURLs() {
            return this.urls;
        }

        public Builder addCommand(ExternalFinderItemCommand command) {
            this.commands.add(command);
            return this;
        }

        public Builder setCommands(List<ExternalFinderItemCommand> commands) {
            this.commands.clear();
            this.commands.addAll(commands);
            return this;
        }

        public List<ExternalFinderItemCommand> getCommands() {
            return this.commands;
        }

        public Builder setKeyStroke(KeyStroke keystroke) {
            this.keystroke = keystroke;
            return this;
        }

        public KeyStroke getKeyStroke() {
            return this.keystroke;
        }

        public Builder setNopopup(boolean nopopup) {
            this.nopopup = nopopup;
            return this;
        }

        public boolean isNopopup() {
            return this.nopopup;
        }

        public Builder setScope(SCOPE scope) {
            this.scope = scope;
            return this;
        }

        public SCOPE getScope() {
            return this.scope;
        }

        public ExternalFinderItem build() throws ExternalFinderValidationException {
            this.validate();
            return new ExternalFinderItem(this);
        }

        public void validate() throws ExternalFinderValidationException {
            boolean hasCommands;
            if (this.name == null || this.name.isEmpty()) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_ITEM_ERROR_NAME"));
            }
            boolean hasUrls = this.urls != null && !this.urls.isEmpty();
            boolean bl = hasCommands = this.commands != null && !this.commands.isEmpty();
            if (!hasUrls && !hasCommands) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_ITEM_ERROR_EMPTY", this.name));
            }
            if (this.scope == null) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_ITEM_ERROR_NOSCOPE"));
            }
        }
    }

    public static enum SCOPE {
        GLOBAL,
        PROJECT;

    }

    public static enum ENCODING {
        DEFAULT,
        ESCAPE,
        NONE;


        public String toString() {
            return OStrings.getString("EXTERNALFINDER_ENCODING_" + this.name());
        }
    }

    public static enum TARGET {
        ASCII_ONLY,
        NON_ASCII_ONLY,
        BOTH;


        public String toString() {
            return OStrings.getString("EXTERNALFINDER_TARGET_" + this.name());
        }
    }
}

