/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.team2.RemoteRepositoryFactory;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class NewTeamProject
extends JDialog {
    private RepoTypeWorker repoTypeWorker = null;
    private String repoType;
    private JButton btnCancel;
    private JButton btnDirectory;
    private JButton btnOk;
    private JLabel detectedRepoOrProjectFileLabel;
    private JPanel jPanel2;
    private JLabel localFolderLabel;
    public JTextField txtDirectory;
    public JTextField txtRepositoryOrProjectFileURL;
    private JLabel urlLabel;
    public boolean ok;

    public NewTeamProject(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.txtRepositoryOrProjectFileURL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTeamProject.this.clearRepo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTeamProject.this.clearRepo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTeamProject.this.clearRepo();
            }
        });
        this.txtRepositoryOrProjectFileURL.addActionListener(e -> this.btnOk.doClick());
        this.txtDirectory.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTeamProject.this.updateDialog();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTeamProject.this.updateDialog();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTeamProject.this.updateDialog();
            }
        });
        this.txtDirectory.addActionListener(e -> this.btnOk.doClick());
        StaticUIUtils.setEscapeClosable(this);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setLocationRelativeTo(parent);
    }

    public String getRepoType() {
        return this.repoType;
    }

    public String getRepoUrl() {
        String url = this.txtRepositoryOrProjectFileURL.getText().trim();
        if (url.startsWith("git!")) {
            return url.substring("git!".length());
        }
        if (url.startsWith("svn!")) {
            return url.substring("svn!".length());
        }
        return url;
    }

    public String getSaveLocation() {
        return this.txtDirectory.getText().trim();
    }

    private synchronized void detectRepoOrFile() {
        if (this.repoType != null || this.isDetectingRepo()) {
            return;
        }
        String url = this.txtRepositoryOrProjectFileURL.getText().trim();
        if (StringUtil.isEmpty(url)) {
            return;
        }
        if (url.startsWith("git!")) {
            this.detectedRepoOrProjectFileLabel.setText(OStrings.getString("TEAM_DETECTED_REPO_GIT"));
            this.repoType = "git";
            this.suggestLocalFolder();
        } else if (url.startsWith("svn!")) {
            this.detectedRepoOrProjectFileLabel.setText(OStrings.getString("TEAM_DETECTED_REPO_SVN"));
            this.repoType = "svn";
            this.suggestLocalFolder();
        } else {
            this.detectedRepoOrProjectFileLabel.setText(OStrings.getString("TEAM_DETECTING_REPO_OR_PROJECT_FILE"));
            this.repoTypeWorker = new RepoTypeWorker(url);
            this.repoTypeWorker.execute();
        }
    }

    private synchronized boolean isDetectingRepo() {
        return this.repoTypeWorker != null && !this.repoTypeWorker.isDone();
    }

    private static String getMessageForRepoType(String type) {
        if ("svn".equals(type)) {
            return OStrings.getString("TEAM_DETECTED_REPO_SVN");
        }
        if ("git".equals(type)) {
            return OStrings.getString("TEAM_DETECTED_REPO_GIT");
        }
        if ("project-file".equals(type)) {
            return OStrings.getString("TEAM_DETECTED_PROJECT_FILE");
        }
        return OStrings.getString("TEAM_DETECTED_REPO_UNKNOWN");
    }

    private void suggestLocalFolder() {
        if (!this.getSaveLocation().isEmpty()) {
            return;
        }
        String url = this.txtRepositoryOrProjectFileURL.getText().trim();
        String strippedUrl = StringUtil.stripFromEnd(url, ".git", "/", "trunk", "/", "svn");
        String dir = Preferences.getPreferenceDefault("current_folder", System.getProperty("user.home"));
        File suggestion = new File(dir, new File(strippedUrl).getName()).getAbsoluteFile();
        this.txtDirectory.setText(NewTeamProject.ensureUniquePath(suggestion).getPath());
    }

    private static File ensureUniquePath(File path) {
        File result = path;
        int suff = 2;
        while (result.exists()) {
            result = new File(path.getPath() + suff);
            if (++suff <= 1000) continue;
            break;
        }
        return result;
    }

    private void clearRepo() {
        this.repoType = null;
        this.detectedRepoOrProjectFileLabel.setText(" ");
        if (this.repoTypeWorker != null) {
            this.repoTypeWorker.cancel(true);
        }
        this.updateDialog();
    }

    private void initComponents() {
        this.urlLabel = new JLabel();
        this.txtRepositoryOrProjectFileURL = new JTextField();
        this.detectedRepoOrProjectFileLabel = new JLabel();
        this.localFolderLabel = new JLabel();
        this.txtDirectory = new JTextField();
        this.btnDirectory = new JButton();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("TEAM_NEW_HEADER"));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)OStrings.getString("TEAM_NEW_PROJECT_URL_OR_FILE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.urlLabel, gridBagConstraints);
        this.txtRepositoryOrProjectFileURL.setColumns(40);
        this.txtRepositoryOrProjectFileURL.setToolTipText("");
        this.txtRepositoryOrProjectFileURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProject.this.txtProjectFileURLFocusLost(evt);
            }
        });
        this.txtRepositoryOrProjectFileURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.txtProjectFileURLActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtRepositoryOrProjectFileURL, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.detectedRepoOrProjectFileLabel, (String)" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.detectedRepoOrProjectFileLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.localFolderLabel, (String)OStrings.getString("TEAM_NEW_PROJECT_DIRECTORY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.localFolderLabel, gridBagConstraints);
        this.txtDirectory.setToolTipText("");
        this.txtDirectory.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProject.this.txtDirectoryFocusLost(evt);
            }
        });
        this.txtDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.txtDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this.txtDirectory, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDirectory, (String)"...");
        this.btnDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.btnDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.getContentPane().add((Component)this.btnDirectory, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOk, (String)OStrings.getString("BUTTON_OK"));
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)OStrings.getString("BUTTON_CANCEL"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        this.btnCancel.getAccessibleContext().setAccessibleDescription("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void updateDialog() {
        String dir = this.getSaveLocation();
        boolean dirOK = !dir.isEmpty() && !new File(dir).exists();
        boolean typeDetected = this.repoType != null;
        this.btnOk.setEnabled(dirOK && typeDetected);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.repoTypeWorker != null) {
            this.repoTypeWorker.cancel(true);
        }
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.dispose();
        this.ok = true;
    }

    private void btnDirectoryActionPerformed(ActionEvent evt) {
        int ndcResult;
        NewProjectFileChooser ndc = new NewProjectFileChooser();
        String saveDir = this.getSaveLocation();
        if (!saveDir.isEmpty()) {
            ndc.setSelectedFile(new File(saveDir));
        }
        if ((ndcResult = ndc.showSaveDialog(this)) == 0) {
            this.txtDirectory.setText(ndc.getSelectedFile().getPath());
        }
        this.updateDialog();
    }

    private void txtProjectFileURLActionPerformed(ActionEvent evt) {
        this.detectRepoOrFile();
    }

    private void txtProjectFileURLFocusLost(FocusEvent evt) {
        this.detectRepoOrFile();
    }

    private void txtDirectoryFocusLost(FocusEvent evt) {
        this.updateDialog();
    }

    private void txtDirectoryActionPerformed(ActionEvent evt) {
        this.updateDialog();
    }

    private class RepoTypeWorker
    extends SwingWorker<String, Void> {
        private final String url;

        RepoTypeWorker(String url) {
            this.url = url;
        }

        @Override
        protected String doInBackground() throws Exception {
            if ((this.url.startsWith("http://") || this.url.startsWith("https://")) && this.url.endsWith("/omegat.project")) {
                return this.detectProjectFile();
            }
            return RemoteRepositoryFactory.detectRepositoryType(this.url);
        }

        protected String detectProjectFile() throws Exception {
            byte[] file = WikiGet.getURLasByteArray(this.url);
            ProjectFileStorage.parseProjectFile(file);
            return "project-file";
        }

        @Override
        protected void done() {
            String resultText;
            String type;
            try {
                type = (String)this.get();
                resultText = NewTeamProject.getMessageForRepoType(type);
            }
            catch (CancellationException ex) {
                type = null;
                resultText = " ";
            }
            catch (Throwable ex) {
                type = null;
                resultText = OStrings.getString("TEAM_ERROR_DETECTING_PROJECT_FILE");
                Log.logErrorRB(ex, "TEAM_ERROR_DETECTING_PROJECT_FILE", new Object[0]);
            }
            NewTeamProject.this.detectedRepoOrProjectFileLabel.setText(resultText);
            if (type != null) {
                NewTeamProject.this.suggestLocalFolder();
            }
            NewTeamProject.this.repoType = type;
            NewTeamProject.this.updateDialog();
        }
    }
}

