/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.omegat.core.data.PluginInformation;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.OStrings;

public class PluginInfoTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 5345248154613009632L;
    protected static final int COLUMN_NAME = 0;
    protected static final int COLUMN_CLASS = 1;
    protected static final int COLUMN_VERSION = 2;
    protected static final int COLUMN_AUTHOR = 3;
    protected static final int COLUMN_DESCRIPTION = 4;
    private static final String[] COLUMN_NAMES = new String[]{"NAME", "CLASS", "VERSION", "AUTHOR", "DESCRIPTION"};
    private final List<PluginInformation> listPlugins = new ArrayList<PluginInformation>();

    public PluginInfoTableModel() {
        PluginUtils.getPluginInformations().stream().sorted(Comparator.comparing(PluginInformation::getClassName)).forEach(info -> this.listPlugins.add((PluginInformation)info));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.listPlugins == null ? 0 : this.listPlugins.size();
    }

    @Override
    public String getColumnName(int column) {
        return OStrings.getString("PREFS_PLUGINS_COL_" + COLUMN_NAMES[column]);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PluginInformation plugin = this.listPlugins.get(rowIndex);
        String returnValue = null;
        switch (columnIndex) {
            case 1: {
                returnValue = plugin.getClassName();
                break;
            }
            case 0: {
                returnValue = plugin.getName();
                break;
            }
            case 2: {
                returnValue = plugin.getVersion();
                break;
            }
            case 3: {
                returnValue = plugin.getAuthor();
                break;
            }
            case 4: {
                returnValue = plugin.getDescription();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index");
            }
        }
        return returnValue;
    }
}

