/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class FontFallbackManager {
    private static final Set<String> FONT_BLACKLIST = Collections.singleton("Apple Color Emoji");
    private static final Font FONT_UNAVAILABLE = new Font("", 0, 0);
    private static final Logger LOGGER = Logger.getLogger(FontFallbackManager.class.getName());
    private static final Font[] RECENT_FONTS = new Font[8];
    private static int lastFontIndex = 0;
    private static final Map<Integer, Font> CACHE = new ConcurrentHashMap<Integer, Font>();

    private FontFallbackManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getCapableFont(int cp) {
        if (cp >= 65024 && cp <= 65039) {
            return null;
        }
        if (CACHE.isEmpty()) {
            Map<Integer, Font> map = CACHE;
            synchronized (map) {
                return FontFallbackManager.getCapableFontInternal(cp);
            }
        }
        return FontFallbackManager.getCapableFontInternal(cp);
    }

    private static Font getCapableFontInternal(int cp) {
        for (int i = 0; i < RECENT_FONTS.length; ++i) {
            int testIndex = (lastFontIndex - i + RECENT_FONTS.length) % RECENT_FONTS.length;
            Font font = RECENT_FONTS[testIndex];
            if (font == null || !font.canDisplay(cp)) continue;
            lastFontIndex = testIndex;
            CACHE.put(cp, font);
            return font;
        }
        Font cachedFont = CACHE.get(cp);
        if (cachedFont == FONT_UNAVAILABLE) {
            return null;
        }
        if (cachedFont != null) {
            FontFallbackManager.addRecentFont(cachedFont);
            return cachedFont;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] allFonts = ge.getAllFonts();
        LOGGER.fine(() -> String.format("Searching %d fonts for one supporting U+%h %s", allFonts.length, cp, String.valueOf(Character.toChars(cp))));
        long start = System.currentTimeMillis();
        Optional<Font> font = ((Stream)Stream.of(allFonts).parallel()).filter(f -> f.canDisplay(cp) && !FONT_BLACKLIST.contains(f.getFamily())).findFirst();
        CACHE.put(cp, font.orElse(FONT_UNAVAILABLE));
        font.ifPresent(FontFallbackManager::addRecentFont);
        LOGGER.fine(() -> font.isPresent() ? String.format("Search found %s in %d ms", ((Font)font.get()).getFamily(), System.currentTimeMillis() - start) : String.format("Search failed to find a font; time: %d ms", System.currentTimeMillis() - start));
        return font.orElse(null);
    }

    private static void addRecentFont(Font font) {
        lastFontIndex = (lastFontIndex + 1) % RECENT_FONTS.length;
        FontFallbackManager.RECENT_FONTS[FontFallbackManager.lastFontIndex] = font;
    }
}

