/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import opennlp.tools.tokenize.WhitespaceTokenizer;

public class DocumentSample {
    private final String category;
    private final List<String> text;
    private final Map<String, Object> extraInformation;

    public DocumentSample(String category, String text) {
        this(category, WhitespaceTokenizer.INSTANCE.tokenize(text));
    }

    public DocumentSample(String category, String[] text) {
        this(category, text, null);
    }

    public DocumentSample(String category, String[] text, Map<String, Object> extraInformation) {
        if (category == null) {
            throw new IllegalArgumentException("category must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.category = category;
        this.text = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(text)));
        this.extraInformation = extraInformation == null ? Collections.emptyMap() : extraInformation;
    }

    public String getCategory() {
        return this.category;
    }

    public String[] getText() {
        return this.text.toArray(new String[this.text.size()]);
    }

    public Map<String, Object> getExtraInformation() {
        return this.extraInformation;
    }

    public String toString() {
        StringBuilder sampleString = new StringBuilder();
        sampleString.append(this.category).append('\t');
        for (String s : this.text) {
            sampleString.append(s).append(' ');
        }
        if (sampleString.length() > 0) {
            sampleString.setLength(sampleString.length() - 1);
        }
        return sampleString.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DocumentSample) {
            DocumentSample a = (DocumentSample)obj;
            return this.getCategory().equals(a.getCategory()) && Arrays.equals(this.getText(), a.getText());
        }
        return false;
    }
}

