/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.languagetool.JLanguageTool;

public class CompoundRuleData {
    private final Set<String> incorrectCompounds = new HashSet<String>();
    private final Set<String> noDashSuggestion = new HashSet<String>();
    private final Set<String> onlyDashSuggestion = new HashSet<String>();

    public CompoundRuleData(String path) {
        this(new String[]{path});
    }

    public CompoundRuleData(String ... paths) {
        for (String path : paths) {
            try {
                this.loadCompoundFile(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load compound data from " + path, e);
            }
        }
    }

    Set<String> getIncorrectCompounds() {
        return Collections.unmodifiableSet(this.incorrectCompounds);
    }

    Set<String> getNoDashSuggestion() {
        return Collections.unmodifiableSet(this.noDashSuggestion);
    }

    Set<String> getOnlyDashSuggestion() {
        return Collections.unmodifiableSet(this.onlyDashSuggestion);
    }

    private void loadCompoundFile(String path) throws IOException {
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
             InputStreamReader reader = new InputStreamReader(stream, "utf-8");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                line = line.replace('-', ' ');
                this.validateLine(path, line);
                if (line.endsWith("+")) {
                    line = this.removeLastCharacter(line);
                    this.noDashSuggestion.add(line);
                } else if (line.endsWith("*")) {
                    line = this.removeLastCharacter(line);
                    this.onlyDashSuggestion.add(line);
                }
                this.incorrectCompounds.add(line);
            }
        }
    }

    private void validateLine(String path, String line) throws IOException {
        String[] parts = line.split(" ");
        if (parts.length == 1) {
            throw new RuntimeException("Not a compound in file " + path + ": " + line);
        }
        if (parts.length > 5) {
            throw new RuntimeException("Too many compound parts in file " + path + ": " + line + ", maximum allowed: " + 5);
        }
        if (this.incorrectCompounds.contains(line.toLowerCase())) {
            throw new RuntimeException("Duplicated word in file " + path + ": " + line);
        }
    }

    private String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

