/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import morfologik.fsa.FSA;
import morfologik.fsa.builders.CFSA2Serializer;
import morfologik.fsa.builders.FSABuilder;
import morfologik.stemming.Dictionary;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;

public class MorfologikMultiSpeller {
    private static final Map<String, Dictionary> dicPathToDict = new HashMap<String, Dictionary>();
    private final List<MorfologikSpeller> spellers;
    private final boolean convertsCase;

    public MorfologikMultiSpeller(String binaryDictPath, String plainTextPath, int maxEditDistance) throws IOException {
        this(binaryDictPath, new BufferedReader(new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(plainTextPath), "utf-8")), maxEditDistance);
        if (!plainTextPath.endsWith(".txt")) {
            throw new RuntimeException("Unsupported dictionary, plain text file needs to have suffix .txt: " + plainTextPath);
        }
    }

    public MorfologikMultiSpeller(String binaryDictPath, BufferedReader plainTextReader, int maxEditDistance) throws IOException {
        MorfologikSpeller speller = this.getBinaryDict(binaryDictPath, maxEditDistance);
        ArrayList<MorfologikSpeller> spellers = new ArrayList<MorfologikSpeller>();
        spellers.add(speller);
        this.convertsCase = speller.convertsCase();
        MorfologikSpeller plainTextSpeller = this.getPlainTextDictSpellerOrNull(plainTextReader, binaryDictPath, maxEditDistance);
        if (plainTextSpeller != null) {
            spellers.add(plainTextSpeller);
        }
        this.spellers = Collections.unmodifiableList(spellers);
    }

    private MorfologikSpeller getBinaryDict(String binaryDictPath, int maxEditDistance) throws IOException {
        if (binaryDictPath.endsWith(".dict")) {
            return new MorfologikSpeller(binaryDictPath, maxEditDistance);
        }
        throw new RuntimeException("Unsupported dictionary, binary Morfologik file needs to have suffix .dict: " + binaryDictPath);
    }

    @Nullable
    private MorfologikSpeller getPlainTextDictSpellerOrNull(BufferedReader plainTextReader, String dictPath, int maxEditDistance) throws IOException {
        List<byte[]> lines = this.getLines(plainTextReader);
        if (lines.size() == 0) {
            return null;
        }
        Dictionary dictionary = this.getDictionary(lines, dictPath);
        return new MorfologikSpeller(dictionary, maxEditDistance);
    }

    private List<byte[]> getLines(BufferedReader br) throws IOException {
        String line;
        ArrayList<byte[]> lines = new ArrayList<byte[]>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            lines.add(line.getBytes("utf-8"));
        }
        return lines;
    }

    private Dictionary getDictionary(List<byte[]> lines, String dictPath) throws IOException {
        Dictionary dictFromCache = dicPathToDict.get(dictPath);
        if (dictFromCache != null) {
            return dictFromCache;
        }
        Collections.sort(lines, FSABuilder.LEXICAL_ORDERING);
        FSA fsa = FSABuilder.build(lines);
        ByteArrayOutputStream fsaOutStream = (ByteArrayOutputStream)new CFSA2Serializer().serialize(fsa, (OutputStream)new ByteArrayOutputStream());
        ByteArrayInputStream fsaInStream = new ByteArrayInputStream(fsaOutStream.toByteArray());
        String infoFile = dictPath.replace(".dict", ".info");
        Dictionary dict = Dictionary.read((InputStream)fsaInStream, (InputStream)JLanguageTool.getDataBroker().getFromResourceDirAsStream(infoFile));
        dicPathToDict.put(dictPath, dict);
        return dict;
    }

    public boolean isMisspelled(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            if (speller.isMisspelled(word)) continue;
            return false;
        }
        return true;
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> result = new ArrayList<String>();
        for (MorfologikSpeller speller : this.spellers) {
            List<String> suggestions = speller.getSuggestions(word);
            for (String suggestion : suggestions) {
                if (result.contains(suggestion)) continue;
                result.add(suggestion);
            }
        }
        return result;
    }

    public boolean convertsCase() {
        return this.convertsCase;
    }
}

