; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFMACRO define (F &REST Def) `(compile_qi (QUOTE ,F) (QUOTE ,Def))) 

(DEFUN compile_qi (F Def)
  (LET ((ErrString (FORMAT NIL "syntax error in ~A" F)))
       (compile '<define> (CONS F Def) ErrString)))

(DEFMACRO fun (&REST Rules) `(compile_fun (QUOTE ,Rules)))

(DEFUN compile_fun (V88)
 (LET ((ErrString (FORMAT NIL "syntax error in ~{~S ~}" V88)))
  (LET ((Anon (gensym "anon")))
   (LET ((Func (compile '<define> (CONS Anon V88) ErrString)))
    Anon))))

(DEFUN <define> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<name> (<name> Stream)))
    (IF (NOT (failure? <name>))
     (LET ((<signature> (<signature> <name>)))
      (IF (NOT (failure? <signature>))
       (LET ((<rules> (<rules> <signature>)))
        (IF (NOT (failure? <rules>))
         (LIST (FIRST <rules>)
          (compile_to_machine_code (SECOND <name>) (SECOND <rules>)))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<name> (<name> Stream)))
    (IF (NOT (failure? <name>))
     (LET ((<rules> (<rules> <name>)))
      (IF (NOT (failure? <rules>))
       (LIST (FIRST <rules>)
        (compile_to_machine_code (SECOND <name>) (SECOND <rules>)))
       NIL))
     NIL)))))

(DEFUN <name> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (if (and (symbol? (CAAR Stream)) (not (sysfunc? (CAAR Stream))))
      (SETQ *currfunc* (CAAR Stream))
      (ERROR "~A is not a legitimate functor." (CAAR Stream))))
    NIL))))

(DEFUN sysfunc? (F) (element? F *sysfuncs*))

(DEFUN <signature> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQ (FIRST (FIRST Stream)) '{))
    (LET
     ((<signature-help>
       (<signature-help> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <signature-help>))
      (IF
       (AND (CONSP (FIRST <signature-help>))
        (EQ (FIRST (FIRST <signature-help>)) '}))
       (LIST
        (FIRST
         (LIST (REST (FIRST <signature-help>)) (SECOND <signature-help>)))
        (SECOND <signature-help>))
       NIL)
      NIL))
    NIL))))

(DEFUN <signature-help> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LET
     ((<signature-help>
       (<signature-help> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <signature-help>))
      (LIST (FIRST <signature-help>)
       (if (element? (CAAR Stream) (CONS '{ (CONS '} NIL)))
        (RETURN-FROM localfailure NIL)
        (CONS (CAAR Stream) (SECOND <signature-help>))))
      NIL))
    NIL))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <rules> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<rule> (<rule> Stream)))
    (IF (NOT (failure? <rule>))
     (LET ((<rules> (<rules> <rule>)))
      (IF (NOT (failure? <rules>))
       (LIST (FIRST <rules>) (CONS (SECOND <rule>) (SECOND <rules>))) NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<rule> (<rule> Stream)))
    (IF (NOT (failure? <rule>))
     (LIST (FIRST <rule>) (CONS (SECOND <rule>) NIL)) NIL)))))

(DEFUN <rule> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<patterns> (<patterns> Stream)))
    (IF (NOT (failure? <patterns>))
     (IF (AND (CONSP (FIRST <patterns>)) (EQ (FIRST (FIRST <patterns>)) '->))
      (LET
       ((<action>
         (<action> (LIST (REST (FIRST <patterns>)) (SECOND <patterns>)))))
       (IF (NOT (failure? <action>))
        (IF (AND (CONSP (FIRST <action>)) (EQ (FIRST (FIRST <action>)) 'where))
         (LET
          ((<guard>
            (<guard> (LIST (REST (FIRST <action>)) (SECOND <action>)))))
          (IF (NOT (failure? <guard>))
           (LIST (FIRST <guard>)
            (CONS (SECOND <patterns>)
             (CONS
              (CONS 'where
               (CONS (SECOND <guard>) (CONS (SECOND <action>) NIL)))
              NIL)))
           NIL))
         NIL)
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<patterns> (<patterns> Stream)))
    (IF (NOT (failure? <patterns>))
     (IF (AND (CONSP (FIRST <patterns>)) (EQ (FIRST (FIRST <patterns>)) '->))
      (LET
       ((<action>
         (<action> (LIST (REST (FIRST <patterns>)) (SECOND <patterns>)))))
       (IF (NOT (failure? <action>))
        (LIST (FIRST <action>)
         (CONS (SECOND <patterns>) (CONS (SECOND <action>) NIL)))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<patterns> (<patterns> Stream)))
    (IF (NOT (failure? <patterns>))
     (IF (AND (CONSP (FIRST <patterns>)) (EQ (FIRST (FIRST <patterns>)) '<-))
      (LET
       ((<action>
         (<action> (LIST (REST (FIRST <patterns>)) (SECOND <patterns>)))))
       (IF (NOT (failure? <action>))
        (IF (AND (CONSP (FIRST <action>)) (EQ (FIRST (FIRST <action>)) 'where))
         (LET
          ((<guard>
            (<guard> (LIST (REST (FIRST <action>)) (SECOND <action>)))))
          (IF (NOT (failure? <guard>))
           (LIST (FIRST <guard>)
            (CONS (SECOND <patterns>)
             (CONS
              (CONS 'where
               (CONS (SECOND <guard>) (CONS (bld_back (SECOND <action>)) NIL)))
              NIL)))
           NIL))
         NIL)
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<patterns> (<patterns> Stream)))
    (IF (NOT (failure? <patterns>))
     (IF (AND (CONSP (FIRST <patterns>)) (EQ (FIRST (FIRST <patterns>)) '<-))
      (LET
       ((<action>
         (<action> (LIST (REST (FIRST <patterns>)) (SECOND <patterns>)))))
       (IF (NOT (failure? <action>))
        (LIST (FIRST <action>)
         (CONS (SECOND <patterns>) (CONS (bld_back (SECOND <action>)) NIL)))
        NIL))
      NIL)
     NIL)))))

(DEFUN bld_back (V1)
 (LET ((Guard (LIST 'succeeds? (LIST 'set '*backtrack* V1))))
  (LET ((NewAction (LIST 'value '*backtrack*)))
   (LIST 'where Guard NewAction))))

(DEFUN succeeds? (X)
   (IF (EQL X #\Escape)
       'false
       'true))

(DEFUN fail-if (F X) (IF (EQ (FUNCALL F X) 'true)
                         #\Escape
                         X))

(DEFUN <patterns> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<pattern> (<pattern> Stream)))
    (IF (NOT (failure? <pattern>))
     (LET ((<patterns> (<patterns> <pattern>)))
      (IF (NOT (failure? <patterns>))
       (LIST (FIRST <patterns>)
        (CONS (ch-esc (SECOND <pattern>)) (SECOND <patterns>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <pattern> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<start_of_list> (<start_of_list> Stream)))
    (IF (NOT (failure? <start_of_list>))
     (IF
      (AND (CONSP (FIRST <start_of_list>))
       (EQ (FIRST (FIRST <start_of_list>)) '@p))
      (LET
       ((<pattern1>
         (<pattern1>
          (LIST (REST (FIRST <start_of_list>)) (SECOND <start_of_list>)))))
       (IF (NOT (failure? <pattern1>))
        (LET ((<pattern2> (<pattern2> <pattern1>)))
         (IF (NOT (failure? <pattern2>))
          (LET ((<end_of_list> (<end_of_list> <pattern2>)))
           (IF (NOT (failure? <end_of_list>))
            (LIST (FIRST <end_of_list>)
             (CONS '@p
              (CONS (SECOND <pattern1>) (CONS (SECOND <pattern2>) NIL))))
            NIL))
          NIL))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<start_of_list> (<start_of_list> Stream)))
    (IF (NOT (failure? <start_of_list>))
     (IF
      (AND (CONSP (FIRST <start_of_list>))
       (EQ (FIRST (FIRST <start_of_list>)) 'cons))
      (LET
       ((<pattern1>
         (<pattern1>
          (LIST (REST (FIRST <start_of_list>)) (SECOND <start_of_list>)))))
       (IF (NOT (failure? <pattern1>))
        (LET ((<pattern2> (<pattern2> <pattern1>)))
         (IF (NOT (failure? <pattern2>))
          (LET ((<end_of_list> (<end_of_list> <pattern2>)))
           (IF (NOT (failure? <end_of_list>))
            (LIST (FIRST <end_of_list>)
             (CONS 'cons
              (CONS (SECOND <pattern1>) (CONS (SECOND <pattern2>) NIL))))
            NIL))
          NIL))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (if (cons? (CAAR Stream))
      (ERROR "~A is not a legitimate constructor~%" (CAAR Stream))
      (RETURN-FROM localfailure NIL)))
    NIL))
  (BLOCK localfailure
   (LET ((<simple_pattern> (<simple_pattern> Stream)))
    (IF (NOT (failure? <simple_pattern>)) <simple_pattern> NIL)))))

(DEFUN <simple_pattern> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQ (FIRST (FIRST Stream)) '_))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (gensym "X"))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\Escape))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (LIST 'esc))
    NIL))
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (IF (MEMBER (CAAR Stream) '(-> <- _))
      (RETURN-FROM localfailure NIL) (CAAR Stream)))
    NIL))))

(DEFUN <pattern1> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<pattern> (<pattern> Stream)))
    (IF (NOT (failure? <pattern>)) <pattern> NIL)))))

(DEFUN <pattern2> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<pattern> (<pattern> Stream)))
    (IF (NOT (failure? <pattern>)) <pattern> NIL)))))

(DEFUN <action> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\Escape))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (LIST 'esc))
    NIL))
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (CAAR Stream))
    NIL))))

(DEFUN ch-esc (V83)
 (COND ((AND (CONSP V83) (EQ 'esc (CAR V83)) (NULL (CDR V83))) (esc)) (T V83)))

(DEFCONSTANT *failure-object* #\Escape)

(DEFUN <guard> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (CAAR Stream))
    NIL))))

(DEFUN compile_to_machine_code (V85 V86)
(LET ((Lambda+ (compile-to-lambda+ V85 V86)))
 (LET ((Lisp (compile-to-lisp V85 Lambda+)))
  (LET ((Store (record_source V85 Lisp))) (COMPILE (EVAL Lisp))))))

(DEFUN compile-to-lambda+ (V1 V2)
 (LET ((Arity (aritycheck V1 V2)))
  (LET ((Free (MAPCAR #'(LAMBDA (Rule) (free-variable-check V1 Rule)) V2)))
   (LET ((Variables (parameters Arity)))
    (LET ((Linear (MAPCAR 'linearise V2)))
     (LET ((Abstractions (MAPCAR 'abstract-rule Linear)))
      (LET
       ((Applications
         (MAPCAR #'(LAMBDA (X) (application_build Variables X)) Abstractions)))
       (LIST Variables Applications))))))))

(DEFUN free-variable-check (V3 V4)
 (COND
  ((AND (CONSP V4) (CONSP (CDR V4)) (NULL (CDR (CDR V4))))
   (LET ((Bound (extract-vars (CAR V4))))
    (LET ((Free (extract-free-vars Bound (CAR (CDR V4)))))
     (free-variable-warnings V3 Free))))
  (T (implementation_error 'free-variable-check))))

(DEFUN extract-vars (V5)
 (COND ((wrapper (variable? V5)) (LIST V5))
  ((CONSP V5)
   (THE LIST (union (extract-vars (CAR V5)) (extract-vars (CDR V5)))))
  (T NIL)))

(DEFUN extract-free-vars (V7 V8)
 (COND
  ((AND (wrapper (variable? V8)) (NOT (wrapper (element? V8 V7))))
   (LIST V8))
  ((AND (CONSP V8) (EQ (CAR V8) 'rule)) NIL)
  ((AND (CONSP V8) (EQ '/. (CAR V8)) (CONSP (CDR V8)) (CONSP (CDR (CDR V8)))
    (NULL (CDR (CDR (CDR V8)))))
   (LET* ((V9 (CDR V8)))
    (extract-free-vars (CONS (CAR V9) V7) (CAR (CDR V9)))))
  ((AND (CONSP V8) (EQ 'let (CAR V8)) (CONSP (CDR V8)) (CONSP (CDR (CDR V8)))
    (CONSP (CDR (CDR (CDR V8)))) (NULL (CDR (CDR (CDR (CDR V8))))))
   (LET* ((V10 (CDR V8)) (V11 (CDR V10)))
    (THE LIST
     (union (extract-free-vars V7 (CAR V11))
      (extract-free-vars (CONS (CAR V10) V7) (CAR (CDR V11)))))))
   ((CONSP V8) (union (extract-free-vars V7 (CAR V8)) (extract-free-vars V7 (CDR V8))))
  (T NIL)))

(DEFUN free-variable-warnings (V15 V16)
 (IF (NULL V16) '_
     (warn (FORMAT NIL "The following variables are free in ~A: ~{~A, ~}~%" V15 V16)))) 

(DEFUN linearise (V2)
 (COND
  ((AND (CONSP V2) (CONSP (CDR V2)) (NULL (CDR (CDR V2))))
   (LET* ((V3 (CAR V2))) (linearise-help (flatten V3) V3 (CAR (CDR V2)))))
  (T (implementation_error 'linearise))))

(DEFUN flatten (V4)
 (COND ((NULL V4) NIL)
       ((CONSP V4) (APPEND (flatten (CAR V4)) (flatten (CDR V4))))
       (T (LIST V4)))) 
  
(DEFUN linearise-help (V5 V6 V7)
 (COND ((NULL V5) (LIST V6 V7))
  ((CONSP V5)
   (LET* ((V8 (CAR V5)) (V9 (CDR V5)))
    (if
     (THE SYMBOL
      (and (THE SYMBOL (variable? V8)) (THE SYMBOL (element? V8 V9))))
     (LET ((Var (gensym "X")))
      (LET ((NewAction (LIST 'where (LIST 'qi_= V8 Var) V7)))
       (LET ((NewPatts (linearise-X V8 Var V6)))
        (linearise-help V9 NewPatts NewAction))))
     (linearise-help V9 V6 V7))))
  (T (implementation_error 'linearise-help))))

(DEFUN linearise-X (V23 V24 V25)
 (COND ((ABSEQUAL V23 V25) V24)
  ((CONSP V25)
   (LET* ((V26 (CAR V25)) (V27 (CDR V25)))
    (LET ((L (linearise-X V23 V24 V26)))
     (if (qi_= L V26) (CONS V26 (linearise-X V23 V24 V27)) (CONS L V27)))))
  (T V25)))

(DEFUN aritycheck (V40 V41)
 (COND
  ((AND (CONSP V41) (CONSP (CAR V41)) (NULL (CDR V41)))
   (LIST-LENGTH (CAR (CAR V41))))
  ((AND (CONSP V41) (CONSP (CAR V41)) (CONSP (CDR V41))
    (CONSP (CAR (CDR V41))))
   (LET* ((V42 (CDR V41)) (V43 (CAR V42)) (V44 (CAR V43)))
    (if (qi_= (LIST-LENGTH (CAR (CAR V41))) (LIST-LENGTH V44))
     (aritycheck V40 (CONS (CONS V44 '_) (CDR V42)))
     (ERROR "arity error in ~A~%" V40))))
  (T (implementation_error 'aritycheck))))

(DEFUN abstract-rule (V12)
 (COND
  ((AND (CONSP V12) (CONSP (CDR V12)) (NULL (CDR (CDR V12))))
   (abstraction_build (CAR V12) (CAR (CDR V12))))
  (T (implementation_error 'abstract-rule))))

(DEFUN abstraction_build (V50 V51)
 (COND ((NULL V50) V51)
  ((CONSP V50) (LIST '/. (CAR V50) (abstraction_build (CDR V50) V51)))
  (T (implementation_error 'abstraction_build))))

(DEFUN parameters (V52)
 (COND ((EQL 0 V52) NIL)
  (T (CONS (THE SYMBOL (gensym "V")) (parameters (1- V52))))))

(DEFUN application_build (V53 V54)
 (COND ((NULL V53) V54)
  ((CONSP V53) (application_build (CDR V53) (LIST V54 (CAR V53))))
  (T (implementation_error 'application_build))))

(DEFUN compile-to-lisp (V290 V291)
 (COND
  ((AND (CONSP V291) (CONSP (CDR V291)) (NULL (CDR (CDR V291))))
   (LET* ((V292 (CAR V291)))
    (LET ((Arity (store_arity V290 (LIST-LENGTH V292))))
     (LET ((Reduce (MAPCAR 'reduce (CAR (CDR V291)))))
      (LET ((CondExpression (cond-expression V290 V292 Reduce)))
       (LET ((Lisp (LIST 'DEFUN V290 V292 CondExpression)))
        (optimise-lisp *speed* Lisp)))))))
  (T (implementation_error 'compile-to-lisp))))

(DEFUN reduce (V293)
 (SETQ *teststack* NIL)
  (LET ((Result (reduce-help V293)))
   (LIST (CONS ':tests (REVERSE *teststack*)) Result)))

(DEFUN reduce-help (V294)
 (COND
  ((AND (CONSP V294) (CONSP (CAR V294)) (EQ '/. (CAR (CAR V294)))
    (CONSP (CDR (CAR V294))) (CONSP (CAR (CDR (CAR V294))))
    (EQ 'cons (CAR (CAR (CDR (CAR V294)))))
    (CONSP (CDR (CAR (CDR (CAR V294)))))
    (CONSP (CDR (CDR (CAR (CDR (CAR V294))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CAR V294)))))))
    (CONSP (CDR (CDR (CAR V294)))) (NULL (CDR (CDR (CDR (CAR V294)))))
    (CONSP (CDR V294)) (NULL (CDR (CDR V294))))
   (LET*
    ((V295 (CDR V294)) (V296 (CAR V294)) (V297 (CDR V296)) (V298 (CAR V297))
     (V299 (CDR V298)))
    (add-test (CONS 'CONSP V295))
     (LET
      ((Abstraction
        (LIST '/. (CAR V299)
         (LIST '/. (CAR (CDR V299)) (ebr (CAR V295) V298 (CAR (CDR V297)))))))
      (LET
       ((Application
         (LIST (LIST Abstraction (CONS 'CAR V295)) (CONS 'CDR V295))))
       (reduce-help Application)))))
  ((AND (CONSP V294) (CONSP (CAR V294)) (EQ '/. (CAR (CAR V294)))
    (CONSP (CDR (CAR V294))) (CONSP (CAR (CDR (CAR V294))))
    (EQ '@p (CAR (CAR (CDR (CAR V294))))) (CONSP (CDR (CAR (CDR (CAR V294)))))
    (CONSP (CDR (CDR (CAR (CDR (CAR V294))))))
    (NULL (CDR (CDR (CDR (CAR (CDR (CAR V294)))))))
    (CONSP (CDR (CDR (CAR V294)))) (NULL (CDR (CDR (CDR (CAR V294)))))
    (CONSP (CDR V294)) (NULL (CDR (CDR V294))))
   (LET*
    ((V300 (CDR V294)) (V301 (CAR V294)) (V302 (CDR V301)) (V303 (CAR V302))
     (V304 (CDR V303)))
    (add-test (CONS 'TUPLE-P V300))
     (LET
      ((Abstraction
        (LIST '/. (CAR V304)
         (LIST '/. (CAR (CDR V304)) (ebr (CAR V300) V303 (CAR (CDR V302)))))))
      (LET
       ((Application
         (LIST (LIST Abstraction (CONS 'fst V300)) (CONS 'snd V300))))
       (reduce-help Application)))))
  ((AND (CONSP V294) (CONSP (CAR V294)) (EQ '/. (CAR (CAR V294)))
    (CONSP (CDR (CAR V294))) (CONSP (CDR (CDR (CAR V294))))
    (NULL (CDR (CDR (CDR (CAR V294))))) (CONSP (CDR V294))
    (NULL (CDR (CDR V294)))
    (NOT (wrapper (variable? (CAR (CDR (CAR V294)))))))
   (LET* ((V305 (CAR V294)) (V306 (CDR V305)))
    (add-test (equality-test (CAR V306) (CAR (CDR V294))))
     (reduce-help (CAR (CDR V306)))))
  ((AND (CONSP V294) (CONSP (CAR V294)) (EQ '/. (CAR (CAR V294)))
    (CONSP (CDR (CAR V294))) (CONSP (CDR (CDR (CAR V294))))
    (NULL (CDR (CDR (CDR (CAR V294))))) (CONSP (CDR V294))
    (NULL (CDR (CDR V294))))
   (LET* ((V307 (CAR V294)) (V308 (CDR V307)))
    (reduce-help (ebr (CAR (CDR V294)) (CAR V308) (CAR (CDR V308))))))
  ((AND (CONSP V294) (EQ 'where (CAR V294)) (CONSP (CDR V294))
    (CONSP (CDR (CDR V294))) (NULL (CDR (CDR (CDR V294)))))
   (LET* ((V309 (CDR V294)))
    (add-test (LIST 'wrapper (CAR V309)))
    (reduce-help (CAR (CDR V309)))))
  ((AND (CONSP V294) (CONSP (CDR V294)) (NULL (CDR (CDR V294))))
   (LET* ((V310 (CAR V294)))
    (LET ((Z (reduce-help V310)))
     (IF (EQUAL V310 Z) V294 (reduce-help (CONS Z (CDR V294)))))))
  (T V294)))

(DEFUN ebr (V321 V322 V323)
 (COND ((ABSEQUAL V322 V323) V321)
  ((AND (CONSP V323) (EQ '/. (CAR V323)) (CONSP (CDR V323))
    (CONSP (CDR (CDR V323))) (NULL (CDR (CDR (CDR V323))))
    (> (occurrences V322 (CAR (CDR V323))) 0))
   V323)
  ((AND (CONSP V323) (EQ 'let (CAR V323)) (CONSP (CDR V323))
    (CONSP (CDR (CDR V323))) (NULL (CDR (CDR (CDR V323))))
    (ABSEQUAL V322 (CAR (CDR V323))))
   V323)
  ((CONSP V323) (CONS (ebr V321 V322 (CAR V323)) (ebr V321 V322 (CDR V323))))
  (T V323)))

(DEFUN add-test (V324) (SETQ *teststack* (CONS V324 *teststack*)))

(DEFUN equality-test (V325 V326)
 (COND ((NULL V325) (LIST 'NULL V326))
  ((OR (NUMBERP V325) (CHARACTERP V325)) (LIST 'EQL V325 V326))
  ((OR (MEMBER V325 '(true false)) (wrapper (symbol? V325)))
   (LIST 'EQ V325 V326))
  ((STRINGP V325) (LIST 'EQUAL V325 V326)) 
  (T (implementation_error 'equality-test))))

(DEFUN cond-expression (V327 V328 V329)
 (LET ((Err (insert-error-condition V327 V329)))
  (LET ((Cases (MAPCAR 'make-case Err))) (cond-form V328 Cases))))

(DEFUN cond-form (V42 V43)
 (COND
  ((AND (CONSP V43) (CONSP (CAR V43)) (CONSP (CDR (CAR V43)))
    (NULL (CDR (CDR (CAR V43)))) (EQ T (CAR (CAR V43))))
   (lisp-form V42 (CAR (CDR (CAR V43)))))
  (T (CONS 'COND (make-lispform V42 V43)))))

(DEFUN make-lispform (V334 V335)
 (COND ((NULL V335) NIL)
  ((AND (CONSP V335) (CONSP (CAR V335)) (CONSP (CAR (CAR V335)))
    (CONSP (CDR (CAR V335))) (NULL (CDR (CDR (CAR V335))))
    (EQ 'AND (CAR (CAR (CAR V335)))))
   (LET* ((V336 (CAR V335)) (V337 (CAR V336)))
    (LET ((NewTests (MAPCAR #'(LAMBDA (Test) (lisp-form V334 Test)) (CDR V337))))
     (LET ((NewResult (lisp-form V334 (CAR (CDR V336)))))
      (CONS (LIST (CONS (CAR V337) NewTests) NewResult)
       (make-lispform V334 (CDR V335)))))))
  ((AND (CONSP V335) (CONSP (CAR V335)) (CONSP (CDR (CAR V335)))
    (NULL (CDR (CDR (CAR V335)))))
   (LET* ((V338 (CAR V335)))
    (LET ((NewTest (lisp-form V334 (CAR V338))))
     (LET ((NewResult (lisp-form V334 (CAR (CDR V338)))))
      (CONS (LIST NewTest NewResult) (make-lispform V334 (CDR V335)))))))
  (T (implementation_error 'make-lispform))))

(DEFUN insert-error-condition (V57 V58)
 (COND
  ((AND (CONSP V58) (CONSP (CAR V58)) (CONSP (CAR (CAR V58)))
    (EQ ':tests (CAR (CAR (CAR V58)))) (NULL (CDR (CAR (CAR V58))))
    (CONSP (CDR (CAR V58))) (NULL (CDR (CDR (CAR V58)))))
   V58)
  ((AND (CONSP V58) (CONSP (CAR V58)) (CONSP (CAR (CAR V58)))
    (EQ ':tests (CAR (CAR (CAR V58)))) (CONSP (CDR (CAR V58)))
    (NULL (CDR (CDR (CAR V58)))) (NULL (CDR V58)))
   (LIST (CAR V58) (error-condition V57)))
  ((CONSP V58) (cons (CAR V58) (insert-error-condition V57 (CDR V58))))
  (T V58)))

(DEFUN error-condition (V345) (LIST (LIST ':tests T) (LIST 'f_error V345)))

(DEFUN make-case (V346)
 (COND
  ((AND (CONSP V346) (CONSP (CAR V346)) (EQ ':tests (CAR (CAR V346)))
    (NULL (CDR (CAR V346))) (CONSP (CDR V346)) (NULL (CDR (CDR V346))))
   (CONS T (CDR V346)))
  ((AND (CONSP V346) (CONSP (CAR V346)) (EQ ':tests (CAR (CAR V346)))
    (CONSP (CDR (CAR V346))) (NULL (CDR (CDR (CAR V346)))) (CONSP (CDR V346))
    (NULL (CDR (CDR V346))))
   (CONS (CAR (CDR (CAR V346))) (CDR V346)))
  ((AND (CONSP V346) (CONSP (CAR V346)) (EQ ':tests (CAR (CAR V346)))
    (CONSP (CDR V346)) (NULL (CDR (CDR V346))))
   (CONS (CONS 'AND (CDR (CAR V346))) (CDR V346)))
  (T V346)))

(SETQ *speed* 1)