/*
 * Decompiled with CFR 0.152.
 */
package com.android.fastdeploy;

import com.android.fastdeploy.APKEntry;
import com.android.fastdeploy.APKMetaData;
import com.android.fastdeploy.PatchFormatException;
import com.android.fastdeploy.PatchUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class DeployPatchGenerator {
    private static final int BUFFER_SIZE = 131072;

    public static void main(String[] args) {
        try {
            String verboseFlag;
            if (args.length < 2) {
                DeployPatchGenerator.showUsage(0);
            }
            boolean verbose = false;
            if (args.length > 2 && (verboseFlag = args[2]).compareTo("--verbose") == 0) {
                verbose = true;
            }
            StringBuilder sb = null;
            String apkPath = args[0];
            String deviceMetadataPath = args[1];
            File hostFile = new File(apkPath);
            List<APKEntry> deviceZipEntries = DeployPatchGenerator.getMetadataFromFile(deviceMetadataPath);
            System.err.println("Device Entries (" + deviceZipEntries.size() + ")");
            if (verbose) {
                sb = new StringBuilder();
                for (APKEntry aPKEntry : deviceZipEntries) {
                    DeployPatchGenerator.APKEntryToString(aPKEntry, sb);
                }
                System.err.println(sb.toString());
            }
            List<APKEntry> hostFileEntries = PatchUtils.getAPKMetaData(hostFile).getEntriesList();
            System.err.println("Host Entries (" + hostFileEntries.size() + ")");
            if (verbose) {
                sb = new StringBuilder();
                for (APKEntry entry : hostFileEntries) {
                    DeployPatchGenerator.APKEntryToString(entry, sb);
                }
                System.err.println(sb.toString());
            }
            List<AbstractMap.SimpleEntry<APKEntry, APKEntry>> list = DeployPatchGenerator.getIdenticalContents(deviceZipEntries, hostFileEntries);
            DeployPatchGenerator.reportIdenticalContents(list, hostFile);
            if (verbose) {
                sb = new StringBuilder();
                for (AbstractMap.SimpleEntry<APKEntry, APKEntry> identicalEntry : list) {
                    APKEntry entry = identicalEntry.getValue();
                    DeployPatchGenerator.APKEntryToString(entry, sb);
                }
                System.err.println("Identical Entries (" + list.size() + ")");
                System.err.println(sb.toString());
            }
            DeployPatchGenerator.createPatch(list, hostFile, System.out);
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    private static void showUsage(int exitCode) {
        System.err.println("usage: deploypatchgenerator <apkpath> <deviceapkmetadata> [--verbose]");
        System.err.println("");
        System.exit(exitCode);
    }

    private static void APKEntryToString(APKEntry entry, StringBuilder outputString) {
        outputString.append(String.format("Filename: %s\n", entry.getFileName()));
        outputString.append(String.format("CRC32: 0x%08X\n", entry.getCrc32()));
        outputString.append(String.format("Data Offset: %d\n", entry.getDataOffset()));
        outputString.append(String.format("Compressed Size: %d\n", entry.getCompressedSize()));
        outputString.append(String.format("Uncompressed Size: %d\n", entry.getUncompressedSize()));
    }

    private static List<APKEntry> getMetadataFromFile(String deviceMetadataPath) throws IOException {
        FileInputStream is = new FileInputStream(new File(deviceMetadataPath));
        APKMetaData apkMetaData = APKMetaData.parseDelimitedFrom(is);
        return apkMetaData.getEntriesList();
    }

    private static List<AbstractMap.SimpleEntry<APKEntry, APKEntry>> getIdenticalContents(List<APKEntry> deviceZipEntries, List<APKEntry> hostZipEntries) throws IOException {
        ArrayList<AbstractMap.SimpleEntry<APKEntry, APKEntry>> identicalContents = new ArrayList<AbstractMap.SimpleEntry<APKEntry, APKEntry>>();
        for (APKEntry deviceZipEntry : deviceZipEntries) {
            for (APKEntry hostZipEntry : hostZipEntries) {
                if (deviceZipEntry.getCrc32() != hostZipEntry.getCrc32() || !deviceZipEntry.getFileName().equals(hostZipEntry.getFileName())) continue;
                identicalContents.add(new AbstractMap.SimpleEntry<APKEntry, APKEntry>(deviceZipEntry, hostZipEntry));
            }
        }
        Collections.sort(identicalContents, new Comparator<AbstractMap.SimpleEntry<APKEntry, APKEntry>>(){

            @Override
            public int compare(AbstractMap.SimpleEntry<APKEntry, APKEntry> p1, AbstractMap.SimpleEntry<APKEntry, APKEntry> p2) {
                return Long.compare(p1.getValue().getDataOffset(), p2.getValue().getDataOffset());
            }
        });
        return identicalContents;
    }

    private static void reportIdenticalContents(List<AbstractMap.SimpleEntry<APKEntry, APKEntry>> identicalContentsEntrySet, File hostFile) throws IOException {
        long totalEqualBytes = 0L;
        int totalEqualFiles = 0;
        for (AbstractMap.SimpleEntry<APKEntry, APKEntry> entries : identicalContentsEntrySet) {
            APKEntry hostAPKEntry = entries.getValue();
            totalEqualBytes += hostAPKEntry.getCompressedSize();
            ++totalEqualFiles;
        }
        float savingPercent = (float)(totalEqualBytes * 100L) / (float)hostFile.length();
        System.err.println("Detected " + totalEqualFiles + " equal APK entries");
        System.err.println(totalEqualBytes + " bytes are equal out of " + hostFile.length() + " (" + savingPercent + "%)");
    }

    static void createPatch(List<AbstractMap.SimpleEntry<APKEntry, APKEntry>> zipEntrySimpleEntrys, File hostFile, OutputStream patchStream) throws IOException, PatchFormatException {
        FileInputStream hostFileInputStream = new FileInputStream(hostFile);
        patchStream.write("HAMADI/IHD".getBytes(StandardCharsets.US_ASCII));
        PatchUtils.writeFormattedLong(hostFile.length(), patchStream);
        byte[] buffer = new byte[131072];
        long totalBytesWritten = 0L;
        for (AbstractMap.SimpleEntry<APKEntry, APKEntry> entrySimpleEntry : zipEntrySimpleEntrys) {
            APKEntry deviceAPKEntry = entrySimpleEntry.getKey();
            APKEntry hostAPKEntry = entrySimpleEntry.getValue();
            long newDataLen = hostAPKEntry.getDataOffset() - totalBytesWritten;
            long oldDataOffset = deviceAPKEntry.getDataOffset();
            long oldDataLen = deviceAPKEntry.getCompressedSize();
            PatchUtils.writeFormattedLong(newDataLen, patchStream);
            PatchUtils.pipe(hostFileInputStream, patchStream, buffer, newDataLen);
            PatchUtils.writeFormattedLong(oldDataOffset, patchStream);
            PatchUtils.writeFormattedLong(oldDataLen, patchStream);
            long skip = hostFileInputStream.skip(oldDataLen);
            if (skip != oldDataLen) {
                throw new PatchFormatException("skip error: attempted to skip " + oldDataLen + " bytes but return code was " + skip);
            }
            totalBytesWritten += oldDataLen + newDataLen;
        }
        long remainderLen = hostFile.length() - totalBytesWritten;
        PatchUtils.writeFormattedLong(remainderLen, patchStream);
        PatchUtils.pipe(hostFileInputStream, patchStream, buffer, remainderLen);
        PatchUtils.writeFormattedLong(0L, patchStream);
        PatchUtils.writeFormattedLong(0L, patchStream);
        patchStream.flush();
    }
}

