/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.StatePrettyPrinter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

public class GLCompositeProperty
implements IGLProperty {
    private final GLStateType mType;
    private final Map<GLStateType, IGLProperty> mPropertiesMap;
    private IGLProperty mParent;

    public GLCompositeProperty(GLStateType type, IGLProperty ... iglProperties) {
        this.mType = type;
        this.mPropertiesMap = new EnumMap<GLStateType, IGLProperty>(GLStateType.class);
        IGLProperty[] iGLPropertyArray = iglProperties;
        int n = iglProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IGLProperty p = iGLPropertyArray[n2];
            this.mPropertiesMap.put(p.getType(), p);
            p.setParent(this);
            ++n2;
        }
    }

    public Collection<IGLProperty> getProperties() {
        return this.mPropertiesMap.values();
    }

    public IGLProperty getProperty(GLStateType name) {
        return this.mPropertiesMap.get((Object)name);
    }

    @Override
    public GLCompositeProperty clone() {
        IGLProperty[] props = new IGLProperty[this.mPropertiesMap.size()];
        int i = 0;
        for (IGLProperty p : this.mPropertiesMap.values()) {
            props[i++] = p.clone();
        }
        return new GLCompositeProperty(this.getType(), props);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GLCompositeProperty {");
        for (IGLProperty p : this.mPropertiesMap.values()) {
            sb.append(p.toString());
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String getStringValue() {
        return "";
    }

    @Override
    public GLStateType getType() {
        return this.mType;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isDefault() {
        for (IGLProperty p : this.mPropertiesMap.values()) {
            if (p.isDefault()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IGLProperty getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IGLProperty parent) {
        this.mParent = parent;
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("Values cannot be set for composite properties.");
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Values cannot be obtained for composite properties.");
    }

    @Override
    public void prettyPrint(StatePrettyPrinter pp) {
        pp.prettyPrint(this.mType, null);
        pp.incrementIndentLevel();
        for (IGLProperty p : this.mPropertiesMap.values()) {
            p.prettyPrint(pp);
        }
        pp.decrementIndentLevel();
    }
}

