/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.filters.CoreExpressionFilter;
import org.eclipse.ui.internal.navigator.filters.SkeletonViewerFilter;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;

public class CommonFilterDescriptor
implements ICommonFilterDescriptor,
INavigatorContentExtPtConstants {
    private IConfigurationElement element;
    private Expression filterExpression;
    private String id;

    protected CommonFilterDescriptor(IConfigurationElement anElement) {
        this.element = anElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children;
        this.id = this.element.getAttribute("id");
        if (this.id == null) {
            this.id = "";
        }
        if ((children = this.element.getChildren("filterExpression")).length == 1) {
            this.filterExpression = new CustomAndExpression(children[0]);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public boolean isActiveByDefault() {
        return Boolean.valueOf(this.element.getAttribute("activeByDefault"));
    }

    public boolean isVisibleInUi() {
        String attr = this.element.getAttribute("visibleInUI");
        if (attr == null) {
            return true;
        }
        return Boolean.valueOf(attr);
    }

    public ViewerFilter createFilter() {
        final ViewerFilter[] filter = new ViewerFilter[1];
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){

            public void run() throws Exception {
                if (CommonFilterDescriptor.this.filterExpression != null) {
                    if (CommonFilterDescriptor.this.element.getAttribute("class") != null) {
                        NavigatorPlugin.log(2, 0, "A \"commonFilter\" was specified in " + CommonFilterDescriptor.this.element.getDeclaringExtension().getNamespaceIdentifier() + " which specifies a \"class\" attribute and an Core Expression.\n" + "Only the Core Expression will be respected.", null);
                    }
                    filter[0] = new CoreExpressionFilter(CommonFilterDescriptor.this.filterExpression);
                    return;
                }
                filter[0] = (ViewerFilter)CommonFilterDescriptor.this.element.createExecutableExtension("class");
            }
        });
        if (filter[0] != null) {
            return filter[0];
        }
        return SkeletonViewerFilter.INSTANCE;
    }

    public String toString() {
        return "CommonFilterDescriptor[" + this.getName() + " (" + this.getId() + ")]";
    }
}

