/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.jffi.AsmRuntime;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jaffl.provider.jffi.NumberUtil;
import com.kenai.jaffl.provider.jffi.SkinnyMethodAdapter;
import com.kenai.jaffl.struct.Struct;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.MethodVisitor;

class AsmUtil {
    private AsmUtil() {
    }

    public static final MethodVisitor newTraceMethodVisitor(MethodVisitor mv) {
        try {
            Class<?> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceMethodVisitor");
            Constructor<?> c = tmvClass.getDeclaredConstructor(MethodVisitor.class);
            return (MethodVisitor)c.newInstance(mv);
        }
        catch (Throwable t) {
            return mv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, OutputStream out) {
        return AsmUtil.newTraceClassVisitor(cv, new PrintWriter(out, true));
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, PrintWriter out) {
        try {
            Class<?> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceClassVisitor");
            Constructor<?> c = tmvClass.getDeclaredConstructor(ClassVisitor.class, PrintWriter.class);
            return (ClassVisitor)c.newInstance(cv, out);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final ClassVisitor newCheckClassAdapter(ClassVisitor cv) {
        try {
            Class<?> tmvClass = Class.forName("org.python.objectweb.asm.util.CheckClassAdapter");
            Constructor<?> c = tmvClass.getDeclaredConstructor(ClassVisitor.class);
            return (ClassVisitor)c.newInstance(cv);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final Class unboxedReturnType(Class type) {
        if (Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedType(Class boxedType) {
        if (boxedType == Byte.class) {
            return Byte.TYPE;
        }
        if (boxedType == Short.class) {
            return Short.TYPE;
        }
        if (boxedType == Integer.class) {
            return Integer.TYPE;
        }
        if (boxedType == Long.class) {
            return Long.TYPE;
        }
        if (boxedType == Float.class) {
            return Float.TYPE;
        }
        if (boxedType == Double.class) {
            return Double.TYPE;
        }
        if (boxedType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxedType == NativeLong.class) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (Pointer.class.isAssignableFrom(boxedType) || Struct.class.isAssignableFrom(boxedType)) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return boxedType;
    }

    public static final Class boxedType(Class type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    static final void emitReturnOp(SkinnyMethodAdapter mv, Class returnType) {
        if (!returnType.isPrimitive()) {
            mv.areturn();
        } else if (Long.TYPE == returnType) {
            mv.lreturn();
        } else if (Float.TYPE == returnType) {
            mv.freturn();
        } else if (Double.TYPE == returnType) {
            mv.dreturn();
        } else if (Void.TYPE == returnType) {
            mv.voidreturn();
        } else {
            mv.ireturn();
        }
    }

    static final int calculateLocalVariableSpace(Class type) {
        return Long.TYPE == type || Double.TYPE == type ? 2 : 1;
    }

    static final int calculateLocalVariableSpace(Class ... types2) {
        int size = 0;
        for (int i = 0; i < types2.length; ++i) {
            size += AsmUtil.calculateLocalVariableSpace(types2[i]);
        }
        return size;
    }

    private static final void unboxPointerOrStruct(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == nativeType ? "longValue" : "intValue", CodegenUtils.sig(nativeType, type));
    }

    static final void unboxPointer(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxPointerOrStruct(mv, Pointer.class, nativeType);
    }

    static final void unboxStruct(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxPointerOrStruct(mv, Struct.class, nativeType);
    }

    static final void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        String intValueSignature;
        String intValueMethod = Long.TYPE == nativeType ? "longValue" : "intValue";
        String string2 = intValueSignature = Long.TYPE == nativeType ? "()J" : "()I";
        if (Byte.class == boxedType || Short.class == boxedType || Integer.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), intValueMethod, intValueSignature);
        } else if (Long.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
        } else if (Float.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
        } else if (Double.class == boxedType) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
        } else if (NativeLong.class.isAssignableFrom(boxedType)) {
            mv.invokevirtual(CodegenUtils.p(boxedType), intValueMethod, intValueSignature);
        } else if (Boolean.class.isAssignableFrom(boxedType)) {
            mv.invokevirtual(CodegenUtils.p(boxedType), "booleanValue", "()Z");
            NumberUtil.widen(mv, Boolean.TYPE, nativeType);
        } else {
            throw new IllegalArgumentException("unsupported Number subclass: " + boxedType);
        }
    }
}

