/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.SymbolNotFoundError;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library
extends com.kenai.jaffl.provider.Library {
    private final String[] libraryNames;
    private volatile List<com.kenai.jffi.Library> nativeLibraries = Collections.EMPTY_LIST;

    Library(String name) {
        this.libraryNames = new String[]{name};
    }

    Library(String ... names) {
        this.libraryNames = (String[])names.clone();
    }

    @Override
    public Invoker getInvoker(Method method, Map<LibraryOption, ?> options) {
        return DefaultInvokerFactory.getInstance().createInvoker(method, this, options);
    }

    @Override
    public Object libraryLock() {
        return this;
    }

    long getSymbolAddress(String name) {
        for (com.kenai.jffi.Library l : this.getNativeLibraries()) {
            long address = l.getSymbolAddress(name);
            if (address == 0L) continue;
            return address;
        }
        return 0L;
    }

    long findSymbolAddress(String name) {
        long address = this.getSymbolAddress(name);
        if (address == 0L) {
            throw new SymbolNotFoundError(com.kenai.jffi.Library.getLastError());
        }
        return address;
    }

    private synchronized List<com.kenai.jffi.Library> getNativeLibraries() {
        if (!this.nativeLibraries.isEmpty()) {
            return this.nativeLibraries;
        }
        this.nativeLibraries = this.loadNativeLibraries();
        return this.nativeLibraries;
    }

    private synchronized List<com.kenai.jffi.Library> loadNativeLibraries() {
        ArrayList<com.kenai.jffi.Library> libs = new ArrayList<com.kenai.jffi.Library>();
        ArrayList errors2 = new ArrayList(0);
        for (String libraryName : this.libraryNames) {
            String path;
            com.kenai.jffi.Library lib = com.kenai.jffi.Library.getCachedInstance(libraryName, 1);
            if (lib == null && libraryName != null && (path = Library.locateLibrary(libraryName)) != null && !libraryName.equals(path)) {
                lib = com.kenai.jffi.Library.getCachedInstance(path, 1);
            }
            if (lib == null) {
                throw new UnsatisfiedLinkError(com.kenai.jffi.Library.getLastError());
            }
            libs.add(lib);
        }
        return Collections.unmodifiableList(libs);
    }
}

