/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MozillaDelegate {
    Browser browser;
    Listener listener;
    boolean hasFocus;

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(long l) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(l);
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return new String(byArray).toCharArray();
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        if (bl) {
            string2 = String.valueOf(string2) + "\u0000";
        }
        return string2.getBytes();
    }

    void addWindowSubclass() {
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSMenu nSMenu = nSApplication.mainMenu();
        nSMenu.retain();
        int n = nsIBaseWindow2.Create();
        nSApplication.setMainMenu(nSMenu);
        nSMenu.release();
        return n;
    }

    long getHandle() {
        return this.browser.view.id;
    }

    String getJSLibraryName() {
        return "libmozjs.dylib";
    }

    String getLibraryName() {
        return "libxpcom.dylib";
    }

    String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        ((Mozilla)this.browser.webBrowser).Activate();
        this.browser.setFocus();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
    }

    boolean needsSpinup() {
        return false;
    }

    void onDispose(long l) {
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        this.browser = null;
    }

    void removeWindowSubclass() {
    }

    void setSize(long l, int n, int n2) {
    }
}

