/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.BootSector;
import de.waldheinz.fs.fat.FatType;
import java.io.IOException;

final class Fat16BootSector
extends BootSector {
    public static final int DEFAULT_ROOT_DIR_ENTRY_COUNT = 512;
    public static final String DEFAULT_VOLUME_LABEL = "NO NAME";
    public static final int MAX_FAT12_CLUSTERS = 4084;
    public static final int MAX_FAT16_CLUSTERS = 65524;
    public static final int SECTORS_PER_FAT_OFFSET = 22;
    public static final int ROOT_DIR_ENTRIES_OFFSET = 17;
    public static final int VOLUME_LABEL_OFFSET = 43;
    public static final int FILE_SYSTEM_TYPE_OFFSET = 54;
    public static final int MAX_VOLUME_LABEL_LENGTH = 11;
    public static final int EXTENDED_BOOT_SIGNATURE_OFFSET = 38;

    public Fat16BootSector(BlockDevice device) {
        super(device);
    }

    public String getVolumeLabel() {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 11 && (c = (char)this.get8(43 + i)) != '\u0000'; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public void setVolumeLabel(String label) throws IllegalArgumentException {
        if (label.length() > 11) {
            throw new IllegalArgumentException("volume label too long");
        }
        for (int i = 0; i < 11; ++i) {
            this.set8(43 + i, i < label.length() ? (int)label.charAt(i) : 0);
        }
    }

    @Override
    public long getSectorsPerFat() {
        return this.get16(22);
    }

    @Override
    public void setSectorsPerFat(long v) {
        if (v == this.getSectorsPerFat()) {
            return;
        }
        if (v > 32767L) {
            throw new IllegalArgumentException("too many sectors for a FAT12/16");
        }
        this.set16(22, (int)v);
    }

    @Override
    public FatType getFatType() {
        long rootDirSectors = (this.getRootDirEntryCount() * 32 + (this.getBytesPerSector() - 1)) / this.getBytesPerSector();
        long dataSectors = this.getSectorCount() - ((long)this.getNrReservedSectors() + (long)this.getNrFats() * this.getSectorsPerFat() + rootDirSectors);
        long clusterCount = dataSectors / (long)this.getSectorsPerCluster();
        if (clusterCount > 65524L) {
            throw new IllegalStateException("too many clusters for FAT12/16: " + clusterCount);
        }
        return clusterCount > 4084L ? FatType.FAT16 : FatType.FAT12;
    }

    @Override
    public void setSectorCount(long count) {
        if (count > 65535L) {
            this.setNrLogicalSectors(0);
            this.setNrTotalSectors(count);
        } else {
            this.setNrLogicalSectors((int)count);
            this.setNrTotalSectors(count);
        }
    }

    @Override
    public long getSectorCount() {
        if (this.getNrLogicalSectors() == 0) {
            return this.getNrTotalSectors();
        }
        return this.getNrLogicalSectors();
    }

    @Override
    public int getRootDirEntryCount() {
        return this.get16(17);
    }

    public void setRootDirEntryCount(int v) throws IllegalArgumentException {
        if (v < 0) {
            throw new IllegalArgumentException();
        }
        if (v == this.getRootDirEntryCount()) {
            return;
        }
        this.set16(17, v);
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.setRootDirEntryCount(512);
        this.setVolumeLabel(DEFAULT_VOLUME_LABEL);
    }

    @Override
    public int getFileSystemTypeLabelOffset() {
        return 54;
    }

    @Override
    public int getExtendedBootSignatureOffset() {
        return 38;
    }
}

