/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.MainFrame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class ImageTransferHandler
extends TransferHandler {
    private final MainFrame mainFrame;

    ImageTransferHandler(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        try {
            for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
                if (flavor.isFlavorJavaFileListType()) {
                    Object data = transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File file = (File)((List)data).get(0);
                    this.mainFrame.open(file).execute();
                    return true;
                }
                if (!flavor.isFlavorTextType() || flavor.getRepresentationClass() != String.class) continue;
                String mime = flavor.getMimeType();
                DataFlavor flave = new DataFlavor(mime);
                Object data = transferable.getTransferData(flave);
                String path = ImageTransferHandler.convertPath(data.toString());
                this.mainFrame.open(new File(path)).execute();
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String convertPath(String path) {
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        }
        if (path.indexOf(10) != -1) {
            path = path.substring(0, path.indexOf(10));
        }
        if (path.indexOf(13) != -1) {
            path = path.substring(0, path.indexOf(13));
        }
        return path;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean isCopySupported;
        boolean bl = isCopySupported = (1 & support.getSourceDropActions()) == 1;
        if (!isCopySupported) {
            return false;
        }
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType() && !flavor.isFlavorTextType()) continue;
            support.setDropAction(1);
            return true;
        }
        return false;
    }
}

