/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.ElementList;

public final class ByteList
extends ElementList {
    private byte[] list;

    public ByteList() {
        this(-1L);
    }

    public ByteList(long capacity) {
        this.list = new byte[Array.initialCapacity(capacity)];
    }

    public ByteList add(int element) {
        int s = this.size;
        byte[] lst = this.list;
        if (s == lst.length) {
            this.list = lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = (byte)element;
        this.size = s + 1;
        return this;
    }

    public ByteList add(byte[] elements) {
        return this.add(elements, 0, elements.length);
    }

    public ByteList add(byte[] elements, int start, int end) {
        int l = end - start;
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newCapacity(this.size + l));
        }
        Array.copy(elements, start, l, this.list, this.size);
        this.size += l;
        return this;
    }

    public byte get(int index) {
        return this.list[index];
    }

    public byte[] toArray() {
        int s = this.size;
        return s == 0 ? Token.EMPTY : Arrays.copyOf(this.list, s);
    }

    public byte[] next() {
        int s = this.size;
        if (s == 0) {
            return Token.EMPTY;
        }
        this.size = 0;
        return Arrays.copyOf(this.list, s);
    }

    public byte[] finish() {
        byte[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == 0 ? Token.EMPTY : (s == lst.length ? lst : Arrays.copyOf(lst, s));
    }

    public ByteList reverse() {
        byte[] lst = this.list;
        int l = 0;
        for (int r = this.size - 1; l < r; ++l, --r) {
            byte tmp = lst[l];
            lst[l] = lst[r];
            lst[r] = tmp;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ByteList)) return false;
        ByteList l = (ByteList)obj;
        if (!Arrays.equals(this.list, 0, this.size, l.list, 0, l.size)) return false;
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Token.string(this.list, 0, this.size);
    }
}

