/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.http.MediaType;

public final class BaseXImages {
    private static final HashMap<String, Image> IMAGES = new HashMap();
    private static final HashMap<String, ImageIcon> ICONS = new HashMap();
    private static final HashMap<String, Icon> FILES = new HashMap();
    private static final FileSystemView FS = FileSystemView.getFileSystemView();
    private static final Icon DB_XML = BaseXImages.icon("db_xml");
    private static final Icon DB_BIN = BaseXImages.icon("db_bin");
    private static final Icon DB_VAL = BaseXImages.icon("db_val");
    private static final Icon DIR_CLOSED = BaseXImages.icon("dir_closed");
    private static final Icon DIR_OPENED = BaseXImages.icon("dir_opened");
    private static final Icon FILE_TEXT = BaseXImages.icon("file_text");
    private static final Icon FILE_XML = BaseXImages.icon("file_xml");
    private static final Icon FILE_XQUERY = BaseXImages.icon("file_xquery");

    private BaseXImages() {
    }

    public static Image get(String name) {
        if (!IMAGES.containsKey(name)) {
            int n = 5;
            Image[] images = new Image[5];
            for (int i = 0; i < 5; ++i) {
                String path = "/img/" + name + "-" + i + ".png";
                URL url = BaseXImages.class.getResource(path);
                if (url == null) {
                    throw Util.notExpected("Image missing: " + path, new Object[0]);
                }
                try {
                    images[i] = ImageIO.read(url);
                    continue;
                }
                catch (IOException ex) {
                    throw Util.notExpected(ex, new Object[0]);
                }
            }
            IMAGES.put(name, new BaseMultiResolutionImage(images));
        }
        return IMAGES.get(name);
    }

    public static ImageIcon icon(String name) {
        return ICONS.computeIfAbsent(name, n -> new ImageIcon(BaseXImages.get(n)));
    }

    public static Icon dir(boolean opened) {
        return opened ? DIR_OPENED : DIR_CLOSED;
    }

    public static Icon resource(ResourceType type) {
        return type == ResourceType.XML ? DB_XML : (type == ResourceType.BINARY ? DB_BIN : DB_VAL);
    }

    public static Icon file(IOFile file) {
        if (file == null) {
            return FILE_TEXT;
        }
        String path = file.path();
        MediaType type = MediaType.get(path);
        if (type.isXml()) {
            return FILE_XML;
        }
        if (type.isXQuery()) {
            return FILE_XQUERY;
        }
        if (Prop.WIN) {
            int p = path.lastIndexOf(path, 46);
            String suffix = p == -1 ? null : path.substring(p + 1);
            Icon icon = null;
            if (suffix != null) {
                icon = FILES.get(suffix);
            }
            if (icon == null) {
                icon = FS.getSystemIcon(file.file());
                if (suffix != null) {
                    FILES.put(suffix, icon);
                }
            }
            return icon;
        }
        return FILE_TEXT;
    }
}

