/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Otherwise
extends Arr {
    public Otherwise(InputInfo info, Expr ... exprs) {
        super(info, Types.ITEM_ZM, exprs);
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        int el = this.exprs.length - 1;
        for (int e = 0; e < el; ++e) {
            Item item;
            final Iter input = this.exprs[e].iter(qc);
            long size = input.size();
            if (size > 0L) {
                return input;
            }
            if (size >= 0L || (item = qc.next(input)) == null) continue;
            return new Iter(){
                boolean next;

                @Override
                public Item next() throws QueryException {
                    if (this.next) {
                        return qc.next(input);
                    }
                    this.next = true;
                    return item;
                }
            };
        }
        return this.exprs[el].iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        for (Expr expr : this.exprs) {
            Value value = expr.value(qc);
            if (value.isEmpty()) continue;
            return value;
        }
        return Empty.VALUE;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = cc.compileOrError(this.exprs[e], e == 0);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        this.flatten(cc);
        this.removeEmpty(cc);
        int el = this.exprs.length - 1;
        int e = -1;
        while (++e < el && !this.exprs[e].seqType().oneOrMore()) {
        }
        if (e < el) {
            this.exprs = Arrays.copyOf(this.exprs, el);
        }
        if ((el = this.exprs.length) == 0) {
            return cc.emptySeq(this);
        }
        if (el == 1) {
            return this.exprs[0];
        }
        Occ occ = null;
        for (Expr expr : this.exprs) {
            Occ o = expr.seqType().occ;
            occ = occ == null ? o : occ.union(o);
        }
        SeqType st = SeqType.union(this.exprs, false);
        this.exprType.assign(st != null ? st.type : AtomType.ITEM, occ).data(this.exprs);
        return this;
    }

    @Override
    public boolean vacuous() {
        return ((Checks<Expr>)Expr::vacuous).all((Expr[])this.exprs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Otherwise && super.equals(obj);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Otherwise(this.info, Otherwise.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public void toString(QueryString qs) {
        qs.tokens(this.exprs, " otherwise ", true);
    }
}

