/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xquery.XQDataFactory;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import net.xqj.core.Constants;
import net.xqj.core.Factory;
import net.xqj.core.SAX2CharArray;
import net.xqj.core.TextContainer;
import net.xqj.core.XQDynamicExpression;
import net.xqj.core.XQueryCorrectorWriter;
import net.xqj.core.XQuerySerializationWriter;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.stax.XMLStreamReaderToContentHandler;
import net.xqj.core.toolkit.ReoFactory;
import net.xqj.core.toolkit.ReoToolkit;
import net.xqj.core.util.Base64Coder;
import net.xqj.core.util.EmptyPrintWriter;
import net.xqj.core.util.HexCoder;
import net.xqj.core.util.MessageFormatter;
import net.xqj.core.util.PropertiesHandler;
import net.xqj.core.util.xmlcalendar.DurationImpl;
import net.xqj.core.util.xmlcalendar.XMLGregorianCalendarImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XQToolkit {
    private static DocumentBuilderFactory xmlDocumentBuilderFactory = null;
    private static TransformerFactory xmlTransformerFactory = null;
    private static DocumentBuilder reusableDocumentBuilder = null;
    private static Document documentObject = null;
    private static XMLInputFactory xmlInputFactory = null;
    private static Properties defaultTransformerProperties = new Properties();
    public static final int[] BASETYPE_MAP = new int[]{33, 32, 7, 40, 35, 34, 38, 5, 9, 39, 36, 37, 25, 23, 26, 50, 51, 27, 16, 19, 42, 45, 10, 17, 13, 48, 49, 44, 8, 18, 22, 29, 20, 47, 41, 28, 24, 14, 43, 31, 11, 21, 15, 30, 12, 46};
    public static final String[] ITEMKIND_LOOKUP = new String[]{"processing-instruction", "namespace", "document-node", "comment", "element", "item", "node", "text"};
    public static final int[] ITEMKIND_MAP = new int[]{10, -1, 5, 3, 7, 8, 9, 11};
    public static String[] XQJ_BASETYPE_MAP;
    public static String[] XQJ_ITEMKIND_MAP;
    private static MessageFormatter defaultMessageFormatter;
    private static final HashMap XS_LOCAL_LUT;
    private static final int[] ATOMIC_PARENT_LUT;
    private static final int[] KIND_PARENT_LUT;
    private static final int[] RESTRICTION_LUT;
    public static final char[] LINE_BREAK;
    private static final Pattern PI_TARGET_PATTERN;

    static {
        String[] stringArray = new String[52];
        stringArray[1] = "xs:untyped";
        stringArray[2] = "xs:anyType";
        stringArray[3] = "xs:anySimpleType";
        stringArray[4] = "xs:anyAtomicType";
        stringArray[5] = "xs:untypedAtomic";
        stringArray[6] = "xs:dayTimeDuration";
        stringArray[7] = "xs:yearMonthDuration";
        stringArray[8] = "xs:anyURI";
        stringArray[9] = "xs:base64Binary";
        stringArray[10] = "xs:boolean";
        stringArray[11] = "xs:date";
        stringArray[12] = "xs:int";
        stringArray[13] = "xs:integer";
        stringArray[14] = "xs:short";
        stringArray[15] = "xs:long";
        stringArray[16] = "xs:dateTime";
        stringArray[17] = "xs:decimal";
        stringArray[18] = "xs:double";
        stringArray[19] = "xs:duration";
        stringArray[20] = "xs:float";
        stringArray[21] = "xs:gDay";
        stringArray[22] = "xs:gMonth";
        stringArray[23] = "xs:gMonthDay";
        stringArray[24] = "xs:gYear";
        stringArray[25] = "xs:gYearMonth";
        stringArray[26] = "xs:hexBinary";
        stringArray[27] = "xs:NOTATION";
        stringArray[28] = "xs:QName";
        stringArray[29] = "xs:string";
        stringArray[30] = "xs:time";
        stringArray[31] = "xs:byte";
        stringArray[32] = "xs:nonPositiveInteger";
        stringArray[33] = "xs:nonNegativeInteger";
        stringArray[34] = "xs:negativeInteger";
        stringArray[35] = "xs:positiveInteger";
        stringArray[36] = "xs:unsignedLong";
        stringArray[37] = "xs:unsignedInt";
        stringArray[38] = "xs:unsignedShort";
        stringArray[39] = "xs:unsignedByte";
        stringArray[40] = "xs:normalizedString";
        stringArray[41] = "xs:token";
        stringArray[42] = "xs:language";
        stringArray[43] = "xs:Name";
        stringArray[44] = "xs:NCName";
        stringArray[45] = "xs:NMToken";
        stringArray[46] = "xs:ID";
        stringArray[47] = "xs:IDREF";
        stringArray[48] = "xs:ENTITY";
        stringArray[49] = "xs:IDREFS";
        stringArray[50] = "xs:ENTITIES";
        stringArray[51] = "xs:NMTOKENS";
        XQJ_BASETYPE_MAP = stringArray;
        String[] stringArray2 = new String[14];
        stringArray2[1] = "xs:anyAtomicType";
        stringArray2[2] = "attribute()";
        stringArray2[3] = "comment()";
        stringArray2[4] = "document-node()";
        stringArray2[5] = "document-node(element(*))";
        stringArray2[6] = "document-node(schema-element(*))";
        stringArray2[7] = "element()";
        stringArray2[8] = "item()";
        stringArray2[9] = "node()";
        stringArray2[10] = "processing-instruction()";
        stringArray2[11] = "text()";
        stringArray2[12] = "schema-element(*)";
        stringArray2[13] = "schema-attribute(*)";
        XQJ_ITEMKIND_MAP = stringArray2;
        defaultMessageFormatter = null;
        XS_LOCAL_LUT = new HashMap();
        ATOMIC_PARENT_LUT = XQToolkit.buildAtomicParentLUT();
        KIND_PARENT_LUT = XQToolkit.buildItemKindParentLUT();
        RESTRICTION_LUT = XQToolkit.buildRestrictionLUT();
        LINE_BREAK = System.getProperty("line.separator").toCharArray();
        XQToolkit.buildNewTransformerFactory();
        XQToolkit.buildDefaultMessageFormatter();
        XQToolkit.buildXSLocalLUT();
        PI_TARGET_PATTERN = Pattern.compile("<\\?\\s+([^ ]+).*");
    }

    private static final int[] buildRestrictionLUT() {
        int[] RESTRICTION_LUT = new int[52];
        boolean b1 = true;
        int b2 = 2;
        int b3 = 4;
        int b4 = 8;
        int b5 = 16;
        int b6 = 32;
        int b7 = 64;
        int b8 = 128;
        int b9 = 256;
        int b10 = 512;
        int b11 = 1024;
        int b12 = 2048;
        int b13 = 4096;
        int b14 = 8192;
        int b15 = 16384;
        int b16 = 32768;
        int b17 = 65536;
        int b18 = 131072;
        int b19 = 262144;
        int b20 = 524288;
        int b21 = 0x100000;
        int b22 = 0x200000;
        int b23 = 0x400000;
        RESTRICTION_LUT[2] = 1;
        RESTRICTION_LUT[3] = 3;
        RESTRICTION_LUT[4] = 7;
        RESTRICTION_LUT[29] = 15;
        RESTRICTION_LUT[40] = 31;
        RESTRICTION_LUT[41] = 63;
        RESTRICTION_LUT[42] = 127;
        RESTRICTION_LUT[45] = 191;
        RESTRICTION_LUT[43] = 319;
        RESTRICTION_LUT[44] = 831;
        RESTRICTION_LUT[46] = 1855;
        RESTRICTION_LUT[47] = 2879;
        RESTRICTION_LUT[48] = 4927;
        RESTRICTION_LUT[17] = 23;
        RESTRICTION_LUT[13] = 55;
        RESTRICTION_LUT[32] = 119;
        RESTRICTION_LUT[34] = 247;
        RESTRICTION_LUT[15] = 183;
        RESTRICTION_LUT[12] = 439;
        RESTRICTION_LUT[14] = 695;
        RESTRICTION_LUT[31] = 1207;
        RESTRICTION_LUT[33] = 311;
        RESTRICTION_LUT[36] = 823;
        RESTRICTION_LUT[37] = 1847;
        RESTRICTION_LUT[38] = 3895;
        RESTRICTION_LUT[39] = 7991;
        RESTRICTION_LUT[35] = 1335;
        RESTRICTION_LUT[19] = 39;
        RESTRICTION_LUT[7] = 103;
        RESTRICTION_LUT[6] = 167;
        RESTRICTION_LUT[5] = 71;
        RESTRICTION_LUT[16] = 135;
        RESTRICTION_LUT[11] = 263;
        RESTRICTION_LUT[30] = 519;
        RESTRICTION_LUT[20] = 1031;
        RESTRICTION_LUT[18] = 2055;
        RESTRICTION_LUT[25] = 4103;
        RESTRICTION_LUT[24] = 8199;
        RESTRICTION_LUT[23] = 16391;
        RESTRICTION_LUT[21] = 32775;
        RESTRICTION_LUT[22] = 65543;
        RESTRICTION_LUT[10] = 131079;
        RESTRICTION_LUT[9] = 262151;
        RESTRICTION_LUT[26] = 524295;
        RESTRICTION_LUT[8] = 0x100007;
        RESTRICTION_LUT[28] = 0x200007;
        RESTRICTION_LUT[27] = 0x400007;
        RESTRICTION_LUT[50] = 11;
        RESTRICTION_LUT[49] = 19;
        RESTRICTION_LUT[51] = 35;
        RESTRICTION_LUT[1] = 5;
        return RESTRICTION_LUT;
    }

    private static final int[] buildItemKindParentLUT() {
        int[] KIND_PARENT_LUT = new int[14];
        KIND_PARENT_LUT[8] = -1;
        KIND_PARENT_LUT[1] = 8;
        KIND_PARENT_LUT[2] = 9;
        KIND_PARENT_LUT[3] = 9;
        KIND_PARENT_LUT[4] = 9;
        KIND_PARENT_LUT[7] = 9;
        KIND_PARENT_LUT[9] = 8;
        KIND_PARENT_LUT[10] = 9;
        KIND_PARENT_LUT[11] = 9;
        KIND_PARENT_LUT[5] = 4;
        KIND_PARENT_LUT[6] = 5;
        KIND_PARENT_LUT[12] = 7;
        KIND_PARENT_LUT[13] = 2;
        return KIND_PARENT_LUT;
    }

    private static final int[] buildAtomicParentLUT() {
        int[] ATOMIC_PARENT_LUT = new int[52];
        ATOMIC_PARENT_LUT[2] = -1;
        ATOMIC_PARENT_LUT[3] = 2;
        ATOMIC_PARENT_LUT[4] = 3;
        ATOMIC_PARENT_LUT[29] = 4;
        ATOMIC_PARENT_LUT[40] = 29;
        ATOMIC_PARENT_LUT[41] = 40;
        ATOMIC_PARENT_LUT[42] = 41;
        ATOMIC_PARENT_LUT[45] = 41;
        ATOMIC_PARENT_LUT[43] = 41;
        ATOMIC_PARENT_LUT[44] = 43;
        ATOMIC_PARENT_LUT[46] = 44;
        ATOMIC_PARENT_LUT[47] = 44;
        ATOMIC_PARENT_LUT[48] = 44;
        ATOMIC_PARENT_LUT[17] = 4;
        ATOMIC_PARENT_LUT[13] = 17;
        ATOMIC_PARENT_LUT[32] = 13;
        ATOMIC_PARENT_LUT[34] = 32;
        ATOMIC_PARENT_LUT[15] = 13;
        ATOMIC_PARENT_LUT[12] = 15;
        ATOMIC_PARENT_LUT[14] = 12;
        ATOMIC_PARENT_LUT[31] = 14;
        ATOMIC_PARENT_LUT[33] = 13;
        ATOMIC_PARENT_LUT[36] = 33;
        ATOMIC_PARENT_LUT[37] = 36;
        ATOMIC_PARENT_LUT[38] = 37;
        ATOMIC_PARENT_LUT[39] = 38;
        ATOMIC_PARENT_LUT[35] = 33;
        ATOMIC_PARENT_LUT[19] = 4;
        ATOMIC_PARENT_LUT[7] = 19;
        ATOMIC_PARENT_LUT[6] = 19;
        ATOMIC_PARENT_LUT[5] = 4;
        ATOMIC_PARENT_LUT[16] = 4;
        ATOMIC_PARENT_LUT[11] = 4;
        ATOMIC_PARENT_LUT[30] = 4;
        ATOMIC_PARENT_LUT[20] = 4;
        ATOMIC_PARENT_LUT[18] = 4;
        ATOMIC_PARENT_LUT[25] = 4;
        ATOMIC_PARENT_LUT[24] = 4;
        ATOMIC_PARENT_LUT[23] = 4;
        ATOMIC_PARENT_LUT[21] = 4;
        ATOMIC_PARENT_LUT[22] = 4;
        ATOMIC_PARENT_LUT[10] = 4;
        ATOMIC_PARENT_LUT[9] = 4;
        ATOMIC_PARENT_LUT[26] = 4;
        ATOMIC_PARENT_LUT[8] = 4;
        ATOMIC_PARENT_LUT[28] = 4;
        ATOMIC_PARENT_LUT[27] = 4;
        ATOMIC_PARENT_LUT[50] = 3;
        ATOMIC_PARENT_LUT[49] = 3;
        ATOMIC_PARENT_LUT[51] = 3;
        ATOMIC_PARENT_LUT[1] = 2;
        return ATOMIC_PARENT_LUT;
    }

    public static final void buildXSLocalLUT() {
        int i = 1;
        while (i < XQDynamicExpression.XQJ_BASETYPE_MAP.length) {
            XS_LOCAL_LUT.put(XQDynamicExpression.XQJ_BASETYPE_MAP[i].split(":")[1], i);
            ++i;
        }
    }

    private static final void buildNewDocumentBuilderFactory() throws FactoryConfigurationError {
        xmlDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    private static final void buildNewTransformerFactory() throws TransformerFactoryConfigurationError {
        if (xmlTransformerFactory != null) {
            return;
        }
        xmlTransformerFactory = TransformerFactory.newInstance();
    }

    public static final DocumentBuilder getDocumentBuilder() {
        XQToolkit.buildNewDocumentBuilderFactory();
        try {
            DocumentBuilder builder = xmlDocumentBuilderFactory.newDocumentBuilder();
            documentObject = builder.newDocument();
            return builder;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to create Document Builder.");
        }
    }

    public static final Transformer getTransformer() {
        XQToolkit.buildNewTransformerFactory();
        try {
            Transformer transformer = xmlTransformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Could not create Transformer.");
        }
    }

    public static final boolean getBooleanFromString(String string, boolean defaultValue) {
        String[] TRUE = new String[]{"true", "yes", "on", "1"};
        String[] FALSE = new String[]{"false", "no", "off", "0"};
        int i = 0;
        while (i < 4) {
            if (TRUE[i].equalsIgnoreCase(string)) {
                return true;
            }
            if (FALSE[i].equalsIgnoreCase(string)) {
                return false;
            }
            ++i;
        }
        return defaultValue;
    }

    public static final QName getQName(Attr attribute) {
        return XQToolkit.getQName(attribute.getName(), attribute.getNamespaceURI());
    }

    public static final QName getQName(String name, String namespace) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            return XQToolkit.getQName(name.substring(0, colon), name.substring(colon + 1, name.length()), namespace);
        }
        return XQToolkit.getQName(null, name, namespace);
    }

    public static final QName getQName(String prefix, String localPart, String namespace) {
        return localPart == null ? null : new QName(namespace == null ? "" : namespace, localPart, prefix == null ? "" : prefix);
    }

    public static final boolean isSpecificXQSequenceType(XQSequenceType xqst) throws XQException {
        return xqst.getItemType().getItemKind() != 8 || xqst.getItemOccurrence() != 3;
    }

    public static final boolean isGeneralNodeType(int xqItemKind) {
        return xqItemKind == 2 || xqItemKind == 3 || xqItemKind == 4 || xqItemKind == 5 || xqItemKind == 6 || xqItemKind == 7 || xqItemKind == 9 || xqItemKind == 10 || xqItemKind == 13 || xqItemKind == 12 || xqItemKind == 11;
    }

    public static final boolean supportsBaseType(int itemKind) {
        return itemKind == 5 || itemKind == 6 || itemKind == 7 || itemKind == 12 || itemKind == 2 || itemKind == 13 || itemKind == 1;
    }

    public static final boolean isDocumentNode(int itemKind) {
        return itemKind == 4 || itemKind == 5 || itemKind == 6;
    }

    public static final boolean isInstanceOf(XQItemType ancestor, XQItemType descendant) throws XQException {
        int descendantBaseType;
        int ancestorBaseType;
        boolean test2;
        int descendantItemKind;
        if (descendant == null) {
            throw new XQExceptionImpl("descdendent XQItemType argument is null.", "XQJTO004");
        }
        int ancestorItemKind = ancestor.getItemKind();
        boolean test1 = XQToolkit.isItemKindDerivedFromRestriction(ancestorItemKind, descendantItemKind = descendant.getItemKind());
        if (!test1) {
            return false;
        }
        return !XQToolkit.supportsBaseType(ancestorItemKind) || !XQToolkit.supportsBaseType(descendantItemKind) || (test2 = XQToolkit.isDerivedFromRestriction(ancestorBaseType = ancestor.getBaseType(), descendantBaseType = descendant.getBaseType()));
    }

    public static final void validateXQSequenceType(XQSequence sequence, XQSequenceType sequenceType) throws XQException {
        if (!sequence.isScrollable()) {
            return;
        }
        int count = sequence.count();
        if (sequenceType.getItemOccurrence() == 5 && count > 0) {
            throw new XQException("XQSequence is not empty, yet declared XQSequenceType '" + String.valueOf(sequenceType) + "' expects an empty sequence.");
        }
        if (sequenceType.getItemOccurrence() == 2 && count != 1) {
            throw new XQException("XQSequence is not a singleton, yet declared XQSequenceType '" + String.valueOf(sequenceType) + "' expects a sequence with one item.");
        }
        if (sequenceType.getItemOccurrence() == 4 && count < 1) {
            throw new XQException("XQSequence is empty, yet declared XQSequenceType '" + String.valueOf(sequenceType) + "' expects a sequence with one or more items.");
        }
        if (sequenceType.getItemOccurrence() == 1 && count > 1) {
            throw new XQException("XQSequence contains " + count + " items, yet declared XQSequenceType '" + String.valueOf(sequenceType) + "' expects an empty or singleton sequence.");
        }
        int originalPosition = sequence.getPosition();
        if (sequence.isOnItem()) {
            sequence.previous();
        }
        while (sequence.next()) {
            XQItem item = sequence.getItem();
            if (XQToolkit.isInstanceOf(sequenceType.getItemType(), item.getItemType())) continue;
            throw new XQException(String.valueOf(item.getItemType()) + " is not an instance of " + String.valueOf(sequenceType.getItemType()));
        }
        sequence.absolute(originalPosition);
    }

    public static final boolean isDerivedFromRestriction(XQItemType ancestor, XQItemType descendant) throws XQException {
        return XQToolkit.isDerivedFromRestriction(ancestor.getBaseType(), descendant.getBaseType());
    }

    public static final boolean isDerivedFromRestriction(int ancestorBaseType, int descendantBaseType) {
        if (ancestorBaseType == descendantBaseType) {
            return true;
        }
        int parent = XQToolkit.getParent(descendantBaseType);
        while (parent != -1) {
            if (parent == ancestorBaseType) {
                return true;
            }
            parent = XQToolkit.getParent(parent);
        }
        return false;
    }

    public static final int getParent(int baseType) {
        return ATOMIC_PARENT_LUT[baseType];
    }

    public static final boolean isItemKindDerivedFromRestriction(int ancestorItemKind, int descendantItemKind) {
        if (ancestorItemKind == descendantItemKind) {
            return true;
        }
        int parent = XQToolkit.getItemKindParent(descendantItemKind);
        while (parent != -1) {
            if (parent == ancestorItemKind) {
                return true;
            }
            parent = XQToolkit.getItemKindParent(parent);
        }
        return false;
    }

    public static final int getItemKindParent(int itemKind) {
        return KIND_PARENT_LUT[itemKind];
    }

    public static final int getCommonAncestor(int baseType1, int baseType2) {
        int parent;
        if (RESTRICTION_LUT[baseType1] > RESTRICTION_LUT[baseType2]) {
            parent = XQToolkit.getParent(baseType1);
            while (!XQToolkit.isDerivedFromRestriction(parent, baseType2)) {
                parent = XQToolkit.getParent(parent);
            }
        } else {
            parent = XQToolkit.getParent(baseType2);
            while (!XQToolkit.isDerivedFromRestriction(parent, baseType1)) {
                parent = XQToolkit.getParent(parent);
            }
        }
        return parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XQSequenceType createSequenceType(XQDataFactory dataFactory, XQSequence sequence) throws XQException {
        if (!sequence.isScrollable()) {
            throw new XQExceptionImpl("Tried to examine an XQSequence to identify its datatype and occurrence but it is NOT a scrollable sequence.", "XQJTO005");
        }
        if (sequence.isClosed()) {
            throw new XQExceptionImpl("Tried to examine an XQSequence to identify its datatyoe and occurrence but the sequence was closed.", "XQJTO006");
        }
        int originalPosition = sequence.getPosition();
        sequence.beforeFirst();
        int rootItemKind = 0;
        int rootBaseType = 0;
        int count = 0;
        if (!sequence.next()) return dataFactory.createSequenceType(dataFactory.createItemType(), 5);
        XQItemType xqit = sequence.getItemType();
        rootItemKind = xqit.getItemKind();
        rootBaseType = xqit.getBaseType();
        ++count;
        while (sequence.next()) {
            ++count;
            xqit = sequence.getItemType();
            int thisItemKind = xqit.getItemKind();
            if (rootItemKind != 8 && thisItemKind != rootItemKind) {
                rootItemKind = XQToolkit.isGeneralNodeType(thisItemKind) && XQToolkit.isGeneralNodeType(rootItemKind) && rootItemKind != thisItemKind ? 9 : (XQToolkit.isGeneralNodeType(rootItemKind) && thisItemKind == 1 ? 8 : (rootItemKind == 1 && XQToolkit.isGeneralNodeType(thisItemKind) ? 8 : thisItemKind));
            }
            if (XQToolkit.isDerivedFromRestriction(rootBaseType, xqit.getBaseType())) continue;
            rootBaseType = XQToolkit.isDerivedFromRestriction(xqit.getBaseType(), rootBaseType) ? xqit.getBaseType() : XQToolkit.getCommonAncestor(xqit.getBaseType(), rootBaseType);
        }
        sequence.absolute(originalPosition);
        int occurrence = count == 0 ? 5 : (count == 1 ? 2 : 4);
        switch (rootItemKind) {
            case 1: {
                return dataFactory.createSequenceType(dataFactory.createAtomicType(rootBaseType), occurrence);
            }
            case 2: {
                return dataFactory.createSequenceType(dataFactory.createAttributeType(null, rootBaseType), occurrence);
            }
            case 3: {
                return dataFactory.createSequenceType(dataFactory.createCommentType(), occurrence);
            }
            case 4: {
                return dataFactory.createSequenceType(dataFactory.createDocumentType(), occurrence);
            }
            case 5: {
                return dataFactory.createSequenceType(dataFactory.createDocumentElementType(dataFactory.createElementType(null, rootBaseType)), occurrence);
            }
            case 6: {
                return dataFactory.createSequenceType(dataFactory.createDocumentElementType(dataFactory.createElementType(null, rootBaseType)), occurrence);
            }
            case 7: {
                return dataFactory.createSequenceType(dataFactory.createElementType(null, rootBaseType), occurrence);
            }
            case 8: {
                return dataFactory.createSequenceType(dataFactory.createItemType(), occurrence);
            }
            case 9: {
                return dataFactory.createSequenceType(dataFactory.createNodeType(), occurrence);
            }
            case 10: {
                return dataFactory.createSequenceType(dataFactory.createProcessingInstructionType(null), occurrence);
            }
            case 13: {
                return dataFactory.createSequenceType(dataFactory.createAttributeType(null, rootBaseType), occurrence);
            }
            case 12: {
                return dataFactory.createSequenceType(dataFactory.createElementType(null, rootBaseType), occurrence);
            }
            case 11: {
                return dataFactory.createSequenceType(dataFactory.createTextType(), occurrence);
            }
        }
        throw new XQException("Unable to build XQSequenceType from SCROLLABLE XQSequence.");
    }

    public static final String formatMessage(int key, Object ... arguments) {
        return defaultMessageFormatter.formatMessage(key, arguments);
    }

    public static final String formatMessage(int key) throws XQException {
        return XQToolkit.formatMessage(key, new Object[]{null});
    }

    public static final void nullValueTest(Object object, String name, String errorCode) throws XQException {
        if (object == null) {
            throw new XQExceptionImpl(name + " must not be null.", errorCode);
        }
    }

    public static void writeAtomicXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        int xqjBaseType = value.getItemType().getBaseType();
        out.write(XQDynamicExpression.XQJ_BASETYPE_MAP[xqjBaseType]);
        out.write(40);
        out.write(XQToolkit.getInQuotes(value.getItemAsString(null)));
        out.write(41);
    }

    public static void writeCommentXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        Comment comment = (Comment)value.getObject();
        out.write("comment { ");
        out.write(XQToolkit.getInQuotes(comment.getData()));
        out.write(" }");
    }

    public static void writeElementXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        XQueryCorrectorWriter xqWriter = Factory.newXQueryCorrector(out);
        value.writeItem((Writer)xqWriter, null);
    }

    public static void writeAttributeXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        Attr attr = (Attr)value.getObject();
        out.write("attribute ");
        out.write(attr.getName());
        out.write(" { ");
        out.write(XQToolkit.getInQuotes(attr.getValue()));
        out.write(" }");
    }

    public static void writeNodeXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        Node node = value.getNode();
        switch (node.getNodeType()) {
            case 2: {
                XQToolkit.writeAttributeXQueryValue(out, value);
                break;
            }
            case 4: {
                throw new XQException("Writing a CDATA node to an XQuery expression is not supported.");
            }
            case 8: {
                XQToolkit.writeCommentXQueryValue(out, value);
                break;
            }
            case 11: {
                XQToolkit.writeDocumentXQueryValue(out, value);
                break;
            }
            case 9: {
                XQToolkit.writeDocumentXQueryValue(out, value);
                break;
            }
            case 1: {
                XQToolkit.writeElementXQueryValue(out, value);
                break;
            }
            case 7: {
                XQToolkit.writeProcessingInstructionXQueryValue(out, value);
                break;
            }
            case 3: {
                XQToolkit.writeTextXQueryValue(out, value);
            }
        }
    }

    public static void writeProcessingInstructionXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        ProcessingInstruction pi = (ProcessingInstruction)value.getObject();
        out.write("processing-instruction ");
        out.write(pi.getTarget());
        out.write(" { ");
        out.write(XQToolkit.getInQuotes(pi.getData()));
        out.write(" }");
    }

    public static void writeTextXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        Text text = (Text)value.getObject();
        out.write("text { ");
        out.write(XQToolkit.getInQuotes(text.getData()));
        out.write(" }");
    }

    public static void writeItemXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        int baseType = value.getItemType().getBaseType();
        if (baseType >= 6 && baseType <= 51) {
            XQToolkit.writeAtomicXQueryValue(out, value);
            return;
        }
        Object unknownObject = value.getObject();
        if (unknownObject instanceof Node) {
            XQToolkit.writeNodeXQueryValue(out, value);
        } else if (unknownObject instanceof String) {
            out.write(XQToolkit.getInQuotes(value.getItemAsString(null)));
        } else if (unknownObject instanceof Float || unknownObject instanceof Double || unknownObject instanceof BigDecimal) {
            out.write("xs:decimal(" + XQToolkit.getInQuotes(unknownObject.toString()) + ")");
        } else if (unknownObject instanceof Number) {
            out.write("xs:integer(" + XQToolkit.getInQuotes(unknownObject.toString()) + ")");
        } else if (unknownObject instanceof Duration) {
            out.write("xs:duration(" + XQToolkit.getInQuotes(unknownObject.toString()) + ")");
        } else if (unknownObject instanceof XMLGregorianCalendar) {
            out.write("xs:dateTime(" + XQToolkit.getInQuotes(unknownObject.toString()) + ")");
        } else {
            throw new XQException("Unsupported operation.");
        }
    }

    public static void writeDocumentXQueryValue(Writer out, XQItem value) throws XQException, IOException {
        out.write("document { (");
        XQueryCorrectorWriter xqWriter = Factory.newXQueryCorrector(out);
        value.writeItem((Writer)xqWriter, null);
        out.write(") }");
    }

    public static final byte[] getByteArrayFromBase64(String base64String) {
        return Base64Coder.decode(base64String.toCharArray());
    }

    public static final String getBase64StringFromByteArray(byte[] binaryData) {
        return new String(Base64Coder.encode(binaryData));
    }

    public static void bridgeFromReaderToUTF8OutputStream(Reader reader, OutputStream utf8out) throws IOException, XQException {
        int read;
        char[] buffer = new char[5120];
        Writer writer = Factory.newUTF8Writer(utf8out);
        while ((read = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, read);
        }
    }

    public static final byte[] getUTF8ByteArray(String string) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Writer writer = Factory.newUTF8Writer(bos);
            writer.write(string);
            writer.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static final byte[] getUTF8ByteArray(char[] c) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Writer writer = Factory.newUTF8Writer(bos);
            writer.write(c);
            writer.flush();
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static final InputStream getUTF8InputStreamFromString(String string) {
        byte[] b = XQToolkit.getUTF8ByteArray(string);
        return new ByteArrayInputStream(b);
    }

    public static final InputStream getUTF8InputStream(char[] c) {
        byte[] b = XQToolkit.getUTF8ByteArray(c);
        return new ByteArrayInputStream(b);
    }

    public static final String getUTF8String(byte[] bytes) throws XQException {
        return XQToolkit.getUTF8String(bytes, 0, bytes.length);
    }

    public static final String getUTF8String(byte[] bytes, int offset, int length) throws XQException {
        return new String(XQToolkit.getUTF8CharArray(bytes, offset, length));
    }

    public static final char[] getUTF8CharArray(byte[] bytes, int offset, int length) throws XQException {
        Reader reader = Factory.newUTF8Reader(new ByteArrayInputStream(bytes, offset, length));
        return XQToolkit.forceRead(reader);
    }

    public static final char[] getUTF8CharArray(byte[] bytes) throws XQException {
        return XQToolkit.getUTF8CharArray(bytes, 0, bytes.length);
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static char[] copyOfRange(char[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        char[] copy = new char[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static final byte[] hexStringToByteArray(String string) throws XQException {
        return HexCoder.decodeString(string);
    }

    public static final boolean javaBoolean(char[] value, int offset, int length) throws XQException {
        if (length == 4 && value[offset] == 't' && value[offset + 1] == 'r' && value[offset + 2] == 'u' && value[offset + 3] == 'e' || length == 1 && value[offset] == '1') {
            return true;
        }
        if (length == 5 && value[offset] == 'f' && value[offset + 1] == 'a' && value[offset + 2] == 'l' && value[offset + 3] == 's' && value[offset + 4] == 'e' || length == 1 && value[offset] == '0') {
            return false;
        }
        throw new XQExceptionImpl(new String(value, offset, length) + " is not a valid lexical representation of xs:boolean.", "XQJCE005");
    }

    public static final boolean parseXSDBooleanFromCharArray(char[] value) throws XQException {
        return XQToolkit.javaBoolean(value, 0, value.length);
    }

    public static final Boolean parseXSDBoolean(String lexicalString) throws XQException {
        if (lexicalString == null) {
            throw new XQExceptionImpl("String value is null.", "XQJCE006");
        }
        return XQToolkit.parseXSDBooleanFromCharArray(lexicalString.toCharArray()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static final Comment createCommentObject(String lexicalString) throws XQException {
        if (lexicalString == null) {
            throw new XQException("String value is null.");
        }
        int ltIndex = lexicalString.indexOf("<!--");
        int gtIndex = lexicalString.lastIndexOf("-->");
        if (ltIndex == -1 || gtIndex == -1 || gtIndex <= ltIndex) {
            throw new XQException(lexicalString + " is not a valid lexical representation of a comment.");
        }
        String stringData = lexicalString.substring(ltIndex + 4, gtIndex);
        XQToolkit.getDocumentBuilder();
        return documentObject.createComment(stringData);
    }

    public static final Transformer getTransformer(Properties properties) {
        Transformer customTransformer = XQToolkit.getTransformer();
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                String propertyValue = properties.getProperty(propertyName);
                if (propertyName.equals("method")) {
                    if (propertyValue.equals("{http://www.xqj.net/}xquery")) continue;
                    customTransformer.setOutputProperty("method", propertyValue);
                    continue;
                }
                if (propertyName.equals("encoding")) {
                    customTransformer.setOutputProperty("encoding", XQToolkit.parseEncodingForTransformer(propertyValue));
                    continue;
                }
                if (propertyName.equals("byte-order-mark")) continue;
                customTransformer.setOutputProperty(propertyName, propertyValue);
            }
        }
        return customTransformer;
    }

    public static final void transform(Source source, Result result) throws XQException {
        ReoToolkit.getInstance().transform(source, result);
    }

    public static final void transform(Source source, Result result, Properties properties) throws XQException {
        ReoToolkit.getInstance().transform(source, result, properties);
    }

    public static final String parseEncodingForTransformer(String encoding) {
        if (encoding == null) {
            return "UTF-8";
        }
        if (encoding.equalsIgnoreCase("utf-8") || encoding.equalsIgnoreCase("utf-16")) {
            return encoding;
        }
        if (encoding.startsWith("utf") || encoding.startsWith("UTF")) {
            return encoding.endsWith("16") ? "UTF-16" : "UTF-8";
        }
        return "UTF-8";
    }

    public static final Element createElementObject(String lexicalString) throws XQException {
        if (lexicalString == null) {
            throw new XQException("String value is null.");
        }
        StreamSource source = new StreamSource(new StringReader(lexicalString));
        DOMResult result = new DOMResult();
        XQToolkit.transform(source, result, null);
        return (Element)result.getNode().getFirstChild();
    }

    public static final Node createDocumentObject(String lexicalString) throws XQException {
        if (lexicalString == null) {
            throw new XQException("String value is null.");
        }
        StreamSource source = new StreamSource(new StringReader(lexicalString));
        DOMResult result = new DOMResult();
        XQToolkit.transform(source, result, null);
        Node abstractNode = result.getNode();
        return abstractNode;
    }

    public static final Attr createAttrObject(String lexicalString, String namespaceURI) throws XQException {
        int equalsIndex = lexicalString.indexOf(61);
        int firstQuote = lexicalString.indexOf(34);
        int secondQuote = lexicalString.indexOf(34, firstQuote + 1);
        String qualifiedName = lexicalString.substring(0, equalsIndex).trim();
        String value = lexicalString.substring(firstQuote + 1, secondQuote);
        XQToolkit.getDocumentBuilder();
        Attr attr = documentObject.createAttributeNS(namespaceURI, qualifiedName);
        attr.setValue(value);
        return attr;
    }

    public static final String parsePITarget(String lexicalString) throws XQException {
        Matcher matcher = PI_TARGET_PATTERN.matcher(lexicalString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new XQExceptionImpl("Could not createQueryProcessor Target / Name from Processing Instruction \"" + lexicalString + "\".", "XQJTO008");
    }

    public static final ProcessingInstruction createProcessingInstructionObject(String lexicalString) throws XQException {
        int start = lexicalString.indexOf("<?");
        int end = lexicalString.indexOf("?>");
        int startData = lexicalString.indexOf(32, start) + 1;
        if (start == -1 || end == -1 || end < start) {
            throw new XQException("Invalid Processing Instruction.");
        }
        String target = lexicalString.substring(start + 2, startData - 1);
        String data = lexicalString.substring(startData, end);
        XQToolkit.getDocumentBuilder();
        ProcessingInstruction pi = documentObject.createProcessingInstruction(target, data);
        return pi;
    }

    public static final Text createTextObject(String lexicalString) throws XQException {
        XQToolkit.getDocumentBuilder();
        Text textNode = documentObject.createTextNode(lexicalString);
        return textNode;
    }

    public static final Writer getOutputStreamForEncoding(OutputStream out, Properties properties) throws XQException {
        XQuerySerializationWriter writer = new XQuerySerializationWriter(out, properties);
        return writer;
    }

    public static final void writeByteOrderMark(OutputStream out, String encoding) throws XQException {
        try {
            if (encoding == null || encoding.equalsIgnoreCase("UTF-8") || encoding.equals("UTF8")) {
                out.write(new byte[]{-17, -69, -65});
            } else if (encoding.equalsIgnoreCase("UTF-16") || encoding.equalsIgnoreCase("UTF16") || encoding.equalsIgnoreCase("UTF-16BE")) {
                out.write(new byte[]{-2, -1});
            } else if (encoding.equalsIgnoreCase("UTF-16LE")) {
                out.write(new byte[]{-1, -2});
            } else if (encoding.equalsIgnoreCase("UTF-32") || encoding.equalsIgnoreCase("UTF32") || encoding.equalsIgnoreCase("UTF-32BE")) {
                byte[] byArray = new byte[4];
                byArray[2] = -2;
                byArray[3] = -1;
                out.write(byArray);
            } else if (encoding.equalsIgnoreCase("UTF-32LE")) {
                byte[] byArray = new byte[4];
                byArray[0] = -1;
                byArray[1] = -2;
                out.write(byArray);
            }
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJTO014", e);
        }
    }

    public static final String getProperty(Properties properties, String key, String defaultValue) {
        return properties == null ? defaultValue : properties.getProperty(key, defaultValue);
    }

    public static void writeXQItemAsXQuerySyntax(XQItem xqItem, Writer ow) throws XQException {
        try {
            switch (xqItem.getItemType().getItemKind()) {
                case 1: {
                    XQToolkit.writeAtomicXQueryValue(ow, xqItem);
                    break;
                }
                case 2: {
                    XQToolkit.writeAttributeXQueryValue(ow, xqItem);
                    break;
                }
                case 3: {
                    XQToolkit.writeCommentXQueryValue(ow, xqItem);
                    break;
                }
                case 4: {
                    XQToolkit.writeDocumentXQueryValue(ow, xqItem);
                    break;
                }
                case 5: {
                    XQToolkit.writeDocumentXQueryValue(ow, xqItem);
                    break;
                }
                case 6: {
                    XQToolkit.writeDocumentXQueryValue(ow, xqItem);
                    break;
                }
                case 7: {
                    XQToolkit.writeElementXQueryValue(ow, xqItem);
                    break;
                }
                case 8: {
                    XQToolkit.writeItemXQueryValue(ow, xqItem);
                    break;
                }
                case 9: {
                    XQToolkit.writeNodeXQueryValue(ow, xqItem);
                    break;
                }
                case 10: {
                    XQToolkit.writeProcessingInstructionXQueryValue(ow, xqItem);
                    break;
                }
                case 11: {
                    XQToolkit.writeTextXQueryValue(ow, xqItem);
                    break;
                }
                case 12: {
                    XQToolkit.writeElementXQueryValue(ow, xqItem);
                    break;
                }
                case 13: {
                    XQToolkit.writeAttributeXQueryValue(ow, xqItem);
                }
            }
            ow.flush();
        }
        catch (IOException e) {
            throw new XQException("IOException occured trying to write XQItem into result XQuery expression.");
        }
    }

    public static URI createURI(String uriString) {
        return URI.create(uriString);
    }

    public static final String getTokenizedString(String string) {
        StringTokenizer st = new StringTokenizer(string);
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            buffer.append(st.nextToken()).append(' ');
        }
        return buffer.substring(0, Math.max(0, buffer.length() - 1));
    }

    public static final int getBaseTypeFromQName(QName qname) throws XQException {
        if (!"http://www.w3.org/2001/XMLSchema".equals(qname.getNamespaceURI())) {
            throw new XQExceptionImpl("Can not map QName to XQJ BASETYPE. Namespace URI is " + qname.getNamespaceURI() + ", it should be http://www.w3.org/2001/XMLSchema.", "XQJTO011");
        }
        Integer integer = (Integer)XS_LOCAL_LUT.get(qname.getLocalPart());
        if (integer != null) {
            return integer;
        }
        throw new XQExceptionImpl("Unrecognised XML Schema 1.0 datatype \"" + qname.getLocalPart() + "\"", "XQJTO012");
    }

    public static final String getNormalizedString(String string) {
        return string.trim();
    }

    public static final String getXQItemTypeAsString(XQItemType itemType) throws XQException {
        if (itemType.getItemKind() == 1) {
            return XQJ_BASETYPE_MAP[itemType.getBaseType()];
        }
        return XQJ_ITEMKIND_MAP[itemType.getItemKind()];
    }

    public static final QName getXMLSchemaType(Duration duration) {
        if (duration.getYears() == 0 && duration.getMonths() == 0) {
            return DatatypeConstants.DURATION_DAYTIME;
        }
        if (duration.getYears() != 0 || duration.getMonths() != 0) {
            if (duration.getDays() != 0 || duration.getHours() != 0 || duration.getMinutes() != 0 || duration.getSeconds() != 0) {
                return DatatypeConstants.DURATION;
            }
            return DatatypeConstants.DURATION_YEARMONTH;
        }
        return DatatypeConstants.DURATION;
    }

    public static final QName getXMLSchemaType(XMLGregorianCalendar duration) {
        return duration.getXMLSchemaType();
    }

    public static final Object castToObjectBasedOnType(Object object, XQItemType xqItemType) throws XQException {
        if (object instanceof Number) {
            return XQToolkit.castToObjectBasedOnType((Number)object, xqItemType);
        }
        if (object instanceof String) {
            return XQToolkit.castToObjectBasedOnType((String)object, xqItemType);
        }
        if (object instanceof Boolean) {
            return XQToolkit.castToObjectBasedOnType((Boolean)object, xqItemType);
        }
        if (object instanceof Duration) {
            return XQToolkit.castToObjectBasedOnType((Duration)object, xqItemType);
        }
        if (object instanceof XMLGregorianCalendar) {
            return XQToolkit.castToObjectBasedOnType((XMLGregorianCalendar)object, xqItemType);
        }
        if (object instanceof QName) {
            return XQToolkit.castToObjectBasedOnType((QName)object, xqItemType);
        }
        if (object instanceof Node) {
            return XQToolkit.castToObjectBasedOnType((Node)object, xqItemType);
        }
        if (object instanceof byte[]) {
            return XQToolkit.castToObjectBasedOnType((byte[])object, xqItemType);
        }
        throw new XQException("Can not cast(" + String.valueOf(object) + "(" + object.getClass().getName() + "), " + String.valueOf(xqItemType) + "(" + xqItemType.getClass().getName() + "))");
    }

    public static final Object castToObjectBasedOnType(Node node, XQItemType xqItemType) throws XQException {
        switch (node.getNodeType()) {
            case 2: {
                if (xqItemType.getItemKind() == 2) {
                    return (Attr)node;
                }
                throw new XQException("Cannot cast DOM Attribute Object to " + String.valueOf(xqItemType));
            }
            case 8: {
                if (xqItemType.getItemKind() == 3) {
                    return (Comment)node;
                }
                throw new XQException("Cannot cast DOM Comment Object to " + String.valueOf(xqItemType));
            }
            case 11: {
                if (xqItemType.getItemKind() == 5 || xqItemType.getItemKind() == 4) {
                    return (DocumentFragment)node;
                }
                throw new XQException("Cannot cast DOM Document Fragment Object to " + String.valueOf(xqItemType));
            }
            case 9: {
                if (xqItemType.getItemKind() == 5 || xqItemType.getItemKind() == 4) {
                    return (Document)node;
                }
                throw new XQException("Cannot cast DOM Document Object to " + String.valueOf(xqItemType));
            }
            case 1: {
                if (xqItemType.getItemKind() == 7) {
                    return (Element)node;
                }
                throw new XQException("Cannot cast DOM Element Object to " + String.valueOf(xqItemType));
            }
            case 7: {
                if (xqItemType.getItemKind() == 10) {
                    return (ProcessingInstruction)node;
                }
                throw new XQException("Cannot cast DOM ProcessingInstruction Object to " + String.valueOf(xqItemType));
            }
            case 3: {
                if (xqItemType.getItemKind() == 11) {
                    return (Text)node;
                }
                throw new XQException("Cannot cast DOM Text Object to " + String.valueOf(xqItemType));
            }
        }
        throw new XQException("Cannot cast DOM Object (" + String.valueOf(node) + ") to " + String.valueOf(xqItemType));
    }

    public static final Object castToObjectBasedOnType(QName qname, XQItemType xqItemType) throws XQException {
        if (xqItemType.getBaseType() == 28) {
            return qname;
        }
        return XQToolkit.castToObjectBasedOnType(qname.toString(), xqItemType);
    }

    public static final Object castToObjectBasedOnType(XMLGregorianCalendar calendar, XQItemType xqItemType) throws XQException {
        if (xqItemType.getBaseType() == 16 || xqItemType.getBaseType() == 30 || xqItemType.getBaseType() == 11 || xqItemType.getBaseType() == 25 || xqItemType.getBaseType() == 24 || xqItemType.getBaseType() == 23 || xqItemType.getBaseType() == 21 || xqItemType.getBaseType() == 22) {
            return calendar;
        }
        return XQToolkit.castToObjectBasedOnType(calendar.toString(), xqItemType);
    }

    public static final Object castToObjectBasedOnType(Duration duration, XQItemType xqItemType) throws XQException {
        if (XQToolkit.isDerivedFromRestriction(19, xqItemType.getItemType().getBaseType())) {
            return duration;
        }
        return XQToolkit.castToObjectBasedOnType(duration.toString(), xqItemType);
    }

    public static final Object castToObjectBasedOnType(byte[] b, XQItemType xqItemType) throws XQException {
        if (xqItemType.getBaseType() == 26) {
            return b;
        }
        if (xqItemType.getBaseType() == 26) {
            return b;
        }
        throw new XQException("Cannot cast byte[] to " + String.valueOf(xqItemType) + ".");
    }

    public static final Object castToObjectBasedOnType(Boolean bool, XQItemType xqItemType) throws XQException {
        if (xqItemType.getBaseType() == 10) {
            return bool;
        }
        if (XQToolkit.isDerivedFromRestriction(17, xqItemType.getItemType().getBaseType()) || XQToolkit.isDerivedFromRestriction(20, xqItemType.getItemType().getBaseType()) || XQToolkit.isDerivedFromRestriction(18, xqItemType.getItemType().getBaseType())) {
            return XQToolkit.castToObjectBasedOnType(bool != false ? 1 : 0, xqItemType);
        }
        return XQToolkit.castToObjectBasedOnType(bool.toString(), xqItemType);
    }

    public static final Object castToObjectBasedOnType(Number number, XQItemType xqItemType) throws XQException {
        if (xqItemType.getBaseType() == 31) {
            if (number instanceof Byte) {
                return number;
            }
            if (number.shortValue() > 127 || number.shortValue() < -128) {
                throw new XQException("Can not cast.");
            }
            return number.byteValue();
        }
        if (xqItemType.getBaseType() == 14) {
            if (number instanceof Short) {
                return number;
            }
            if (number.intValue() > Short.MAX_VALUE || number.intValue() < Short.MIN_VALUE) {
                throw new XQException("Can not cast.");
            }
            return number.shortValue();
        }
        if (xqItemType.getBaseType() == 12) {
            if (number instanceof Integer) {
                return number;
            }
            if (number.longValue() > Integer.MAX_VALUE || number.longValue() < Integer.MIN_VALUE) {
                throw new XQException("Can not cast.");
            }
            return number.intValue();
        }
        if (xqItemType.getBaseType() == 15) {
            if (number instanceof Long) {
                return number;
            }
            if (number instanceof BigInteger) {
                BigInteger bigValue = (BigInteger)number;
                BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
                BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
                if (bigValue.compareTo(MIN_LONG) >= 0 && bigValue.compareTo(MAX_LONG) <= 0) {
                    return number.longValue();
                }
                throw new XQException("Can not cast.");
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigValue = (BigDecimal)number;
                BigDecimal MAX_LONG = BigDecimal.valueOf(Long.MAX_VALUE);
                BigDecimal MIN_LONG = BigDecimal.valueOf(Long.MIN_VALUE);
                if (bigValue.compareTo(MIN_LONG) >= 0 && bigValue.compareTo(MAX_LONG) <= 0) {
                    return number.longValue();
                }
                throw new XQException("Can not cast.");
            }
            return number.longValue();
        }
        if (xqItemType.getBaseType() == 20) {
            if (number instanceof Float) {
                return number;
            }
            if (number.doubleValue() > 3.4028234663852886E38 || number.doubleValue() < (double)1.4E-45f) {
                throw new XQException("Can not cast.");
            }
            return Float.valueOf(number.floatValue());
        }
        if (xqItemType.getBaseType() == 18) {
            if (number instanceof Double) {
                return number;
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigValue = (BigDecimal)number;
                BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
                BigDecimal MIN_DOUBLE = BigDecimal.valueOf(Double.MIN_VALUE);
                if (bigValue.compareTo(MIN_DOUBLE) >= 0 && bigValue.compareTo(MAX_DOUBLE) <= 0) {
                    return number.doubleValue();
                }
                throw new XQException("Can not cast.");
            }
            if (number instanceof BigInteger) {
                BigInteger bigValue = (BigInteger)number;
                BigInteger MAX_DOUBLE = BigInteger.valueOf(Long.MAX_VALUE);
                BigInteger MIN_DOUBLE = BigInteger.valueOf(0L);
                if (bigValue.compareTo(MIN_DOUBLE) >= 0 && bigValue.compareTo(MAX_DOUBLE) <= 0) {
                    return number.doubleValue();
                }
                throw new XQException("Can not cast.");
            }
            return number.doubleValue();
        }
        if (xqItemType.getBaseType() == 17) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            if (number instanceof Float || number instanceof Double) {
                return BigDecimal.valueOf(number.doubleValue());
            }
            return BigDecimal.valueOf(number.longValue());
        }
        if (xqItemType.getBaseType() == 13) {
            if (number instanceof BigInteger) {
                return number;
            }
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (xqItemType.getBaseType() == 34) {
            BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
            if (bigInteger.compareTo(BigInteger.ZERO) >= 0) {
                throw new XQException("Can not cast.");
            }
            return bigInteger;
        }
        if (xqItemType.getBaseType() == 33) {
            BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
            if (bigInteger.compareTo(BigInteger.ZERO) == -1) {
                throw new XQException("Can not cast.");
            }
            return bigInteger;
        }
        if (xqItemType.getBaseType() == 32) {
            BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
            if (bigInteger.compareTo(BigInteger.ZERO) == 1) {
                throw new XQException("Can not cast.");
            }
            return bigInteger;
        }
        if (xqItemType.getBaseType() == 35) {
            BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
            if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
                throw new XQException("Can not cast.");
            }
            return bigInteger;
        }
        if (xqItemType.getBaseType() == 39) {
            if (number.intValue() > Short.MAX_VALUE || number.intValue() < 0) {
                throw new XQException("Can not cast.");
            }
            return number.shortValue();
        }
        if (xqItemType.getBaseType() == 38) {
            if (number.longValue() > Integer.MAX_VALUE || number.longValue() < 0L) {
                throw new XQException("Can not cast.");
            }
            return number.intValue();
        }
        if (xqItemType.getBaseType() == 37) {
            if (number instanceof BigInteger) {
                BigInteger bigValue = (BigInteger)number;
                BigInteger MAX_UNSIGNED_INT = BigInteger.valueOf(Long.MAX_VALUE);
                BigInteger MIN_UNSIGNED_INT = BigInteger.ZERO;
                if (bigValue.compareTo(MIN_UNSIGNED_INT) >= 0 && bigValue.compareTo(MAX_UNSIGNED_INT) <= 0) {
                    return number.longValue();
                }
                throw new XQException("Can not cast.");
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigValue = (BigDecimal)number;
                BigDecimal MAX_UNSIGNED_INT = BigDecimal.valueOf(Long.MAX_VALUE);
                BigDecimal MIN_UNSIGNED_INT = BigDecimal.ZERO;
                if (bigValue.compareTo(MIN_UNSIGNED_INT) >= 0 && bigValue.compareTo(MAX_UNSIGNED_INT) <= 0) {
                    return number.longValue();
                }
                throw new XQException("Can not cast.");
            }
            Long longValue = number.longValue();
            if (longValue < 0L) {
                throw new XQException("Can not cast.");
            }
            return longValue;
        }
        if (xqItemType.getBaseType() == 36) {
            BigInteger bigInteger = number instanceof BigInteger ? (BigInteger)number : (number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : BigInteger.valueOf(number.longValue()));
            BigInteger MAX_UNSIGNED_LONG = new BigInteger("FFFFFFFFFFFFFFFF", 16);
            BigInteger MIN_UNSIGNED_LONG = BigInteger.ZERO;
            if (bigInteger.compareTo(MIN_UNSIGNED_LONG) >= 0 && bigInteger.compareTo(MAX_UNSIGNED_LONG) <= 0) {
                return bigInteger;
            }
            throw new XQException("Can not cast.");
        }
        if (xqItemType.getBaseType() == 10) {
            return number.intValue() == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return XQToolkit.castToObjectBasedOnType(number.toString(), xqItemType);
    }

    public static final Object castToObjectBasedOnType(String string, XQItemType xqItemType) throws XQException {
        block90: {
            if (xqItemType.getBaseType() == 29) {
                return string;
            }
            if (XQToolkit.isDerivedFromRestriction(41, xqItemType.getBaseType())) {
                string = XQToolkit.getTokenizedString(string);
            } else if (XQToolkit.isDerivedFromRestriction(40, xqItemType.getBaseType())) {
                string = XQToolkit.getNormalizedString(string);
            }
            try {
                Pattern xs_language = Pattern.compile("([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]{1,8})(-[a-zA-Z]{1,8})*");
                Pattern xs_Name = Pattern.compile("[_:A-Za-z][-._:A-Za-z0-9]*");
                Pattern xs_NMToken = Pattern.compile("[-._:A-Za-z0-9]+");
                Pattern xs_NCName = Pattern.compile("[_A-Za-z][-._A-Za-z0-9]*");
                if (xqItemType.getBaseType() == 42) {
                    Matcher matcher = xs_language.matcher(string);
                    if (!matcher.matches()) {
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 43) {
                    Matcher matcher = xs_Name.matcher(string);
                    if (!matcher.matches()) {
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 45) {
                    Matcher matcher = xs_NMToken.matcher(string);
                    if (!matcher.matches()) {
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 44 || xqItemType.getBaseType() == 46 || xqItemType.getBaseType() == 47 || xqItemType.getBaseType() == 48) {
                    Matcher matcher = xs_NCName.matcher(string);
                    if (!matcher.matches()) {
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 51) {
                    StringTokenizer st = new StringTokenizer(string);
                    while (st.hasMoreTokens()) {
                        Matcher matcher = xs_NMToken.matcher(st.nextToken());
                        if (matcher.matches()) continue;
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 49) {
                    StringTokenizer st = new StringTokenizer(string);
                    while (st.hasMoreTokens()) {
                        Matcher matcher = xs_NCName.matcher(st.nextToken());
                        if (matcher.matches()) continue;
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 50) {
                    StringTokenizer st = new StringTokenizer(string);
                    while (st.hasMoreTokens()) {
                        Matcher matcher = xs_NCName.matcher(st.nextToken());
                        if (matcher.matches()) continue;
                        throw new XQException("Can not cast.");
                    }
                    return string;
                }
                if (xqItemType.getBaseType() == 31) {
                    return Byte.valueOf(string);
                }
                if (xqItemType.getBaseType() == 14) {
                    return Short.valueOf(string);
                }
                if (xqItemType.getBaseType() == 12) {
                    return Integer.valueOf(string);
                }
                if (xqItemType.getBaseType() == 15) {
                    return Long.valueOf(string);
                }
                if (xqItemType.getBaseType() == 20) {
                    return Float.valueOf(string);
                }
                if (xqItemType.getBaseType() == 18) {
                    return Double.valueOf(string);
                }
                if (xqItemType.getBaseType() == 17) {
                    return new BigDecimal(string);
                }
                if (xqItemType.getBaseType() == 13) {
                    return new BigInteger(string);
                }
                if (xqItemType.getBaseType() == 34) {
                    return XQToolkit.castToObjectBasedOnType(new BigInteger(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 33) {
                    return XQToolkit.castToObjectBasedOnType(new BigInteger(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 32) {
                    return XQToolkit.castToObjectBasedOnType(new BigInteger(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 35) {
                    return XQToolkit.castToObjectBasedOnType(new BigInteger(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 39) {
                    return XQToolkit.castToObjectBasedOnType(Short.valueOf(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 38) {
                    return XQToolkit.castToObjectBasedOnType(Integer.valueOf(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 37) {
                    return XQToolkit.castToObjectBasedOnType(Long.valueOf(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 36) {
                    return XQToolkit.castToObjectBasedOnType(new BigInteger(string), xqItemType);
                }
                if (xqItemType.getBaseType() == 10) {
                    return XQToolkit.parseXSDBoolean(string);
                }
                if (xqItemType.getBaseType() == 28) {
                    String[] parts = (string = XQToolkit.getTokenizedString(string)).split(":");
                    if (parts.length == 0 || parts.length > 2) {
                        throw new XQException("Invalid QName string.");
                    }
                    if (parts.length > 0 && !xs_NCName.matcher(parts[0]).matches()) {
                        throw new XQException("Can not cast.");
                    }
                    if (parts.length > 1 && !xs_NCName.matcher(parts[1]).matches()) {
                        throw new XQException("Can not cast.");
                    }
                    if (parts.length == 1) {
                        return new QName(parts[0]);
                    }
                    if (parts.length == 2) {
                        return new QName("", parts[1], parts[0]);
                    }
                    break block90;
                }
                if (xqItemType.getBaseType() == 27) {
                    throw new XQException("xs:NOTATION is not supported.");
                }
                if (xqItemType.getBaseType() == 8) {
                    return string;
                }
                if (xqItemType.getBaseType() == 9) {
                    try {
                        return XQToolkit.getByteArrayFromBase64(string);
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem occured parsing Base64. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 26) {
                    return XQToolkit.hexStringToByteArray(string);
                }
                if (xqItemType.getBaseType() == 19) {
                    try {
                        Duration duration = DurationImpl.parse(string);
                        return duration;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:duration string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 6) {
                    try {
                        Duration duration = DurationImpl.parse(string);
                        return duration;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:dayTimeDuration string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 7) {
                    try {
                        Duration duration = DurationImpl.parse(string);
                        return duration;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:yearMonthDuration string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 16) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.DATETIME)) {
                            throw new XQException("value not a valid xs:dateTime.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:dateTime string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 30) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.TIME)) {
                            throw new XQException("value not a valid xs:time.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:time string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 11) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.DATE)) {
                            throw new XQException("value not a valid xs:date.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:date string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 25) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.GYEARMONTH)) {
                            throw new XQException("value not a valid xs:gYearMonth.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:gYearMonth string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 24) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.GYEAR)) {
                            throw new XQException("value not a valid xs:gYear.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:gYear string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 23) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.GMONTHDAY)) {
                            throw new XQException("value not a valid xs:gMonthDay.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:gMonthDay string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 21) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.GDAY)) {
                            throw new XQException("value not a valid xs:gDay.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:gDay string. " + e.getMessage());
                    }
                }
                if (xqItemType.getBaseType() == 22) {
                    try {
                        XMLGregorianCalendar calendar = XMLGregorianCalendarImpl.parse(string);
                        if (!calendar.getXMLSchemaType().equals(DatatypeConstants.GMONTH)) {
                            throw new XQException("value not a valid xs:gMonth.");
                        }
                        return calendar;
                    }
                    catch (IllegalArgumentException e) {
                        throw new XQException("Problem parsing xs:gMonth string. " + e.getMessage());
                    }
                }
                return string;
            }
            catch (NumberFormatException e) {
                throw new XQException("Could not cast string to number.");
            }
        }
        return string;
    }

    public static final char[] escapeXQueryString(char[] string) {
        return XQToolkit.escapeXQueryString(string, 0, string.length);
    }

    public static final char[] escapeXQueryString(char[] string, int offset, int length) {
        TextContainer container = new TextContainer();
        char[] quot = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        char[] apos = new char[]{'&', 'a', 'p', 'o', 's', ';'};
        int strLength = Math.min(offset + length, string.length);
        int i = offset;
        while (i < strLength) {
            switch (string[i]) {
                case '\"': {
                    container.append(quot);
                    break;
                }
                case '\'': {
                    container.append(apos);
                    break;
                }
                default: {
                    container.append(string[i]);
                }
            }
            ++i;
        }
        return container.toCharArray();
    }

    public static final int getIntegerFromString(char[] c, int offset, int length) {
        int result = 0;
        int i = offset;
        while (i < offset + length) {
            result = result * 10 + (c[i] - 48);
            ++i;
        }
        return result;
    }

    public static final boolean startsWith(byte[] entire, byte[] substring) {
        if (substring.length > entire.length) {
            return false;
        }
        int i = 0;
        while (i < substring.length) {
            if (substring[i] != entire[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean startsWith(byte[] entire, int offset, byte[] substring) {
        if (substring.length > offset + entire.length) {
            return false;
        }
        int i = 0;
        while (i < substring.length) {
            if (substring[i] != entire[offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int getIntegerFromString(byte[] c, int offset, int length) {
        int result = 0;
        int i = offset;
        while (i < offset + length) {
            result = result * 10 + (c[i] - 48);
            ++i;
        }
        return result;
    }

    public static final String removeQuotes(String string) {
        if ((string = string.trim()).charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return string.substring(1, string.length() - 1);
        }
        throw new RuntimeException("Expected String literal \"" + string + "\" to be within quotes (\" or ').");
    }

    public static final String getInQuotes(String string) {
        StringBuffer buffer = new StringBuffer();
        char quoteCharacter = '\"';
        if (string.indexOf(34) != -1) {
            quoteCharacter = '\'';
        }
        boolean replace = false;
        if (quoteCharacter == '\'' && string.indexOf(39) != -1) {
            quoteCharacter = '\"';
            replace = true;
        }
        buffer.append(quoteCharacter);
        if (replace) {
            int n;
            int fromIndex = 0;
            while ((n = string.indexOf(34, fromIndex)) != -1) {
                buffer.append(string.substring(fromIndex, n));
                buffer.append("\"\"");
                fromIndex = n + 1;
            }
            buffer.append(string.substring(fromIndex, string.length()));
        } else {
            buffer.append(string);
        }
        buffer.append(quoteCharacter);
        return buffer.toString();
    }

    public static final int read(InputStream in, byte[] buffer, int offset, int length) throws XQException {
        return ReoToolkit.getInstance().read(in, buffer, offset, length);
    }

    public static byte[] forceRead(byte[] smallBuffer, InputStream in) throws XQException {
        return ReoToolkit.getInstance().forceRead(smallBuffer, in);
    }

    public static final byte[] forceRead(InputStream in) throws XQException {
        return ReoToolkit.getInstance().forceRead(in);
    }

    public static final char[] forceRead(Reader reader) throws XQException {
        return ReoToolkit.getInstance().forceRead(reader);
    }

    public static final InputStream loadResource(String path) {
        try {
            InputStream in = new XQToolkit().getClass().getResourceAsStream(path);
            if (in != null) {
                return in;
            }
            throw new NullPointerException();
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error, could not load jar resource '" + path + "'.");
        }
    }

    public static final byte[] loadResourceToByteArray(String path) {
        try {
            InputStream in = XQToolkit.loadResource(path);
            byte[] b = new byte[in.available()];
            in.read(b);
            return b;
        }
        catch (IOException e) {
            throw new RuntimeException("XQJTO007: IOException occurred. Failed to load resource \"" + path + "\".", e);
        }
    }

    public static final void loadProperties(Properties properties, InputStream in) throws XQException {
        SAXParser parser = Factory.newSAXParser();
        try {
            try {
                parser.parse(in, (DefaultHandler)PropertiesHandler.newInstance(properties));
            }
            catch (SAXException e) {
                throw new XQExceptionImpl("SAX Exception occurred whilst reading http://www.xqj.net/ properties document.", "XQJTO009", e);
            }
            catch (IOException e) {
                throw new XQExceptionImpl("IOException Exception occurred whilst reading http://www.xqj.net/ properties document.", "XQJTO010", e);
            }
        }
        finally {
            parser = null;
        }
    }

    private static final void buildDefaultMessageFormatter() {
        try {
            defaultMessageFormatter = MessageFormatter.newInstance(XQToolkit.loadResource("/resources/lang_en.txt"));
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error. Could not load vital Message Formatting resource '/resources/lang_en.txt'.", e);
        }
    }

    public static final String getBaseUri(URL url) {
        String host = url.getHost();
        String path = url.getPath();
        String prot = url.getProtocol();
        int lastIndexOf = path.lastIndexOf(47);
        if (lastIndexOf + 1 == path.length()) {
            return prot + "://" + host + path;
        }
        return prot + "://" + host + path.substring(0, lastIndexOf);
    }

    public static final void writeItemAsStringToContentHandler(XQItem xqItem, ContentHandler saxhdlr) throws SAXException, XQException {
        String itemAsString = xqItem.getItemAsString(null);
        saxhdlr.characters(itemAsString.toCharArray(), 0, itemAsString.length());
        saxhdlr.characters(LINE_BREAK, 0, LINE_BREAK.length);
    }

    public static final Source createSource(InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    public static final Source createSource(InputStream inputStream, String baseURI) {
        return new StreamSource(inputStream, baseURI);
    }

    public static final Source createSource(Reader reader, String baseURI) {
        return new StreamSource(reader, baseURI);
    }

    public static final Source createSource(Reader reader) {
        return new StreamSource(reader);
    }

    public static final Source createSource(Node node) {
        return new DOMSource(node);
    }

    public static final Source createSource(String xmlDocument) {
        return XQToolkit.createSource(new StringReader(xmlDocument));
    }

    public static final Source createSource(String xmlDocument, String baseURI) {
        return XQToolkit.createSource(new StringReader(xmlDocument), baseURI);
    }

    public static final Source createSource(XMLStreamReader reader) {
        return new StAXSource(reader);
    }

    public static final Result createResult(Writer writer) {
        return new StreamResult(writer);
    }

    public static final Result createResult(OutputStream out) {
        return new StreamResult(out);
    }

    public static final Result createResult(ContentHandler handler) {
        return new SAXResult(handler);
    }

    public static final boolean isToWriteXQuery(Properties properties) {
        return properties != null && "{http://www.xqj.net/}xquery".equals(properties.getProperty("method"));
    }

    public static final Properties tryToIgnoreXMLProcessing(Properties properties) {
        return properties != null ? properties : Constants.IGNORE_XML_PROCESSING_PROPERTIES;
    }

    public static final boolean isToIgnoreXMLProcessing(Properties properties) {
        return properties == null || "{http://www.xqj.net/}no-xml-processing".equals(properties.getProperty("method"));
    }

    public static final char[] parseXML(InputStream in, String baseURI) throws XQException {
        return XQToolkit.parseXML(in, baseURI, true);
    }

    public static final char[] parseXML(Reader reader, String baseURI) throws XQException {
        return XQToolkit.parseXML(reader, baseURI, true);
    }

    public static final char[] parseXML(String string, String baseURI) throws XQException {
        return XQToolkit.parseXML(string, baseURI, true);
    }

    public static final char[] parseXML(InputStream in, String baseURI, boolean wellFormedCheck) throws XQException {
        char[] characters = XQToolkit.getUTF8CharArray(XQToolkit.forceRead(in));
        if (wellFormedCheck) {
            XQToolkit.transform(Factory.newSource(new String(characters), baseURI), Factory.newResult(EmptyPrintWriter.getInstance()));
        }
        return characters;
    }

    public static final char[] parseXML(Reader reader, String baseURI, boolean wellFormedCheck) throws XQException {
        char[] characters = XQToolkit.forceRead(reader);
        if (wellFormedCheck) {
            XQToolkit.transform(Factory.newSource(new CharArrayReader(characters), baseURI), Factory.newResult(EmptyPrintWriter.getInstance()));
        }
        return characters;
    }

    public static final char[] parseXML(char[] characters, String baseURI, boolean wellFormedCheck) throws XQException {
        return XQToolkit.parseXML(characters, 0, characters.length, baseURI, wellFormedCheck);
    }

    public static final char[] parseXML(char[] characters, int offset, int length, String baseURI, boolean wellFormedCheck) throws XQException {
        if (wellFormedCheck) {
            XQToolkit.transform(Factory.newSource(new CharArrayReader(characters, offset, length), baseURI), Factory.newResult(EmptyPrintWriter.getInstance()));
        }
        return characters;
    }

    public static final char[] parseXML(String string, String baseURI, boolean wellFormedCheck) throws XQException {
        if (wellFormedCheck) {
            XQToolkit.transform(Factory.newSource(new StringReader(string), baseURI), Factory.newResult(EmptyPrintWriter.getInstance()));
        }
        return string.toCharArray();
    }

    public static final char[] parseXML(XMLStreamReader reader) throws XQException {
        TextContainer text = new TextContainer();
        SAX2CharArray contentHandler = new SAX2CharArray(text);
        XMLStreamReaderToContentHandler handler = new XMLStreamReaderToContentHandler(reader, contentHandler, false, false);
        try {
            handler.bridge();
        }
        catch (XMLStreamException e) {
            throw new XQExceptionImpl("Exception reading from XMLStreamReader.", "XQJ6022", e);
        }
        return text.toCharArray();
    }

    public static final char[] parseXML(Source source) throws XQException {
        if (source instanceof StAXSource) {
            return XQToolkit.parseXML(((StAXSource)source).getXMLStreamReader());
        }
        CharArrayWriter writer = new CharArrayWriter();
        XQToolkit.transform(source, Factory.newResult(writer));
        return writer.toCharArray();
    }

    public static final void writeXML(char[] xml, OutputStream out, Properties props) throws XQException {
        XQToolkit.writeXML((Reader)new CharArrayReader(xml), out, props);
    }

    public static final void writeXML(char[] xml, Writer out, Properties props) throws XQException {
        XQToolkit.writeXML(xml, 0, xml.length, out, props);
    }

    public static final void writeXML(char[] xml, int offset, int length, Writer out, Properties props) throws XQException {
        XQToolkit.writeXML((Reader)new CharArrayReader(xml, offset, length), out, props);
    }

    public static final void writeXML(char[] xml, Result result) throws XQException {
        XQToolkit.writeXML(xml, 0, xml.length, result);
    }

    public static final void writeXML(char[] xml, int offset, int length, Result result) throws XQException {
        XQToolkit.writeXML((Reader)new CharArrayReader(xml, offset, length), result);
    }

    public static final void writeXML(char[] xml, ContentHandler saxhdlr) throws XQException {
        XQToolkit.writeXML(xml, 0, xml.length, saxhdlr);
    }

    public static final void writeXML(char[] xml, int offset, int length, ContentHandler saxhdlr) throws XQException {
        XQToolkit.writeXML((Reader)new CharArrayReader(xml, offset, length), saxhdlr);
    }

    public static final void bridgeReaderToWriter(Reader in, Writer writer) throws XQException {
        char[] buffer = null;
        try {
            try {
                int read;
                buffer = ReoFactory.getInstance().getMediumCBuffer(20480);
                while ((read = in.read(buffer)) != -1) {
                    writer.write(buffer, 0, read);
                }
                writer.flush();
            }
            catch (IOException e) {
                throw new XQExceptionImpl("IOException occured whilst performing IO operations.", "XQJTO015", e);
            }
        }
        finally {
            ReoFactory.getInstance().returnMediumCBuffer(buffer);
        }
    }

    public static final void bridgeReaderToOutputStream(Reader in, OutputStream out, Properties properties) throws XQException {
        boolean writeBOM = false;
        String encoding = null;
        if (properties != null) {
            if ("yes".equals(properties.getProperty("byte-order-mark"))) {
                writeBOM = true;
            }
            encoding = properties.getProperty("encoding");
        }
        XQToolkit.bridgeReaderToWriter(in, Factory.newWriter(out, encoding, writeBOM));
    }

    public static final void writeXML(Reader in, OutputStream out, Properties props) throws XQException {
        if (XQToolkit.isToIgnoreXMLProcessing(props)) {
            XQToolkit.bridgeReaderToOutputStream(in, out, props);
        } else {
            XQToolkit.transform(Factory.newSource(in), Factory.newResult(out), props);
        }
    }

    public static final void writeXML(Reader in, Writer out, Properties props) throws XQException {
        if (XQToolkit.isToIgnoreXMLProcessing(props)) {
            XQToolkit.bridgeReaderToWriter(in, out);
        } else {
            XQToolkit.transform(Factory.newSource(in), Factory.newResult(out), props);
        }
    }

    public static final void writeXML(Reader in, Result result) throws XQException {
        XQToolkit.transform(Factory.newSource(in), result);
    }

    public static final void writeXML(Reader in, ContentHandler saxhdlr) throws XQException {
        XQToolkit.transform(Factory.newSource(in), Factory.newResult(saxhdlr));
    }
}

