/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.basex.query.expr.CmpCache;
import org.basex.query.expr.CmpHashG;
import org.basex.query.expr.ft.FTTokenizer;
import org.basex.query.expr.ft.FTWords;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.PathCache;
import org.basex.query.value.map.XQMap;
import org.basex.util.InputInfo;

public final class QueryThreads {
    private final IdentityHashMap<AxisPath, ThreadLocal<PathCache>> pathCache = new IdentityHashMap();
    private final IdentityHashMap<CmpHashG, ThreadLocal<CmpCache>> cmpCache = new IdentityHashMap();
    private final IdentityHashMap<FTWords, ThreadLocal<FTTokenizer>> ftCache = new IdentityHashMap();
    private final ThreadLocal<Map<String, XQMap>> moduleCache = ThreadLocal.withInitial(HashMap::new);

    public ThreadLocal<PathCache> get(AxisPath expr) {
        return this.pathCache.computeIfAbsent(expr, p -> ThreadLocal.withInitial(PathCache::new));
    }

    public ThreadLocal<CmpCache> get(CmpHashG expr, InputInfo info) {
        return this.cmpCache.computeIfAbsent(expr, p -> ThreadLocal.withInitial(() -> new CmpCache(info)));
    }

    public ThreadLocal<FTTokenizer> get(FTWords expr) {
        return this.ftCache.computeIfAbsent(expr, p -> new ThreadLocal());
    }

    public ThreadLocal<Map<String, XQMap>> moduleCache() {
        return this.moduleCache;
    }

    void close() {
        for (ThreadLocal<PathCache> threadLocal : this.pathCache.values()) {
            threadLocal.remove();
        }
        for (ThreadLocal<Object> threadLocal : this.cmpCache.values()) {
            threadLocal.remove();
        }
        for (ThreadLocal<Object> threadLocal : this.ftCache.values()) {
            threadLocal.remove();
        }
        this.moduleCache.remove();
    }
}

