/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class InvDocTest
extends Test {
    private final Data data;
    private final IntList pres;

    private InvDocTest(IntList pres, Data data) {
        super(NodeType.DOCUMENT_NODE);
        this.pres = pres;
        this.data = data;
    }

    static Test get(Value root) throws QueryException {
        IntList pres;
        Data data = root.data();
        if (data == null || data.meta.ndocs == 1) {
            return NodeTest.DOCUMENT_NODE;
        }
        if (root instanceof DBNodeSeq) {
            DBNodeSeq seq = (DBNodeSeq)root;
            if (seq.all()) {
                return NodeTest.DOCUMENT_NODE;
            }
            pres = new IntList(seq.pres());
        } else {
            pres = new IntList(Seq.initialCapacity(root.size()));
            for (Item item : root) {
                pres.add(((DBNode)item).pre());
            }
        }
        return new InvDocTest(pres.sort(), data);
    }

    @Override
    public Test copy() {
        return new InvDocTest(this.pres, this.data);
    }

    @Override
    public boolean matches(ANode node) {
        DBNode db;
        return node instanceof DBNode && this.data == (db = (DBNode)node).data() && this.pres.sortedIndexOf(db.pre()) >= 0;
    }

    @Override
    public Test intersect(Test test) {
        throw Util.notExpected(this, new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof InvDocTest)) return false;
        InvDocTest idt = (InvDocTest)obj;
        if (this.data != idt.data) return false;
        if (!this.pres.equals(idt.pres)) return false;
        return true;
    }

    @Override
    public String toString(boolean full) {
        return NodeType.DOCUMENT_NODE.toString("(: ids :)");
    }
}

