/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.unit;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.unit.Constants;
import org.basex.query.func.unit.UnitException;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

final class Unit {
    private final Context ctx;
    private final IOFile file;
    private final Job job;
    private String input;
    private StaticFunc current;
    int failures;
    int errors;
    int skipped;
    int tests;

    Unit(IOFile file, Context ctx, Job job) {
        this.file = file;
        this.ctx = ctx;
        this.job = job;
    }

    public void test(FBuilder suites) throws IOException {
        FBuilder suite = FElem.build(Constants.Q_TESTSUITE).add(Constants.Q_NAME, this.file.url());
        ArrayList<StaticFunc> beforeModule = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> afterModule = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> before = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> after = new ArrayList<StaticFunc>(0);
        ArrayList<QNm> beforeFilter = new ArrayList<QNm>();
        ArrayList<QNm> afterFilter = new ArrayList<QNm>();
        ArrayList<StaticFunc> test = new ArrayList<StaticFunc>(0);
        Performance perf = new Performance();
        try (QueryContext qc = new QueryContext(this.ctx);){
            AnnList anns;
            this.input = this.file.readString();
            qc.parse(this.input, this.file.path());
            for (StaticFunc sf : qc.functions) {
                Ann a;
                Ann b;
                anns = sf.anns;
                boolean unit = false;
                for (Ann ann : anns) {
                    Annotation ad = ann.definition;
                    unit = unit || ad != null && Token.eq(ad.name.uri(), QueryText.UNIT_URI);
                }
                if (!unit) continue;
                if (anns.contains(Annotation.PRIVATE)) {
                    throw QueryError.UNIT_PRIVATE_X.get(null, new Object[]{sf.name.local()});
                }
                if (sf.arity() > 0) {
                    throw QueryError.UNIT_NOARGS_X.get(null, new Object[]{sf.name.local()});
                }
                if (anns.contains(Annotation._UNIT_BEFORE_MODULE)) {
                    beforeModule.add(sf);
                }
                if (anns.contains(Annotation._UNIT_AFTER_MODULE)) {
                    afterModule.add(sf);
                }
                if ((b = anns.get(Annotation._UNIT_BEFORE)) != null) {
                    before.add(sf);
                    beforeFilter.add(Unit.name(sf, b));
                }
                if ((a = anns.get(Annotation._UNIT_AFTER)) != null) {
                    after.add(sf);
                    afterFilter.add(Unit.name(sf, a));
                }
                if (!anns.contains(Annotation._UNIT_TEST)) continue;
                test.add(sf);
            }
            for (StaticFunc sf : beforeModule) {
                this.eval(sf);
            }
            for (StaticFunc sf : test) {
                anns = sf.anns;
                Ann ann = anns.get(Annotation._UNIT_TEST);
                Value value = ann.value();
                long vs = value.size();
                QNm code = null;
                if (vs == 2L && Token.eq(Constants.Q_EXPECTED.string(), value.itemAt(0L).string(null))) {
                    code = QNm.parse(value.itemAt(1L).string(null), QueryText.ERROR_URI, sf.sc, sf.info);
                } else if (vs != 0L) {
                    throw QueryError.BASEX_ANN2_X_X.get(ann.info, ann, QueryError.arity(QueryError.arguments(vs), new IntList().add(0)));
                }
                FBuilder testcase = FElem.build(Constants.Q_TESTCASE).add(Constants.Q_NAME, sf.name.local());
                ++this.tests;
                Performance perf2 = new Performance();
                Ann ignore = anns.get(Annotation._UNIT_IGNORE);
                if (ignore == null) {
                    try {
                        QNm name;
                        int i;
                        int l = before.size();
                        for (i = 0; i < l; ++i) {
                            name = (QNm)beforeFilter.get(i);
                            if (name != null && !name.eq(sf.name)) continue;
                            this.eval((StaticFunc)before.get(i));
                        }
                        this.eval(sf);
                        l = after.size();
                        for (i = 0; i < l; ++i) {
                            name = (QNm)afterFilter.get(i);
                            if (name != null && !name.eq(sf.name)) continue;
                            this.eval((StaticFunc)after.get(i));
                        }
                        if (code != null) {
                            ++this.failures;
                            testcase.add(FElem.build(Constants.Q_FAILURE).add(FElem.build(Constants.Q_EXPECTED).add(code.prefixId())));
                        }
                    }
                    catch (QueryException ex) {
                        this.addError(ex, testcase, code);
                    }
                } else {
                    Value ignored = ignore.value();
                    testcase.add(Constants.Q_SKIPPED, ignored.isEmpty() ? Token.EMPTY : ignored.itemAt(0L).string(null));
                    ++this.skipped;
                }
                suite.add(testcase.add(Constants.Q_TIME, Unit.time(perf2)));
            }
            for (StaticFunc sf : afterModule) {
                this.eval(sf);
            }
        }
        catch (QueryException ex) {
            if (this.current == null) {
                this.addError(ex, suite, null);
            }
            FBuilder init = FElem.build(Constants.Q_TESTINIT).add(Constants.Q_NAME, this.current.name.local()).add(Constants.Q_TIME, Unit.time(perf));
            this.addError(ex, init, null);
            suite.add(init);
        }
        if (!suite.isEmpty()) {
            suites.add(suite.add(Constants.Q_TIME, Unit.time(perf)).add(Constants.Q_TESTS, this.tests).add(Constants.Q_FAILURES, this.failures).add(Constants.Q_ERRORS, this.errors).add(Constants.Q_SKIPPED, this.skipped));
        }
    }

    private static QNm name(StaticFunc sf, Ann ann) throws QueryException {
        byte[] name;
        Value value = ann.value();
        if (!value.isEmpty() && (name = value.itemAt(0L).string(null)).length != 0) {
            return QNm.parse(name, sf.name.uri(), sf.sc, sf.info);
        }
        return null;
    }

    private void addError(QueryException ex, FBuilder testcase, QNm code) {
        QNm name = ex.qname();
        if (code == null || !code.eq(name)) {
            FBuilder error;
            boolean fail = QueryError.UNIT_FAIL.eq(name);
            if (fail) {
                ++this.failures;
                error = FElem.build(Constants.Q_FAILURE);
            } else {
                ++this.errors;
                error = FElem.build(Constants.Q_ERROR);
            }
            error.add(Constants.Q_LINE, ex.line()).add(Constants.Q_COLUMN, ex.column());
            String url = IO.get(ex.path()).url();
            if (!this.file.url().equals(url)) {
                error.add(Constants.Q_URI, url);
            }
            if (ex instanceof UnitException) {
                UnitException ue = (UnitException)ex;
                error.add(Unit.element(ue.returned, Constants.Q_RETURNED, ue.count));
                error.add(Unit.element(ue.expected, Constants.Q_EXPECTED, ue.count));
            } else if (!fail) {
                error.add(Constants.Q_TYPE, ex.qname().prefixId(QueryText.ERROR_URI));
            }
            Value value = ex.value();
            if (value != null && value.size() == 1L) {
                error.add(Unit.element((Item)value, Constants.Q_INFO, -1));
            } else {
                error.add(FElem.build(Constants.Q_INFO).add(ex.getLocalizedMessage()));
            }
            testcase.add(error);
        }
    }

    private static FBuilder element(Item item, QNm name, int count) {
        FBuilder elem = FElem.build(name);
        if (item != null) {
            if (item instanceof ANode) {
                ANode node = (ANode)item;
                elem.add(node);
            } else {
                try {
                    elem.add(item.string(null));
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                    elem.add(item);
                }
            }
            if (count != -1) {
                elem.add(Constants.Q_ITEM, count).add(Constants.Q_TYPE, item.type);
            }
        }
        return elem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eval(StaticFunc func) throws QueryException {
        this.current = func;
        try (QueryContext qc = this.job.pushJob(new QueryContext(this.ctx));){
            qc.parse(this.input, this.file.path());
            qc.assign(func, new Expr[0]);
            Iter iter = qc.iter();
            while (qc.next(iter) != null) {
            }
        }
        finally {
            this.job.popJob();
        }
    }

    static byte[] time(Performance p) {
        return DTDur.get(p.nanoRuntime() / 1000000L).string(null);
    }
}

