/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.cmd.Open;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPStatus;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTDelete;
import org.basex.http.rest.RESTGet;
import org.basex.http.rest.RESTPost;
import org.basex.http.rest.RESTPut;
import org.basex.http.rest.RESTSession;
import org.basex.query.QueryException;
import org.basex.util.http.Method;

public final class RESTServlet
extends BaseXServlet {
    @Override
    protected void run(HTTPConnection conn) throws Exception {
        RESTCmd cmd;
        block4: {
            RESTSession session = new RESTSession(conn);
            String db = conn.db();
            String path = conn.dbpath();
            if (!db.isEmpty()) {
                session.add((Command)new Open(db, path));
            }
            cmd = RESTServlet.command(session);
            try {
                cmd.execute(conn.context);
                conn.log(200, "");
            }
            catch (BaseXException ex) {
                if (cmd.status != null) break block4;
                throw ex;
            }
        }
        HTTPStatus status = cmd.status;
        if (status != null) {
            throw status.get(cmd.info());
        }
    }

    private static RESTCmd command(RESTSession session) throws QueryException, IOException {
        String method = session.conn.method;
        if (method.equals(Method.GET.name())) {
            return RESTGet.get(session);
        }
        if (method.equals(Method.POST.name())) {
            return RESTPost.get(session);
        }
        if (method.equals(Method.PUT.name())) {
            return RESTPut.get(session);
        }
        if (method.equals(Method.DELETE.name())) {
            return RESTDelete.get(session);
        }
        throw HTTPStatus.METHOD_NOT_SUPPORTED_X.get(session.conn.request.getMethod());
    }
}

