/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SingletonCodec<T>
implements ObjectCodec<T> {
    private final T value;
    private final byte[] mnemonic;

    public static <T> SingletonCodec<T> of(T value, String mnemonic) {
        return new SingletonCodec<T>(value, mnemonic);
    }

    private SingletonCodec(T value, String mnemonic) {
        this.value = Preconditions.checkNotNull(value, (Object)"SingletonCodec cannot represent null");
        this.mnemonic = mnemonic.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Class<T> getEncodedClass() {
        return this.value.getClass();
    }

    @Override
    public void serialize(T t, CodedOutputStream codedOut) throws IOException {
        codedOut.writeByteArrayNoTag(this.mnemonic);
    }

    @Override
    public T deserialize(CodedInputStream codedIn) throws SerializationException, IOException {
        ByteBuffer readMnemonic = codedIn.readByteBuffer();
        if (!SingletonCodec.bytesEqual(this.mnemonic, readMnemonic)) {
            throw new SerializationException("Failed to decode singleton " + this.value + " expected " + Arrays.toString(this.mnemonic));
        }
        return this.value;
    }

    private static boolean bytesEqual(byte[] expected, ByteBuffer buffer) {
        if (buffer.remaining() != expected.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == buffer.get(i)) continue;
            return false;
        }
        return true;
    }
}

