/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.client.MapKeyBasedClientRequest;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapEvictRequest
extends MapKeyBasedClientRequest
implements Portable,
SecureRequest {
    private Data key;
    private long threadId;

    public MapEvictRequest() {
    }

    public MapEvictRequest(String name, Data key, long threadId) {
        super(name);
        this.key = key;
        this.threadId = threadId;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        MapOperation operation = this.getOperationProvider().createEvictOperation(this.name, this.key, false);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.threadId = reader.readLong("t");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "evict";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }
}

