/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.InjectingObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class AutoCodecUtil {
    public static final String GENERATED_CLASS_NAME_SUFFIX = "AutoCodec";
    static final Class<AutoCodec> ANNOTATION = AutoCodec.class;

    AutoCodecUtil() {
    }

    static TypeSpec.Builder initializeCodecClassBuilder(TypeElement encodedType) {
        return AutoCodecUtil.initializeCodecClassBuilder(encodedType, null);
    }

    static TypeSpec.Builder initializeCodecClassBuilder(TypeElement encodedType, @Nullable TypeElement dependency) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)AutoCodecUtil.getCodecName(encodedType));
        if (dependency == null) {
            return builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ObjectCodec.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)encodedType.asType())}));
        }
        return builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(InjectingObjectCodec.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)encodedType.asType()), TypeName.get((TypeMirror)dependency.asType())}));
    }

    static MethodSpec.Builder initializeGetEncodedClassMethod(TypeElement encodedType) {
        return MethodSpec.methodBuilder((String)"getEncodedClass").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)encodedType.asType())}));
    }

    static MethodSpec.Builder initializeSerializeMethodBuilder(TypeElement encodedType) {
        return AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, null);
    }

    static MethodSpec.Builder initializeSerializeMethodBuilder(TypeElement encodedType, @Nullable TypeElement dependency) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addException(SerializationException.class).addException(IOException.class);
        if (dependency != null) {
            builder.addParameter(TypeName.get((TypeMirror)dependency.asType()), "dependency", new Modifier[0]);
        }
        return builder.addParameter(TypeName.get((TypeMirror)encodedType.asType()), "input", new Modifier[0]).addParameter(CodedOutputStream.class, "codedOut", new Modifier[0]);
    }

    static MethodSpec.Builder initializeDeserializeMethodBuilder(TypeElement encodedType) {
        return AutoCodecUtil.initializeDeserializeMethodBuilder(encodedType, null);
    }

    static MethodSpec.Builder initializeDeserializeMethodBuilder(TypeElement encodedType, @Nullable TypeElement dependency) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)encodedType.asType())).addAnnotation(Override.class).addException(SerializationException.class).addException(IOException.class);
        if (dependency != null) {
            builder.addParameter(TypeName.get((TypeMirror)dependency.asType()), "dependency", new Modifier[0]);
        }
        return builder.addParameter(CodedInputStream.class, "codedIn", new Modifier[0]);
    }

    private static String getCodecName(Element element) {
        ImmutableList.Builder classNamesBuilder = new ImmutableList.Builder();
        classNamesBuilder.add((Object)GENERATED_CLASS_NAME_SUFFIX);
        do {
            classNamesBuilder.add((Object)element.getSimpleName().toString());
        } while ((element = element.getEnclosingElement()) instanceof TypeElement);
        return classNamesBuilder.build().reverse().stream().collect(Collectors.joining("_"));
    }
}

