/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Optional;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import javax.annotation.Nullable;

public final class GuavaOptionalSubject
extends Subject<GuavaOptionalSubject, Optional<?>> {
    GuavaOptionalSubject(FailureMetadata metadata, @Nullable Optional<?> actual) {
        super(metadata, actual);
    }

    public void isPresent() {
        if (this.actual() == null || !((Optional)this.actual()).isPresent()) {
            this.failWithoutActual("is present");
        }
    }

    public void isAbsent() {
        if (this.actual() == null || ((Optional)this.actual()).isPresent()) {
            this.fail("is absent");
        }
    }

    public void hasValue(Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (this.actual() == null || !((Optional)this.actual()).isPresent()) {
            this.fail("has value", expected);
        } else {
            Object actual = ((Optional)this.actual()).get();
            if (!actual.equals(expected)) {
                if (actual.toString().equals(expected.toString())) {
                    this.failWithRawMessage("Not true that %s (%s) has value <%s> (%s)", this.actualAsString(), actual.getClass(), expected, expected.getClass());
                } else {
                    this.fail("has value", expected);
                }
            }
        }
    }
}

