/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeKind;

@BugPattern(name="JUnit3FloatingPointComparisonWithoutDelta", summary="Floating-point comparison without error tolerance", explanation="Use assertEquals(expected, actual, delta) to compare floating-point numbers. This call to assertEquals() will either fail or not compile in JUnit 4. Use assertEquals(expected, actual, 0.0) if the delta must be 0.", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class JUnit3FloatingPointComparisonWithoutDelta
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_EQUALS_MATCHER = MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("assertEquals");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!ASSERT_EQUALS_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        List<Type> argumentTypes = this.getArgumentTypesWithoutMessage(methodInvocationTree, state);
        if (this.canBeConvertedToJUnit4(state, argumentTypes)) {
            return Description.NO_MATCH;
        }
        Fix fix = this.addDeltaArgument(methodInvocationTree, state, argumentTypes);
        return this.describeMatch(methodInvocationTree, fix);
    }

    private List<Type> getArgumentTypesWithoutMessage(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ArrayList<Type> argumentTypes = new ArrayList<Type>();
        for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
            JCTree tree = (JCTree)((Object)expressionTree);
            argumentTypes.add(tree.type);
        }
        this.removeMessageArgumentIfPresent(state, argumentTypes);
        return argumentTypes;
    }

    private void removeMessageArgumentIfPresent(VisitorState state, List<Type> argumentTypes) {
        Type firstType;
        if (argumentTypes.size() == 2) {
            return;
        }
        Types types = state.getTypes();
        if (types.isSameType(firstType = argumentTypes.get(0), state.getSymtab().stringType)) {
            argumentTypes.remove(0);
        }
    }

    private boolean canBeConvertedToJUnit4(VisitorState state, List<Type> argumentTypes) {
        if (argumentTypes.size() > 2) {
            return true;
        }
        Type firstType = argumentTypes.get(0);
        Type secondType = argumentTypes.get(1);
        if (!this.isFloatingPoint(state, firstType) && !this.isFloatingPoint(state, secondType)) {
            return true;
        }
        if (!this.isNumeric(state, firstType) || !this.isNumeric(state, secondType)) {
            return true;
        }
        return !firstType.isPrimitive() && !secondType.isPrimitive();
    }

    private boolean isFloatingPoint(VisitorState state, Type type) {
        Type trueType = this.unboxedTypeOrType(state, type);
        return trueType.getKind() == TypeKind.DOUBLE || trueType.getKind() == TypeKind.FLOAT;
    }

    private boolean isNumeric(VisitorState state, Type type) {
        Type trueType = this.unboxedTypeOrType(state, type);
        return trueType.isNumeric();
    }

    private Type unboxedTypeOrType(VisitorState state, Type type) {
        Types types = state.getTypes();
        return types.unboxedTypeOrType(type);
    }

    private Fix addDeltaArgument(MethodInvocationTree methodInvocationTree, VisitorState state, List<Type> argumentTypes) {
        int insertionIndex = this.getDeltaInsertionIndex(methodInvocationTree, state);
        String deltaArgument = this.getDeltaArgument(state, argumentTypes);
        return SuggestedFix.replace((int)insertionIndex, (int)insertionIndex, (String)deltaArgument);
    }

    private int getDeltaInsertionIndex(MethodInvocationTree methodInvocationTree, VisitorState state) {
        JCTree lastArgument = (JCTree)Iterables.getLast(methodInvocationTree.getArguments());
        return state.getEndPosition((Tree)lastArgument);
    }

    private String getDeltaArgument(VisitorState state, List<Type> argumentTypes) {
        Type firstType = argumentTypes.get(0);
        Type secondType = argumentTypes.get(1);
        boolean doublePrecisionUsed = this.isDouble(state, firstType) || this.isDouble(state, secondType);
        return doublePrecisionUsed ? ", 0.0" : ", 0.0f";
    }

    private boolean isDouble(VisitorState state, Type type) {
        Type trueType = this.unboxedTypeOrType(state, type);
        return trueType.getKind() == TypeKind.DOUBLE;
    }
}

