/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.EqualsIncompatibleType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.function.Predicate;

@BugPattern(name="PredicateIncompatibleType", category=BugPattern.Category.JDK, summary="Using ::equals as an incompatible Predicate; the predicate will always return false", severity=BugPattern.SeverityLevel.ERROR)
public class PredicateIncompatibleType
extends BugChecker
implements BugChecker.MemberReferenceTreeMatcher {
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!tree.getName().contentEquals("equals")) {
            return Description.NO_MATCH;
        }
        Type predicateType = PredicateIncompatibleType.predicateType(ASTHelpers.getType((Tree)tree), state);
        Type receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
        if (EqualsIncompatibleType.compatibilityOfTypes(receiverType, predicateType, state).compatible()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("Using %s::equals as Predicate<%s>; the predicate will always return false", Signatures.prettyType((Type)receiverType), Signatures.prettyType((Type)predicateType))).build();
    }

    private static Type predicateType(Type type, VisitorState state) {
        Symbol predicate = state.getSymbolFromString(Predicate.class.getName());
        if (predicate == null) {
            return null;
        }
        Type asPredicate = state.getTypes().asSuper(type, predicate);
        if (asPredicate == null) {
            return null;
        }
        return (Type)Iterables.getOnlyElement(asPredicate.getTypeArguments(), null);
    }
}

