/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.ElementPredicates;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JavaxInjectOnFinalField", summary="@javax.inject.Inject cannot be put on a final field.", explanation="According to the JSR-330 spec, the @javax.inject.Inject annotation cannot go on final fields.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class JavaxInjectOnFinalField
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    public Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (InjectMatchers.IS_APPLICATION_OF_JAVAX_INJECT.matches((Tree)annotationTree, state) && ElementPredicates.isFinalField(ASTHelpers.getSymbol((Tree)state.getPath().getParentPath().getParentPath().getLeaf()))) {
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.delete((Tree)annotationTree));
        }
        return Description.NO_MATCH;
    }
}

