/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.type.Type;
import com.google.turbine.types.Canonicalize;
import java.util.Map;

public class CanonicalTypeBinder {
    static SourceTypeBoundClass bind(ClassSymbol sym, SourceTypeBoundClass base, Env<ClassSymbol, TypeBoundClass> env) {
        Type.ClassTy superClassType = null;
        if (base.superClassType() != null) {
            superClassType = Canonicalize.canonicalizeClassTy(env, base.owner(), base.superClassType());
        }
        ImmutableList.Builder interfaceTypes = ImmutableList.builder();
        for (Type.ClassTy i : base.interfaceTypes()) {
            interfaceTypes.add((Object)Canonicalize.canonicalizeClassTy(env, base.owner(), i));
        }
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typParamTypes = CanonicalTypeBinder.typeParameters(env, sym, base.typeParameterTypes());
        ImmutableList<TypeBoundClass.MethodInfo> methods = CanonicalTypeBinder.methods(env, sym, base.methods());
        ImmutableList<TypeBoundClass.FieldInfo> fields = CanonicalTypeBinder.fields(env, sym, base.fields());
        return new SourceTypeBoundClass((ImmutableList<Type.ClassTy>)interfaceTypes.build(), superClassType, typParamTypes, base.access(), methods, fields, base.owner(), base.kind(), base.children(), base.typeParameters(), base.enclosingScope(), base.scope(), base.memberImports(), base.annotationMetadata(), base.annotations(), base.source());
    }

    private static ImmutableList<TypeBoundClass.FieldInfo> fields(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<TypeBoundClass.FieldInfo> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo base : fields) {
            result.add((Object)new TypeBoundClass.FieldInfo(base.sym(), Canonicalize.canonicalize(env, sym, base.type()), base.access(), base.annotations(), base.decl(), base.value()));
        }
        return result.build();
    }

    private static ImmutableList<TypeBoundClass.MethodInfo> methods(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<TypeBoundClass.MethodInfo> methods) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.MethodInfo base : methods) {
            ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> tps = CanonicalTypeBinder.typeParameters(env, sym, base.tyParams());
            Type ret = Canonicalize.canonicalize(env, sym, base.returnType());
            ImmutableList.Builder parameters = ImmutableList.builder();
            for (TypeBoundClass.ParamInfo parameter : base.parameters()) {
                parameters.add((Object)CanonicalTypeBinder.param(env, sym, parameter));
            }
            ImmutableList<Type> exceptions = CanonicalTypeBinder.canonicalizeList(env, sym, base.exceptions());
            result.add((Object)new TypeBoundClass.MethodInfo(base.sym(), tps, ret, (ImmutableList<TypeBoundClass.ParamInfo>)parameters.build(), exceptions, base.access(), base.defaultValue(), base.decl(), base.annotations(), base.receiver() != null ? CanonicalTypeBinder.param(env, sym, base.receiver()) : null));
        }
        return result.build();
    }

    private static TypeBoundClass.ParamInfo param(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, TypeBoundClass.ParamInfo base) {
        return new TypeBoundClass.ParamInfo(Canonicalize.canonicalize(env, sym, base.type()), base.name(), base.annotations(), base.access());
    }

    private static ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameters(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Map<TyVarSymbol, TypeBoundClass.TyVarInfo> tps) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<TyVarSymbol, TypeBoundClass.TyVarInfo> e : tps.entrySet()) {
            TypeBoundClass.TyVarInfo info = e.getValue();
            Type superClassBound = null;
            if (info.superClassBound() != null) {
                superClassBound = Canonicalize.canonicalize(env, sym, info.superClassBound());
            }
            ImmutableList<Type> interfaceBounds = CanonicalTypeBinder.canonicalizeList(env, sym, info.interfaceBounds());
            result.put((Object)e.getKey(), (Object)new TypeBoundClass.TyVarInfo(superClassBound, interfaceBounds, info.annotations()));
        }
        return result.build();
    }

    private static ImmutableList<Type> canonicalizeList(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add((Object)Canonicalize.canonicalize(env, sym, type));
        }
        return result.build();
    }
}

