/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.ByteArrayEntrySource;
import com.android.builder.internal.packaging.zip.CentralDirectoryHeader;
import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.DataDescriptorType;
import com.android.builder.internal.packaging.zip.EntrySource;
import com.android.builder.internal.packaging.zip.InflaterEntrySource;
import com.android.builder.internal.packaging.zip.StoredEntryType;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZipField;
import com.android.builder.internal.packaging.zip.ZipFieldInvariant;
import com.android.builder.internal.packaging.zip.ZipFieldInvariantNonNegative;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class StoredEntry {
    private static final int DATA_DESC_SIGNATURE = 134695760;
    private static final ZipField.F4 F_LOCAL_SIGNATURE = new ZipField.F4(0, 67324752L, "Signature");
    private static final ZipField.F2 F_VERSION_EXTRACT = new ZipField.F2(F_LOCAL_SIGNATURE.endOffset(), "Version to extract", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_GP_BIT = new ZipField.F2(F_VERSION_EXTRACT.endOffset(), "GP bit flag", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_METHOD = new ZipField.F2(F_GP_BIT.endOffset(), "Compression method", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_LAST_MOD_TIME = new ZipField.F2(F_METHOD.endOffset(), "Last modification time", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_LAST_MOD_DATE = new ZipField.F2(F_LAST_MOD_TIME.endOffset(), "Last modification date", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_CRC32 = new ZipField.F4(F_LAST_MOD_DATE.endOffset(), "CRC32", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_COMPRESSED_SIZE = new ZipField.F4(F_CRC32.endOffset(), "Compressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F4 F_UNCOMPRESSED_SIZE = new ZipField.F4(F_COMPRESSED_SIZE.endOffset(), "Uncompressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_FILE_NAME_LENGTH = new ZipField.F2(F_UNCOMPRESSED_SIZE.endOffset(), "@File name length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_EXTRA_LENGTH = new ZipField.F2(F_FILE_NAME_LENGTH.endOffset(), "Extra length", new ZipFieldInvariantNonNegative());
    private static final int FIXED_LOCAL_FILE_HEADER_SIZE = F_EXTRA_LENGTH.endOffset();
    private StoredEntryType mType;
    private CentralDirectoryHeader mCdh;
    private ZFile mFile;
    private boolean mDeleted;
    private byte[] mLocalExtra;
    private DataDescriptorType mDataDescriptorType;
    private EntrySource mSource;

    StoredEntry(CentralDirectoryHeader header, ZFile file) throws IOException {
        this.mCdh = header;
        this.mFile = file;
        this.mDeleted = false;
        if (header.getOffset() >= 0L) {
            this.readLocalHeader();
            this.mSource = this.createSourceFromZip();
        } else {
            this.mSource = new ByteArrayEntrySource(new byte[0]);
            this.mLocalExtra = new byte[0];
        }
        if (this.mCdh.getName().endsWith(Character.toString('/'))) {
            this.mType = StoredEntryType.DIRECTORY;
            Verify.verify((this.mSource.size() == 0L ? 1 : 0) != 0, (String)"Directory source has %s bytes.", (Object[])new Object[]{this.mSource.size()});
            Verify.verify((this.mCdh.getCrc32() == 0L ? 1 : 0) != 0, (String)"Directory has CRC32 = %s.", (Object[])new Object[]{this.mCdh.getCrc32()});
            Verify.verify((this.mCdh.getUncompressedSize() == 0L ? 1 : 0) != 0, (String)"Directory has uncompressed size = %s.", (Object[])new Object[]{this.mCdh.getUncompressedSize()});
            Verify.verify((this.mCdh.getCompressedSize() == 0L ? 1 : 0) != 0, (String)"Directory has compressed size = %s.", (Object[])new Object[]{this.mCdh.getCompressedSize()});
        } else {
            this.mType = StoredEntryType.FILE;
        }
        this.mDataDescriptorType = DataDescriptorType.NO_DATA_DESCRIPTOR;
        if (header.getGpBit().isDeferredCrc()) {
            Verify.verify((header.getOffset() >= 0L ? 1 : 0) != 0, (String)"Files that are not on disk cannot have the deferred CRC bit set.", (Object[])new Object[0]);
            this.readDataDescriptorRecord();
        }
    }

    int getLocalHeaderSize() {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        return FIXED_LOCAL_FILE_HEADER_SIZE + this.mCdh.getName().length() + this.mLocalExtra.length;
    }

    long getInFileSize() {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        return this.mCdh.getCompressedSize() + (long)this.getLocalHeaderSize() + (long)this.mDataDescriptorType.size;
    }

    public InputStream open() throws IOException {
        return this.mSource.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() throws IOException {
        InputStream is = this.open();
        boolean threw = true;
        try {
            byte[] r = ByteStreams.toByteArray((InputStream)is);
            threw = false;
            byte[] byArray = r;
            return byArray;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)threw);
        }
    }

    public StoredEntryType getType() {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        return this.mType;
    }

    public void delete() throws IOException {
        this.delete(true);
    }

    void delete(boolean notify) throws IOException {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        this.mFile.delete(this, notify);
        this.mDeleted = true;
    }

    public CentralDirectoryHeader getCentralDirectoryHeader() {
        return this.mCdh;
    }

    private void readLocalHeader() throws IOException {
        byte[] localHeader = new byte[FIXED_LOCAL_FILE_HEADER_SIZE];
        this.mFile.directFullyRead(this.mCdh.getOffset(), localHeader);
        ByteSource byteSource = ByteSource.wrap((byte[])localHeader);
        F_LOCAL_SIGNATURE.verify(byteSource);
        F_VERSION_EXTRACT.verify(byteSource, this.mCdh.getVersionExtract());
        F_GP_BIT.verify(byteSource, this.mCdh.getGpBit().getValue());
        F_METHOD.verify(byteSource, this.mCdh.getMethod().methodCode);
        F_LAST_MOD_TIME.verify(byteSource, this.mCdh.getLastModTime());
        F_LAST_MOD_DATE.verify(byteSource, this.mCdh.getLastModDate());
        if (this.mCdh.getGpBit().isDeferredCrc()) {
            F_CRC32.verify(byteSource, 0L);
            F_COMPRESSED_SIZE.verify(byteSource, 0L);
            F_UNCOMPRESSED_SIZE.verify(byteSource, 0L);
        } else {
            F_CRC32.verify(byteSource, this.mCdh.getCrc32());
            F_COMPRESSED_SIZE.verify(byteSource, this.mCdh.getCompressedSize());
            F_UNCOMPRESSED_SIZE.verify(byteSource, this.mCdh.getUncompressedSize());
        }
        F_FILE_NAME_LENGTH.verify(byteSource, this.mCdh.getName().length());
        long extraLength = F_EXTRA_LENGTH.read(byteSource);
        long fileNameStart = this.mCdh.getOffset() + (long)F_EXTRA_LENGTH.endOffset();
        byte[] fileNameData = new byte[this.mCdh.getName().length()];
        this.mFile.directFullyRead(fileNameStart, fileNameData);
        String fileName = new String(fileNameData, Charsets.US_ASCII);
        if (!fileName.equals(this.mCdh.getName())) {
            throw new IOException("Central directory reports file as being named '" + this.mCdh.getName() + "' but local header reports file being named '" + fileName + "'.");
        }
        long localExtraStart = fileNameStart + (long)fileName.length();
        this.mLocalExtra = new byte[Ints.checkedCast((long)extraLength)];
        this.mFile.directFullyRead(localExtraStart, this.mLocalExtra);
    }

    private void readDataDescriptorRecord() throws IOException {
        long ddStart = this.mCdh.getOffset() + (long)FIXED_LOCAL_FILE_HEADER_SIZE + (long)this.mCdh.getName().length() + (long)this.mLocalExtra.length + this.mCdh.getCompressedSize();
        byte[] ddData = new byte[DataDescriptorType.DATA_DESCRIPTOR_WITH_SIGNATURE.size];
        this.mFile.directFullyRead(ddStart, ddData);
        ByteSource ddSource = ByteSource.wrap((byte[])ddData);
        ZipField.F4 signatureField = new ZipField.F4(0, "Data descriptor signature", new ZipFieldInvariant[0]);
        long sig = signatureField.read(ddSource);
        if (sig == 134695760L) {
            this.mDataDescriptorType = DataDescriptorType.DATA_DESCRIPTOR_WITH_SIGNATURE;
            ddSource = ddSource.slice(4L, ddSource.size());
        } else {
            this.mDataDescriptorType = DataDescriptorType.DATA_DESCRIPTOR_WITHOUT_SIGNATURE;
        }
        ZipField.F4 crc32Field = new ZipField.F4(0, "CRC32", new ZipFieldInvariant[0]);
        ZipField.F4 compressedField = new ZipField.F4(crc32Field.endOffset(), "CRC32", new ZipFieldInvariant[0]);
        ZipField.F4 uncompressedField = new ZipField.F4(compressedField.endOffset(), "CRC32", new ZipFieldInvariant[0]);
        crc32Field.verify(ddSource, this.mCdh.getCrc32());
        compressedField.verify(ddSource, this.mCdh.getCompressedSize());
        uncompressedField.verify(ddSource, this.mCdh.getUncompressedSize());
    }

    void setSource(EntrySource source) {
        Preconditions.checkArgument((source.size() == this.mCdh.getUncompressedSize() ? 1 : 0) != 0, (String)"Source has incorrect size (source size is %s, uncompressed size is %s)", (Object[])new Object[]{source.size(), this.mCdh.getUncompressedSize()});
        this.mSource = source;
    }

    EntrySource createSourceFromZip() {
        Preconditions.checkState((this.mCdh.getOffset() >= 0L ? 1 : 0) != 0, (Object)"No data in zip. Cannot create source.");
        EntrySource source = new EntrySource(){

            @Override
            public InputStream open() throws IOException {
                Preconditions.checkState((!StoredEntry.this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
                long dataStart = StoredEntry.this.mCdh.getOffset() + (long)StoredEntry.this.getLocalHeaderSize();
                long dataEnd = dataStart + StoredEntry.this.mCdh.getCompressedSize();
                return StoredEntry.this.mFile.directOpen(dataStart, dataEnd);
            }

            @Override
            public long size() {
                return StoredEntry.this.mCdh.getCompressedSize();
            }

            @Override
            public EntrySource innerCompressed() {
                return null;
            }
        };
        if (this.mCdh.getMethod() == CompressionMethod.DEFLATE) {
            source = new InflaterEntrySource(source, this.mCdh.getUncompressedSize());
        }
        return source;
    }

    EntrySource getSource() {
        return this.mSource;
    }

    public DataDescriptorType getDataDescriptorType() {
        return this.mDataDescriptorType;
    }

    byte[] toHeaderData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        F_LOCAL_SIGNATURE.write(out);
        F_VERSION_EXTRACT.write(out, this.mCdh.getVersionExtract());
        F_GP_BIT.write(out, this.mCdh.getGpBit().getValue());
        F_METHOD.write(out, this.mCdh.getMethod().methodCode);
        F_LAST_MOD_TIME.write(out, this.mCdh.getLastModTime());
        F_LAST_MOD_DATE.write(out, this.mCdh.getLastModDate());
        F_CRC32.write(out, this.mCdh.getCrc32());
        F_COMPRESSED_SIZE.write(out, this.mCdh.getCompressedSize());
        F_UNCOMPRESSED_SIZE.write(out, this.mCdh.getUncompressedSize());
        F_FILE_NAME_LENGTH.write(out, this.mCdh.getName().length());
        F_EXTRA_LENGTH.write(out, this.mLocalExtra.length);
        out.write(this.mCdh.getName().getBytes(Charsets.US_ASCII));
        out.write(this.mLocalExtra);
        return out.toByteArray();
    }

    public boolean realign() throws IOException {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"Entry has been deleted.");
        return this.mFile.realign(this);
    }
}

