/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.truth.AbstractFailureStrategy;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@GwtIncompatible(value="JUnit4")
public final class Expect
extends StandardSubjectBuilder
implements TestRule {
    private final ExpectationGatherer gatherer;
    private boolean inRuleContext = false;

    public static Expect create() {
        return new Expect(new ExpectationGatherer(false));
    }

    public static Expect createAndEnableStackTrace() {
        return new Expect(new ExpectationGatherer(true));
    }

    private Expect(ExpectationGatherer gatherer) {
        super(FailureMetadata.forFailureStrategy(gatherer));
        this.gatherer = (ExpectationGatherer)Preconditions.checkNotNull((Object)gatherer);
    }

    public boolean hasFailures() {
        return !this.gatherer.getFailures().isEmpty();
    }

    @Override
    void checkStatePreconditions() {
        Preconditions.checkState((boolean)this.inRuleContext, (Object)"assertion made on Expect instance, but it's not enabled as a @Rule.");
    }

    public Statement apply(final Statement base, Description description) {
        Preconditions.checkNotNull((Object)base);
        Preconditions.checkNotNull((Object)description);
        return new Statement(){

            public void evaluate() throws Throwable {
                block7: {
                    Expect.this.inRuleContext = true;
                    try {
                        base.evaluate();
                    }
                    catch (Throwable t) {
                        if (!Expect.this.gatherer.getFailures().isEmpty()) {
                            String message = t instanceof AssumptionViolatedException ? "Failures occurred before an assumption was violated" : "Failures occurred before an exception was thrown while the test was running";
                            Expect.this.gatherer.fail(message + ": " + t, t);
                            break block7;
                        }
                        throw t;
                    }
                    finally {
                        Expect.this.inRuleContext = false;
                    }
                }
                if (!Expect.this.gatherer.getFailures().isEmpty()) {
                    throw new AssertionError((Object)Expect.this.gatherer.toString());
                }
            }
        };
    }

    private static final class ExpectationFailure {
        private final String message;
        private final Throwable cause;

        ExpectationFailure(String message, Throwable cause) {
            this.message = (String)Preconditions.checkNotNull((Object)message);
            this.cause = cause;
        }

        String message() {
            return this.message;
        }

        Throwable cause() {
            return this.cause;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof ExpectationFailure) {
                ExpectationFailure that = (ExpectationFailure)other;
                return this.message.equals(that.message) && Objects.equal((Object)this.cause, (Object)that.cause);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.message, this.cause});
        }
    }

    private static final class ExpectationGatherer
    extends AbstractFailureStrategy {
        private final List<ExpectationFailure> messages = new ArrayList<ExpectationFailure>();
        private final boolean showStackTrace;

        ExpectationGatherer(boolean showStackTrace) {
            this.showStackTrace = showStackTrace;
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual, Throwable cause) {
            this.fail(StringUtil.messageFor(message, expected, actual), cause);
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.messages.add(new ExpectationFailure(message, (Throwable)((Object)(cause != null ? new AssertionError((Object)cause) : new AssertionError()))));
        }

        List<ExpectationFailure> getFailures() {
            return this.messages;
        }

        public String toString() {
            StringBuilder message = new StringBuilder("All failed expectations:\n");
            int count = 0;
            for (ExpectationFailure failure : this.getFailures()) {
                message.append("  ");
                message.append(++count);
                message.append(". ");
                message.append(failure.message());
                message.append("\n");
                if (!this.showStackTrace) continue;
                message.append(Throwables.getStackTraceAsString((Throwable)ExpectationGatherer.stripTruthStackFrames(failure.cause())));
                message.append("\n");
            }
            return message.toString();
        }
    }
}

