/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.truth.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

final class SubjectUtils {
    static final String HUMAN_UNDERSTANDABLE_EMPTY_STRING = "\"\" (empty String)";

    private SubjectUtils() {
    }

    static <T> List<T> accumulate(T first, T second, T ... rest) {
        ArrayList<T> items = new ArrayList<T>(2 + (rest == null ? 1 : rest.length));
        items.add(first);
        items.add(second);
        if (rest == null) {
            items.add(null);
        } else {
            items.addAll(Arrays.asList(rest));
        }
        return items;
    }

    static <T> int countOf(T t, Iterable<T> items) {
        int count = 0;
        for (T item : items) {
            if (!(t == null ? item == null : t.equals(item))) continue;
            ++count;
        }
        return count;
    }

    static <T> List<Object> countDuplicates(Iterable<T> items) {
        ArrayList<T> itemSet = new ArrayList<T>();
        for (T item : items) {
            if (itemSet.contains(item)) continue;
            itemSet.add(item);
        }
        Object[] params = new Object[itemSet.size()];
        int n = 0;
        for (Object item : itemSet) {
            int count = SubjectUtils.countOf(item, items);
            params[n++] = count > 1 ? item + " [" + count + " copies]" : item;
        }
        return Arrays.asList(params);
    }

    static String countDuplicatesAndAddTypeInfo(Iterable<?> itemsIterable) {
        Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
        Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
        return homogeneousTypeName.isPresent() ? StringUtil.format("%s (%s)", SubjectUtils.countDuplicates(items), homogeneousTypeName.get()) : SubjectUtils.countDuplicates(SubjectUtils.addTypeInfoToEveryItem(items)).toString();
    }

    static String iterableToStringWithTypeInfo(Iterable<?> itemsIterable) {
        Collection<?> items = SubjectUtils.iterableToCollection(itemsIterable);
        Optional<String> homogeneousTypeName = SubjectUtils.getHomogeneousTypeName(items);
        if (homogeneousTypeName.isPresent()) {
            return StringUtil.format("%s (%s)", items, homogeneousTypeName.get());
        }
        return SubjectUtils.addTypeInfoToEveryItem(items).toString();
    }

    static List<Object> retainMatchingToString(Iterable<?> items, Iterable<?> itemsToCheck) {
        HashMultimap stringValueToItemsToCheck = HashMultimap.create();
        for (Object itemToCheck : itemsToCheck) {
            stringValueToItemsToCheck.put((Object)String.valueOf(itemToCheck), itemToCheck);
        }
        ArrayList result = Lists.newArrayList();
        block1: for (Object item : items) {
            for (Object itemToCheck : stringValueToItemsToCheck.get((Object)String.valueOf(item))) {
                if (Objects.equal(itemToCheck, item)) continue;
                result.add(item);
                continue block1;
            }
        }
        return result;
    }

    static boolean hasMatchingToStringPair(Iterable<?> items1, Iterable<?> items2) {
        return !SubjectUtils.retainMatchingToString(items1, items2).isEmpty();
    }

    static String objectToTypeName(Object item) {
        if (item == null) {
            return "null type";
        }
        if (item instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)item;
            return StringUtil.format("Map.Entry<%s, %s>", SubjectUtils.objectToTypeName(entry.getKey()), SubjectUtils.objectToTypeName(entry.getValue()));
        }
        return item.getClass().getName();
    }

    private static Optional<String> getHomogeneousTypeName(Iterable<?> items) {
        Optional homogeneousTypeName = Optional.absent();
        for (Object item : items) {
            if (item == null) {
                return Optional.absent();
            }
            if (!homogeneousTypeName.isPresent()) {
                homogeneousTypeName = Optional.of((Object)SubjectUtils.objectToTypeName(item));
                continue;
            }
            if (SubjectUtils.objectToTypeName(item).equals(homogeneousTypeName.get())) continue;
            return Optional.absent();
        }
        return homogeneousTypeName;
    }

    private static List<String> addTypeInfoToEveryItem(Iterable<?> items) {
        ArrayList itemsWithTypeInfo = Lists.newArrayList();
        for (Object item : items) {
            itemsWithTypeInfo.add(StringUtil.format("%s (%s)", item, SubjectUtils.objectToTypeName(item)));
        }
        return itemsWithTypeInfo;
    }

    static <T> Collection<T> iterableToCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return Lists.newArrayList(iterable);
    }

    static <T> List<T> iterableToList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return Lists.newArrayList(iterable);
    }

    static <T> Iterable<T> annotateEmptyStrings(Iterable<T> items) {
        if (Iterables.contains(items, (Object)"")) {
            ArrayList annotatedItems = Lists.newArrayList();
            for (T item : items) {
                if (Objects.equal(item, (Object)"")) {
                    String newItem = HUMAN_UNDERSTANDABLE_EMPTY_STRING;
                    annotatedItems.add(newItem);
                    continue;
                }
                annotatedItems.add(item);
            }
            return annotatedItems;
        }
        return items;
    }
}

