---
layout: default
title: Contributing
stylesheet: docs
---

We welcome your contributions! To contribute to Stardoc, fork the [Skydoc][repo]
GitHub repository and start submitting pull requests.

[repo]: https://github.com/bazelbuild/skydoc

## Contributing to Skydoc

In general, we prefer contributions that fix bugs or add features (as opposed to
purely stylistic, refactoring, or "cleanup" changes). Please check with us on
the [bazel-dev][bazel-dev] mailing list or open a GitHub Issue before investing
a lot of time in a patch.

[bazel-dev]: https://groups.google.com/forum/#!forum/bazel-dev

To submit a patch to Skydoc:

* Skydoc is part of the Bazel project. Read the [Bazel governance
  plan](https://www.bazel.build/governance.html) and Skydoc's [contribution
  guidelines](https://github.com/bazelbuild/skydoc/blob/master/CONTRIBUTING.md).
* Open an [Issue](https://github.com/bazelbuild/skydoc/issues) or discuss your
  plan or design on the [bazel-dev][bazel-dev] mailing list.
* Prepare a Git commit that implements your feature or bug fix. Don't forget to
  add tests and reference the corresponding bug, if any.
* Open a [Pull Request][pull-request] on the Skydoc repository. This will
  require that you have signed a [Contributor License Agreement][cla].
* Complete a code review a [core contributor](#core-contributors). Amend your
  patch by making additional commits or rebasing with HEAD if there are
  conflicts with new commits on the master branch.
* Once the code review is complete, your reviewer will squash/merge your pull
  request to the master branch.

[pull-request]: https://github.com/bazelbuild/skydoc/pulls
[cla]: https://cla.developers.google.com/

## Core Contributors

The current group of Stardoc core contributors are:

* [cparsons](https://github.com/c-parsons)
* [laurentlb](https://github.com/laurentlb)


