/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;

@BugPattern(name="ThrowsUncheckedException", summary="Unchecked exceptions do not need to be declared in the method signature.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, generateExamplesFromTestCases=false, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ThrowsUncheckedException
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getThrows().isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList<ExpressionTree> uncheckedExceptions = new ArrayList<ExpressionTree>();
        for (ExpressionTree expressionTree : tree.getThrows()) {
            Type exceptionType = ASTHelpers.getType((Tree)expressionTree);
            if (!ASTHelpers.isSubtype((Type)exceptionType, (Type)state.getSymtab().runtimeExceptionType, (VisitorState)state) && !ASTHelpers.isSubtype((Type)exceptionType, (Type)state.getSymtab().errorType, (VisitorState)state)) continue;
            uncheckedExceptions.add(expressionTree);
        }
        if (uncheckedExceptions.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch((Tree)uncheckedExceptions.get(0), SuggestedFixes.deleteExceptions((MethodTree)tree, (VisitorState)state, uncheckedExceptions));
    }
}

