/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.DelegatingJavaFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformUtils;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class Arguments {
    public static final Context.Key<Arguments> argsKey = new Context.Key();
    private String ownName;
    private Set<String> classNames;
    private Set<Path> files;
    private Map<Option, String> deferredFileManagerOptions;
    private Set<JavaFileObject> fileObjects;
    private boolean emptyAllowed;
    private final Options options;
    private JavaFileManager fileManager;
    private final Log log;
    private final Context context;
    private ErrorMode errorMode;
    private boolean errors;
    private final OptionHelper cmdLineHelper = new OptionHelper(){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String name, String value) {
            Arguments.this.options.put(name, value);
        }

        @Override
        public void remove(String name) {
            Arguments.this.options.remove(name);
        }

        @Override
        public boolean handleFileManagerOption(Option option, String value) {
            Arguments.this.options.put(option, value);
            Arguments.this.deferredFileManagerOptions.put(option, value);
            return true;
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }

        @Override
        public String getOwnName() {
            return Arguments.this.ownName;
        }

        @Override
        public void addFile(Path p) {
            Arguments.this.files.add(p);
        }

        @Override
        public void addClassName(String s) {
            Arguments.this.classNames.add(s);
        }
    };
    private final OptionHelper apiHelper = new OptionHelper.GrumpyHelper(null){

        @Override
        public String get(Option option) {
            return Arguments.this.options.get(option);
        }

        @Override
        public void put(String name, String value) {
            Arguments.this.options.put(name, value);
        }

        @Override
        public void remove(String name) {
            Arguments.this.options.remove(name);
        }

        @Override
        public Log getLog() {
            return Arguments.this.log;
        }
    };

    public static Arguments instance(Context context) {
        Arguments instance = context.get(argsKey);
        if (instance == null) {
            instance = new Arguments(context);
        }
        return instance;
    }

    protected Arguments(Context context) {
        context.put(argsKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
        this.context = context;
    }

    public void init(String ownName, String ... args) {
        this.ownName = ownName;
        this.errorMode = ErrorMode.LOG;
        this.files = new LinkedHashSet<Path>();
        this.deferredFileManagerOptions = new LinkedHashMap<Option, String>();
        this.fileObjects = null;
        this.classNames = new LinkedHashSet<String>();
        this.processArgs(List.from(args), Option.getJavaCompilerOptions(), this.cmdLineHelper, true, false);
        if (this.errors) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", ownName);
        }
    }

    public void init(String ownName, Iterable<String> options, Iterable<String> classNames, Iterable<? extends JavaFileObject> files) {
        this.ownName = ownName;
        this.classNames = this.toSet(classNames);
        this.fileObjects = this.toSet(files);
        this.files = null;
        this.errorMode = ErrorMode.ILLEGAL_ARGUMENT;
        if (options != null) {
            this.processArgs(this.toList(options), Option.getJavacToolOptions(), this.apiHelper, false, true);
        }
        this.errorMode = ErrorMode.ILLEGAL_STATE;
    }

    public void init(String ownName) {
        this.ownName = ownName;
        this.errorMode = ErrorMode.LOG;
    }

    public Set<JavaFileObject> getFileObjects() {
        if (this.fileObjects == null) {
            this.fileObjects = new LinkedHashSet<JavaFileObject>();
        }
        if (this.files != null) {
            JavacFileManager jfm = (JavacFileManager)this.getFileManager();
            for (JavaFileObject javaFileObject : jfm.getJavaFileObjectsFromPaths((Iterable<? extends Path>)this.files)) {
                this.fileObjects.add(javaFileObject);
            }
        }
        return this.fileObjects;
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public boolean handleReleaseOptions(Predicate<Iterable<String>> additionalOptions) {
        String platformString = this.options.get(Option.RELEASE);
        this.checkOptionAllowed(platformString == null, option -> this.error("err.release.bootclasspath.conflict", option.getPrimaryName()), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.XBOOTCLASSPATH_PREPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.SOURCE, Option.TARGET, Option.SYSTEM, Option.UPGRADE_MODULE_PATH);
        if (platformString != null) {
            PlatformDescription platformDescription = PlatformUtils.lookupPlatformDescription(platformString);
            if (platformDescription == null) {
                this.error("err.unsupported.release.version", platformString);
                return false;
            }
            this.options.put(Option.SOURCE, platformDescription.getSourceVersion());
            this.options.put(Option.TARGET, platformDescription.getTargetVersion());
            this.context.put(PlatformDescription.class, platformDescription);
            if (!additionalOptions.test(platformDescription.getAdditionalOptions())) {
                return false;
            }
            JavaFileManager platformFM = platformDescription.getFileManager();
            DelegatingJavaFileManager.installReleaseFileManager(this.context, platformFM, this.getFileManager());
        }
        return true;
    }

    private boolean processArgs(Iterable<String> args, Set<Option> allowableOpts, OptionHelper helper, boolean allowOperands, boolean checkFileManager) {
        if (!this.doProcessArgs(args, allowableOpts, helper, allowOperands, checkFileManager)) {
            return false;
        }
        if (!this.handleReleaseOptions(extra -> this.doProcessArgs((Iterable<String>)extra, allowableOpts, helper, allowOperands, checkFileManager))) {
            return false;
        }
        this.options.notifyListeners();
        return true;
    }

    private boolean doProcessArgs(Iterable<String> args, Set<Option> allowableOpts, OptionHelper helper, boolean allowOperands, boolean checkFileManager) {
        JavaFileManager fm = checkFileManager ? this.getFileManager() : null;
        Iterator<String> argIter = args.iterator();
        while (argIter.hasNext()) {
            String arg = argIter.next();
            if (arg.isEmpty()) {
                this.error("err.invalid.flag", arg);
                return false;
            }
            Option option = null;
            if (arg.startsWith("-")) {
                option = Option.lookup(arg, allowableOpts);
            } else if (allowOperands && Option.SOURCEFILE.matches(arg)) {
                option = Option.SOURCEFILE;
            }
            if (option != null) {
                try {
                    option.handleOption(helper, arg, argIter);
                    continue;
                }
                catch (Option.InvalidValueException e) {
                    this.error(e);
                    return false;
                }
            }
            if (fm != null && fm.handleOption(arg, argIter)) continue;
            this.error("err.invalid.flag", arg);
            return false;
        }
        return true;
    }

    public boolean validate() {
        boolean lintOptions;
        String profileString;
        Target target;
        String sourceString;
        StandardJavaFileManager sfm;
        JavaFileManager fm = this.getFileManager();
        if (this.options.isSet(Option.MODULE)) {
            if (!fm.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                this.log.error(CompilerProperties.Errors.OutputDirMustBeSpecifiedWithDashMOption);
            } else if (!fm.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                this.log.error(CompilerProperties.Errors.ModulesourcepathMustBeSpecifiedWithDashMOption);
            } else {
                java.util.List<String> modules = Arrays.asList(this.options.get(Option.MODULE).split(","));
                try {
                    for (String module : modules) {
                        JavaFileManager.Location sourceLoc = fm.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_SOURCE_PATH, module);
                        if (sourceLoc == null) {
                            this.log.error(CompilerProperties.Errors.ModuleNotFoundInModuleSourcePath(module));
                            continue;
                        }
                        JavaFileManager.Location classLoc = fm.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, module);
                        for (JavaFileObject file : fm.list(sourceLoc, "", EnumSet.of(JavaFileObject.Kind.SOURCE), true)) {
                            String className = fm.inferBinaryName(sourceLoc, file);
                            JavaFileObject classFile = fm.getJavaFileForInput(classLoc, className, JavaFileObject.Kind.CLASS);
                            if (classFile != null && classFile.getLastModified() >= file.getLastModified()) continue;
                            if (this.fileObjects == null) {
                                this.fileObjects = new HashSet<JavaFileObject>();
                            }
                            this.fileObjects.add(file);
                        }
                    }
                }
                catch (IOException ex) {
                    this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
                    ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
                    return false;
                }
            }
        }
        if (this.isEmpty()) {
            if (this.options.isSet(Option.HELP) || this.options.isSet(Option.X) || this.options.isSet(Option.VERSION) || this.options.isSet(Option.FULLVERSION) || this.options.isSet(Option.MODULE)) {
                return true;
            }
            if (!this.emptyAllowed) {
                if (!this.errors) {
                    if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                        this.error("err.no.source.files.classes", new Object[0]);
                    } else {
                        this.error("err.no.source.files", new Object[0]);
                    }
                }
                return false;
            }
        }
        if (!this.checkDirectory(Option.D)) {
            return false;
        }
        if (!this.checkDirectory(Option.S)) {
            return false;
        }
        if (!this.checkDirectory(Option.H)) {
            return false;
        }
        if (fm instanceof StandardJavaFileManager && (sfm = (StandardJavaFileManager)this.fileManager).hasLocation(StandardLocation.CLASS_OUTPUT)) {
            Path outDir = sfm.getLocationAsPaths(StandardLocation.CLASS_OUTPUT).iterator().next();
            if (sfm.hasLocation(StandardLocation.MODULE_SOURCE_PATH)) {
                if (Files.exists(outDir.resolve("module-info.class"), new LinkOption[0])) {
                    this.log.error(CompilerProperties.Errors.MultiModuleOutdirCannotBeExplodedModule(outDir));
                }
            } else {
                Path outDirParent;
                boolean lintPaths = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.PATH.option);
                if (lintPaths && (outDirParent = outDir.getParent()) != null && Files.exists(outDirParent.resolve("module-info.class"), new LinkOption[0])) {
                    this.log.warning(Lint.LintCategory.PATH, CompilerProperties.Warnings.OutdirIsInExplodedModule(outDir));
                }
            }
        }
        Source source = (sourceString = this.options.get(Option.SOURCE)) != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get(Option.TARGET);
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0)) && target.compareTo(source.requiredTarget()) < 0) {
            if (targetString != null) {
                if (sourceString == null) {
                    this.error("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                } else {
                    this.error("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                }
                return false;
            }
            target = source.requiredTarget();
            this.options.put("-target", target.name);
        }
        if ((profileString = this.options.get(Option.PROFILE)) != null) {
            Profile profile = Profile.lookup(profileString);
            if (!profile.isValid(target)) {
                this.error("warn.profile.target.conflict", profileString, target.name);
            }
            if (this.options.get(Option.BOOT_CLASS_PATH) != null) {
                this.error("err.profile.bootclasspath.conflict", new Object[0]);
            }
        }
        if (this.options.isSet(Option.SOURCE_PATH) && this.options.isSet(Option.MODULE_SOURCE_PATH)) {
            this.error("err.sourcepath.modulesourcepath.conflict", new Object[0]);
        }
        if ((lintOptions = this.options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option)) && source.compareTo(Source.DEFAULT) < 0 && !this.options.isSet(Option.RELEASE) && fm instanceof BaseFileManager && ((BaseFileManager)fm).isDefaultBootClassPath()) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.SourceNoBootclasspath(source.name));
        }
        boolean obsoleteOptionFound = false;
        if (source.compareTo(Source.MIN) < 0) {
            this.log.error(CompilerProperties.Errors.OptionRemovedSource(source.name, Source.MIN.name));
        } else if (source == Source.MIN && lintOptions) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteSource(source.name));
            obsoleteOptionFound = true;
        }
        if (target.compareTo(Target.MIN) < 0) {
            this.log.error(CompilerProperties.Errors.OptionRemovedTarget(target.name, Target.MIN.name));
        } else if (target == Target.MIN && lintOptions) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteTarget(target.name));
            obsoleteOptionFound = true;
        }
        Target t = target;
        this.checkOptionAllowed(t.compareTo(Target.JDK1_8) <= 0, option -> this.error("err.option.not.allowed.with.target", option.getPrimaryName(), t.name), Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS, Option.PROFILE);
        this.checkOptionAllowed(t.compareTo(Target.JDK1_9) >= 0, option -> this.error("err.option.not.allowed.with.target", option.getPrimaryName(), t.name), Option.MODULE_SOURCE_PATH, Option.UPGRADE_MODULE_PATH, Option.SYSTEM, Option.MODULE_PATH, Option.ADD_MODULES, Option.ADD_EXPORTS, Option.ADD_OPENS, Option.ADD_READS, Option.LIMIT_MODULES, Option.PATCH_MODULE);
        if (fm.hasLocation(StandardLocation.MODULE_SOURCE_PATH) && !this.options.isSet(Option.PROC, "only") && !fm.hasLocation(StandardLocation.CLASS_OUTPUT)) {
            this.log.error(CompilerProperties.Errors.NoOutputDir);
        }
        if (fm.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) && fm.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH)) {
            this.log.error(CompilerProperties.Errors.ProcessorpathNoProcessormodulepath);
        }
        if (obsoleteOptionFound && lintOptions) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.OptionObsoleteSuppression);
        }
        SourceVersion sv = Source.toSourceVersion(source);
        this.validateAddExports(sv);
        this.validateAddModules(sv);
        this.validateAddReads(sv);
        this.validateLimitModules(sv);
        this.validateDefaultModuleForCreatedFiles(sv);
        if (lintOptions && this.options.isSet(Option.ADD_OPENS)) {
            this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.AddopensIgnored);
        }
        return !this.errors && this.log.nerrors == 0;
    }

    private void validateAddExports(SourceVersion sv) {
        String addExports = this.options.get(Option.ADD_EXPORTS);
        if (addExports != null) {
            Pattern p = Option.ADD_EXPORTS.getPattern();
            for (String e : addExports.split("\u0000")) {
                String sourcePackageName;
                Matcher m = p.matcher(e);
                if (!m.matches()) continue;
                String sourceModuleName = m.group(1);
                if (!SourceVersion.isName(sourceModuleName, sv)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, sourceModuleName));
                }
                if (!SourceVersion.isName(sourcePackageName = m.group(2), sv)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, sourcePackageName));
                }
                String targetNames = m.group(3);
                String[] stringArray = targetNames.split(",");
                int n = stringArray.length;
                block8: for (int i = 0; i < n; ++i) {
                    String targetName;
                    switch (targetName = stringArray[i]) {
                        case "": 
                        case "ALL-UNNAMED": {
                            continue block8;
                        }
                        default: {
                            if (SourceVersion.isName(targetName, sv)) continue block8;
                            this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_EXPORTS, targetName));
                        }
                    }
                }
            }
        }
    }

    private void validateAddReads(SourceVersion sv) {
        String addReads = this.options.get(Option.ADD_READS);
        if (addReads != null) {
            Pattern p = Option.ADD_READS.getPattern();
            for (String e : addReads.split("\u0000")) {
                Matcher m = p.matcher(e);
                if (!m.matches()) continue;
                String sourceName = m.group(1);
                if (!SourceVersion.isName(sourceName, sv)) {
                    this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_READS, sourceName));
                }
                String targetNames = m.group(2);
                String[] stringArray = targetNames.split(",", -1);
                int n = stringArray.length;
                block8: for (int i = 0; i < n; ++i) {
                    String targetName;
                    switch (targetName = stringArray[i]) {
                        case "": 
                        case "ALL-UNNAMED": {
                            continue block8;
                        }
                        default: {
                            if (SourceVersion.isName(targetName, sv)) continue block8;
                            this.log.warning(CompilerProperties.Warnings.BadNameForOption(Option.ADD_READS, targetName));
                        }
                    }
                }
            }
        }
    }

    private void validateAddModules(SourceVersion sv) {
        String addModules = this.options.get(Option.ADD_MODULES);
        if (addModules != null) {
            String[] stringArray = addModules.split(",");
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String moduleName;
                switch (moduleName = stringArray[i]) {
                    case "": 
                    case "ALL-SYSTEM": 
                    case "ALL-MODULE-PATH": {
                        continue block8;
                    }
                    default: {
                        if (SourceVersion.isName(moduleName, sv)) continue block8;
                        this.log.error(CompilerProperties.Errors.BadNameForOption(Option.ADD_MODULES, moduleName));
                    }
                }
            }
        }
    }

    private void validateLimitModules(SourceVersion sv) {
        String limitModules = this.options.get(Option.LIMIT_MODULES);
        if (limitModules != null) {
            String[] stringArray = limitModules.split(",");
            int n = stringArray.length;
            block6: for (int i = 0; i < n; ++i) {
                String moduleName;
                switch (moduleName = stringArray[i]) {
                    case "": {
                        continue block6;
                    }
                    default: {
                        if (SourceVersion.isName(moduleName, sv)) continue block6;
                        this.log.error(CompilerProperties.Errors.BadNameForOption(Option.LIMIT_MODULES, moduleName));
                    }
                }
            }
        }
    }

    private void validateDefaultModuleForCreatedFiles(SourceVersion sv) {
        String moduleName = this.options.get(Option.DEFAULT_MODULE_FOR_CREATED_FILES);
        if (moduleName != null && !SourceVersion.isName(moduleName, sv)) {
            this.log.error(CompilerProperties.Errors.BadNameForOption(Option.DEFAULT_MODULE_FOR_CREATED_FILES, moduleName));
        }
    }

    public boolean isEmpty() {
        return !(this.files != null && !this.files.isEmpty() || this.fileObjects != null && !this.fileObjects.isEmpty() || this.classNames != null && !this.classNames.isEmpty());
    }

    public void allowEmpty() {
        this.emptyAllowed = true;
    }

    public Map<Option, String> getDeferredFileManagerOptions() {
        return this.deferredFileManagerOptions;
    }

    public Set<List<String>> getPluginOpts() {
        String plugins = this.options.get(Option.PLUGIN);
        if (plugins == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<List<String>> pluginOpts = new LinkedHashSet<List<String>>();
        for (String plugin : plugins.split("\\x00")) {
            pluginOpts.add(List.from(plugin.split("\\s+")));
        }
        return Collections.unmodifiableSet(pluginOpts);
    }

    public List<String> getDocLintOpts() {
        String format;
        String xdoclint = this.options.get(Option.XDOCLINT);
        String xdoclintCustom = this.options.get(Option.XDOCLINT_CUSTOM);
        if (xdoclint == null && xdoclintCustom == null) {
            return List.nil();
        }
        LinkedHashSet<Object> doclintOpts = new LinkedHashSet<Object>();
        if (xdoclint != null) {
            doclintOpts.add("-Xmsgs");
        }
        if (xdoclintCustom != null) {
            for (String s : xdoclintCustom.split("\\s+")) {
                if (s.isEmpty()) continue;
                doclintOpts.add("-Xmsgs:" + s);
            }
        }
        if (doclintOpts.equals(Collections.singleton("-Xmsgs:none"))) {
            return List.nil();
        }
        String checkPackages = this.options.get(Option.XDOCLINT_PACKAGE);
        if (checkPackages != null) {
            for (String s : checkPackages.split("\\s+")) {
                doclintOpts.add("-XcheckPackage:" + s);
            }
        }
        if ((format = this.options.get(Option.DOCLINT_FORMAT)) != null) {
            doclintOpts.add("-XhtmlVersion:" + format);
        }
        doclintOpts.add("-XimplicitHeaders:2");
        return List.from(doclintOpts.toArray(new String[doclintOpts.size()]));
    }

    private boolean checkDirectory(Option option) {
        String value = this.options.get(option);
        if (value == null) {
            return true;
        }
        Path file = Paths.get(value, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    void checkOptionAllowed(boolean allowed, ErrorReporter r, Option ... opts) {
        if (!allowed) {
            Stream.of(opts).filter(this.options::isSet).forEach(r::report);
        }
    }

    void error(JCDiagnostic.Error error) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String msg = this.log.localize(error);
                throw new PropagatedException(new IllegalArgumentException(msg));
            }
            case ILLEGAL_STATE: {
                String msg = this.log.localize(error);
                throw new PropagatedException(new IllegalStateException(msg));
            }
            case LOG: {
                this.report(error);
            }
        }
    }

    void error(String key, Object ... args) {
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
                throw new PropagatedException(new IllegalArgumentException(msg));
            }
            case ILLEGAL_STATE: {
                String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
                throw new PropagatedException(new IllegalStateException(msg));
            }
            case LOG: {
                this.report(key, args);
            }
        }
    }

    void error(Option.InvalidValueException f) {
        String msg = f.getMessage();
        this.errors = true;
        switch (this.errorMode) {
            case ILLEGAL_ARGUMENT: {
                throw new PropagatedException(new IllegalArgumentException(msg, f.getCause()));
            }
            case ILLEGAL_STATE: {
                throw new PropagatedException(new IllegalStateException(msg, f.getCause()));
            }
            case LOG: {
                this.log.printRawLines(this.ownName + ": " + msg);
            }
        }
    }

    void warning(String key, Object ... args) {
        this.report(key, args);
    }

    private void report(String key, Object ... args) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, key, args));
    }

    private void report(JCDiagnostic.Error error) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(error));
    }

    private JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = this.context.get(JavaFileManager.class);
        }
        return this.fileManager;
    }

    <T> ListBuffer<T> toList(Iterable<? extends T> items) {
        ListBuffer<T> list = new ListBuffer<T>();
        if (items != null) {
            for (T item : items) {
                list.add(item);
            }
        }
        return list;
    }

    <T> Set<T> toSet(Iterable<? extends T> items) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        if (items != null) {
            for (T item : items) {
                set.add(item);
            }
        }
        return set;
    }

    private static interface ErrorReporter {
        public void report(Option var1);
    }

    private static enum ErrorMode {
        ILLEGAL_ARGUMENT,
        ILLEGAL_STATE,
        LOG;

    }
}

